/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRestoreSnapshotFromClient {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private byte[] emptySnapshot;
    private byte[] snapshotName0;
    private byte[] snapshotName1;
    private byte[] snapshotName2;
    private int snapshot0Rows;
    private int snapshot1Rows;
    private byte[] tableName;
    private HBaseAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = Bytes.toBytes((String)("testtb-" + tid));
        this.emptySnapshot = Bytes.toBytes((String)("emptySnaptb-" + tid));
        this.snapshotName0 = Bytes.toBytes((String)("snaptb0-" + tid));
        this.snapshotName1 = Bytes.toBytes((String)("snaptb1-" + tid));
        this.snapshotName2 = Bytes.toBytes((String)("snaptb2-" + tid));
        this.createTable(this.tableName, new byte[][]{this.FAMILY});
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.emptySnapshot, this.tableName);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.tableName);
        try {
            this.admin.enableTable(this.tableName);
            this.loadData(table, 500, new byte[][]{this.FAMILY});
            this.snapshot0Rows = TEST_UTIL.countRows(table);
            this.admin.disableTable(this.tableName);
            this.admin.snapshot(this.snapshotName0, this.tableName);
            this.admin.enableTable(this.tableName);
            this.loadData(table, 500, new byte[][]{this.FAMILY});
            this.snapshot1Rows = TEST_UTIL.countRows(table);
            this.admin.disableTable(this.tableName);
            this.admin.snapshot(this.snapshotName1, this.tableName);
            this.admin.enableTable(this.tableName);
        }
        finally {
            table.close();
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.admin.tableExists(this.tableName)) {
            TEST_UTIL.deleteTable(this.tableName);
        }
        this.admin.deleteSnapshot(this.snapshotName0);
        this.admin.deleteSnapshot(this.snapshotName1);
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        mfs.getFileSystem().delete(new Path(mfs.getRootDir(), ".archive"), true);
    }

    @Test
    public void testRestoreSnapshot() throws IOException {
        this.verifyRowCount(this.tableName, this.snapshot1Rows);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(this.tableName, this.snapshot0Rows);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.emptySnapshot);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(this.tableName, 0L);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(this.tableName, this.snapshot1Rows);
    }

    @Test
    public void testRestoreSchemaChange() throws IOException {
        byte[] TEST_FAMILY2 = Bytes.toBytes((String)"cf2");
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.tableName);
        this.admin.disableTable(this.tableName);
        this.admin.addColumn(this.tableName, new HColumnDescriptor(TEST_FAMILY2));
        this.admin.enableTable(this.tableName);
        Assert.assertEquals((long)2L, (long)table.getTableDescriptor().getFamilies().size());
        HTableDescriptor htd = this.admin.getTableDescriptor(this.tableName);
        Assert.assertEquals((long)2L, (long)htd.getFamilies().size());
        this.loadData(table, 500, new byte[][]{TEST_FAMILY2});
        long snapshot2Rows = this.snapshot1Rows + 500;
        Assert.assertEquals((long)snapshot2Rows, (long)TEST_UTIL.countRows(table));
        Assert.assertEquals((long)500L, (long)TEST_UTIL.countRows(table, new byte[][]{TEST_FAMILY2}));
        Set<String> fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)2L, (long)fsFamilies.size());
        table.close();
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName2, this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        Assert.assertEquals((long)1L, (long)table.getTableDescriptor().getFamilies().size());
        this.admin.enableTable(this.tableName);
        try {
            TEST_UTIL.countRows(table, new byte[][]{TEST_FAMILY2});
            Assert.fail((String)("family '" + Bytes.toString((byte[])TEST_FAMILY2) + "' should not exists"));
        }
        catch (NoSuchColumnFamilyException e) {
            // empty catch block
        }
        Assert.assertEquals((long)this.snapshot0Rows, (long)TEST_UTIL.countRows(table));
        htd = this.admin.getTableDescriptor(this.tableName);
        Assert.assertEquals((long)1L, (long)htd.getFamilies().size());
        fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)1L, (long)fsFamilies.size());
        table.close();
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName2);
        this.admin.enableTable(this.tableName);
        htd = this.admin.getTableDescriptor(this.tableName);
        Assert.assertEquals((long)2L, (long)htd.getFamilies().size());
        Assert.assertEquals((long)2L, (long)table.getTableDescriptor().getFamilies().size());
        Assert.assertEquals((long)500L, (long)TEST_UTIL.countRows(table, new byte[][]{TEST_FAMILY2}));
        Assert.assertEquals((long)snapshot2Rows, (long)TEST_UTIL.countRows(table));
        fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)2L, (long)fsFamilies.size());
        table.close();
    }

    @Test
    public void testRestoreSnapshotOfCloned() throws IOException, InterruptedException {
        byte[] clonedTableName = Bytes.toBytes((String)("clonedtb-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName0, clonedTableName);
        this.verifyRowCount(clonedTableName, this.snapshot0Rows);
        this.admin.disableTable(clonedTableName);
        this.admin.snapshot(this.snapshotName2, clonedTableName);
        this.admin.deleteTable(clonedTableName);
        this.waitCleanerRun();
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName);
        this.verifyRowCount(clonedTableName, this.snapshot0Rows);
        this.admin.disableTable(clonedTableName);
        this.admin.deleteTable(clonedTableName);
    }

    private void createTable(byte[] tableName, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            htd.addFamily(hcd);
        }
        byte[][] splitKeys = new byte[16][];
        byte[] hex = Bytes.toBytes((String)"0123456789abcdef");
        for (int i = 0; i < 16; ++i) {
            splitKeys[i] = new byte[]{hex[i]};
        }
        this.admin.createTable(htd, (byte[][])splitKeys);
    }

    public void loadData(HTable table, int rows, byte[] ... families) throws IOException {
        byte[] qualifier = Bytes.toBytes((String)"q");
        table.setAutoFlush(false);
        while (rows-- > 0) {
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])Bytes.toBytes((int)rows));
            byte[] key = Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value));
            Put put = new Put(key);
            put.setWriteToWAL(false);
            for (byte[] family : families) {
                put.add(family, qualifier, value);
            }
            table.put(put);
        }
        table.flushCommits();
    }

    private void waitCleanerRun() throws InterruptedException {
        TEST_UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
    }

    private Set<String> getFamiliesFromFS(byte[] tableName) throws IOException {
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        HashSet<String> families = new HashSet<String>();
        Path tableDir = HTableDescriptor.getTableDir((Path)mfs.getRootDir(), (byte[])tableName);
        for (Path regionDir : FSUtils.getRegionDirs((FileSystem)mfs.getFileSystem(), (Path)tableDir)) {
            for (Path familyDir : FSUtils.getFamilyDirs((FileSystem)mfs.getFileSystem(), (Path)regionDir)) {
                families.add(familyDir.getName());
            }
        }
        return families;
    }

    private void verifyRowCount(byte[] tableName, long expectedRows) throws IOException {
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        Assert.assertEquals((long)expectedRows, (long)TEST_UTIL.countRows(table));
        table.close();
    }
}

