/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.HSnapshotDescription;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSnapshotFromAdmin {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFromAdmin.class);

    @Test(timeout=10000L)
    public void testBackoffLogic() throws Exception {
        int maxWaitTime = 7500;
        int numRetries = 10;
        int pauseTime = 500;
        long ignoreExpectedTime = 0L;
        for (int i = 0; i < 6; ++i) {
            ignoreExpectedTime += (long)(HConstants.RETRY_BACKOFF[i] * 500);
        }
        long time = 4050L;
        Assert.assertTrue((String)"Capped snapshot wait time isn't less that the uncapped backoff time - further testing won't prove anything.", (4050L < ignoreExpectedTime ? 1 : 0) != 0);
        HConnectionManager.HConnectionImplementation mockConnection = (HConnectionManager.HConnectionImplementation)Mockito.mock(HConnectionManager.HConnectionImplementation.class);
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.client.retries.number", 10);
        conf.setLong("hbase.client.pause", 500L);
        HMasterInterface mockMaster = (HMasterInterface)Mockito.mock(HMasterInterface.class);
        Mockito.when((Object)mockConnection.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)mockConnection.getMaster()).thenReturn((Object)mockMaster);
        Mockito.when((Object)mockMaster.snapshot((HSnapshotDescription)Mockito.any(HSnapshotDescription.class))).thenReturn((Object)7500L);
        Mockito.when((Object)mockMaster.isSnapshotDone((HSnapshotDescription)Mockito.any(HSnapshotDescription.class))).thenReturn((Object)false, (Object[])new Boolean[]{false, false, false, false, true});
        HBaseAdmin admin = new HBaseAdmin((HConnection)mockConnection);
        String snapshot = "snapshot";
        String table = "table";
        long start = System.currentTimeMillis();
        admin.snapshot(snapshot, table);
        long finish = System.currentTimeMillis();
        long elapsed = finish - start;
        Assert.assertTrue((String)("Elapsed time:" + elapsed + " is more than expected max:" + 4050L), (elapsed <= 4050L ? 1 : 0) != 0);
        admin.close();
    }

    @Test
    public void testValidateSnapshotName() throws Exception {
        HConnectionManager.HConnectionImplementation mockConnection = (HConnectionManager.HConnectionImplementation)Mockito.mock(HConnectionManager.HConnectionImplementation.class);
        Configuration conf = HBaseConfiguration.create();
        Mockito.when((Object)mockConnection.getConfiguration()).thenReturn((Object)conf);
        HBaseAdmin admin = new HBaseAdmin((HConnection)mockConnection);
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        this.failSnapshotStart(admin, builder.setName(".snapshot").build());
        this.failSnapshotStart(admin, builder.setName("-snapshot").build());
        this.failSnapshotStart(admin, builder.setName("snapshot fails").build());
        this.failSnapshotStart(admin, builder.setName("snap$hot").build());
        this.failSnapshotStart(admin, builder.setName("snapshot").setTable(".table").build());
        this.failSnapshotStart(admin, builder.setName("snapshot").setTable("-table").build());
        this.failSnapshotStart(admin, builder.setName("snapshot").setTable("table fails").build());
        this.failSnapshotStart(admin, builder.setName("snapshot").setTable("tab%le").build());
        HMasterInterface master = (HMasterInterface)Mockito.mock(HMasterInterface.class);
        Mockito.when((Object)mockConnection.getMaster()).thenReturn((Object)master);
        Mockito.when((Object)master.snapshot((HSnapshotDescription)Mockito.any(HSnapshotDescription.class))).thenReturn((Object)0L);
        Mockito.when((Object)master.isSnapshotDone((HSnapshotDescription)Mockito.any(HSnapshotDescription.class))).thenReturn((Object)true);
        admin.snapshot(builder.setName("snapshot").setTable("table").build());
    }

    private void failSnapshotStart(HBaseAdmin admin, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        try {
            admin.snapshot(snapshot);
            Assert.fail((String)("Snapshot should not have succeed with name:" + snapshot.getName()));
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Object)("Correctly failed to start snapshot:" + e.getMessage()));
        }
    }
}

