/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterCoprocessorExceptionWithRemove {
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] TEST_TABLE1 = Bytes.toBytes((String)"observed_table1");
    private static byte[] TEST_FAMILY1 = Bytes.toBytes((String)"fam1");
    private static byte[] TEST_TABLE2 = Bytes.toBytes((String)"table2");
    private static byte[] TEST_FAMILY2 = Bytes.toBytes((String)"fam2");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", BuggyMasterObserver.class.getName());
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testExceptionFromCoprocessorWhenCreatingTable() throws IOException {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getCoprocessorHost();
        BuggyMasterObserver cp = (BuggyMasterObserver)host.findCoprocessor(BuggyMasterObserver.class.getName());
        Assert.assertFalse((String)"No table created yet", (boolean)cp.wasCreateTableCalled());
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(UTIL.getConfiguration(), "unittest", new Abortable(){

            public void abort(String why, Throwable e) {
                throw new RuntimeException("Fatal ZK error: " + why, e);
            }

            public boolean isAborted() {
                return false;
            }
        });
        MasterTracker masterTracker = new MasterTracker(zkw, "/hbase/master", new Abortable(){

            public void abort(String why, Throwable e) {
                throw new RuntimeException("Fatal Zookeeper tracker error, why=", e);
            }

            public boolean isAborted() {
                return false;
            }
        });
        masterTracker.start();
        zkw.registerListener((ZooKeeperListener)masterTracker);
        String coprocessorName = BuggyMasterObserver.class.getName();
        Assert.assertTrue((boolean)master.getLoadedCoprocessors().equals("[" + coprocessorName + "]"));
        HTableDescriptor htd1 = new HTableDescriptor(TEST_TABLE1);
        htd1.addFamily(new HColumnDescriptor(TEST_FAMILY1));
        boolean threwDNRE = false;
        try {
            HBaseAdmin admin = UTIL.getHBaseAdmin();
            admin.createTable(htd1);
        }
        catch (IOException e) {
            if (e.getClass().getName().equals("org.apache.hadoop.hbase.DoNotRetryIOException")) {
                threwDNRE = true;
            }
        }
        finally {
            Assert.assertTrue((boolean)threwDNRE);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException while sleeping.");
        }
        Assert.assertFalse((String)"Master survived coprocessor NPE, as expected.", (boolean)masterTracker.masterZKNodeWasDeleted);
        String loadedCoprocessors = master.getLoadedCoprocessors();
        Assert.assertTrue((boolean)loadedCoprocessors.equals("[" + coprocessorName + "]"));
        HTableDescriptor htd2 = new HTableDescriptor(TEST_TABLE2);
        htd2.addFamily(new HColumnDescriptor(TEST_FAMILY2));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        try {
            admin.createTable(htd2);
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to create table after buggy coprocessor removal: " + e));
        }
    }

    public static class BuggyMasterObserver
    extends BaseMasterObserver {
        private boolean preCreateTableCalled;
        private boolean postCreateTableCalled;
        private boolean startCalled;
        private boolean postStartMasterCalled;

        public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> env, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            Integer i;
            Integer n = i = null;
            Integer n2 = i = Integer.valueOf(i + 1);
            i = n;
        }

        public boolean wasCreateTableCalled() {
            return this.preCreateTableCalled && this.postCreateTableCalled;
        }

        public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.postStartMasterCalled = true;
        }

        public boolean wasStartMasterCalled() {
            return this.postStartMasterCalled;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            this.startCalled = true;
        }

        public boolean wasStarted() {
            return this.startCalled;
        }
    }

    public static class MasterTracker
    extends ZooKeeperNodeTracker {
        public boolean masterZKNodeWasDeleted = false;

        public MasterTracker(ZooKeeperWatcher zkw, String masterNode, Abortable abortable) {
            super(zkw, masterNode, abortable);
        }

        public synchronized void nodeDeleted(String path) {
            if (path.equals("/hbase/master")) {
                this.masterZKNodeWasDeleted = true;
            }
        }
    }
}

