/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestColumnCountGetFilter {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColumnCountGetFilter() throws IOException {
        String family = "Family";
        HTableDescriptor htd = new HTableDescriptor("testColumnCountGetFilter");
        htd.addFamily(new HColumnDescriptor(family));
        HRegionInfo info = new HRegionInfo(htd.getName(), null, null, false);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)TEST_UTIL.getDataTestDir(), (Configuration)TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        try {
            String valueString = "ValueString";
            String row = "row-1";
            List<String> columns = this.generateRandomWords(10000, "column");
            Put p = new Put(Bytes.toBytes((String)row));
            p.setWriteToWAL(false);
            for (String column : columns) {
                KeyValue kv = KeyValueTestUtil.create(row, family, column, 0L, valueString);
                p.add(kv);
            }
            region.put(p);
            Get get = new Get(row.getBytes());
            ColumnCountGetFilter filter = new ColumnCountGetFilter(100);
            get.setFilter((Filter)filter);
            Scan scan = new Scan(get);
            RegionScanner scanner = region.getScanner(scan);
            ArrayList results = new ArrayList();
            scanner.next(results);
            Assert.assertEquals((long)100L, (long)results.size());
        }
        finally {
            region.close();
            region.getLog().closeAndDelete();
        }
        region.close();
        region.getLog().closeAndDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColumnCountGetFilterWithFilterList() throws IOException {
        String family = "Family";
        HTableDescriptor htd = new HTableDescriptor("testColumnCountGetFilter");
        htd.addFamily(new HColumnDescriptor(family));
        HRegionInfo info = new HRegionInfo(htd.getName(), null, null, false);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)TEST_UTIL.getDataTestDir(), (Configuration)TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        try {
            String valueString = "ValueString";
            String row = "row-1";
            List<String> columns = this.generateRandomWords(10000, "column");
            Put p = new Put(Bytes.toBytes((String)row));
            p.setWriteToWAL(false);
            for (String column : columns) {
                KeyValue kv = KeyValueTestUtil.create(row, family, column, 0L, valueString);
                p.add(kv);
            }
            region.put(p);
            Get get = new Get(row.getBytes());
            FilterList filterLst = new FilterList();
            filterLst.addFilter((Filter)new ColumnCountGetFilter(100));
            get.setFilter((Filter)filterLst);
            Scan scan = new Scan(get);
            RegionScanner scanner = region.getScanner(scan);
            ArrayList results = new ArrayList();
            scanner.next(results);
            Assert.assertEquals((long)100L, (long)results.size());
        }
        finally {
            region.close();
            region.getLog().closeAndDelete();
        }
        region.close();
        region.getLog().closeAndDelete();
    }

    List<String> generateRandomWords(int numberOfWords, String suffix) {
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i < numberOfWords; ++i) {
            int lengthOfWords = (int)(Math.random() * 2.0) + 1;
            char[] wordChar = new char[lengthOfWords];
            for (int j = 0; j < wordChar.length; ++j) {
                wordChar[j] = (char)(Math.random() * 26.0 + 97.0);
            }
            String word = suffix == null ? new String(wordChar) : new String(wordChar) + suffix;
            wordSet.add(word);
        }
        ArrayList<String> wordList = new ArrayList<String>(wordSet);
        return wordList;
    }
}

