/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestInclusiveStopFilter
extends TestCase {
    private final byte[] STOP_ROW = Bytes.toBytes((String)"stop_row");
    private final byte[] GOOD_ROW = Bytes.toBytes((String)"good_row");
    private final byte[] PAST_STOP_ROW = Bytes.toBytes((String)"zzzzzz");
    Filter mainFilter;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    protected void setUp() throws Exception {
        super.setUp();
        this.mainFilter = new InclusiveStopFilter(this.STOP_ROW);
    }

    public void testStopRowIdentification() throws Exception {
        this.stopRowTests(this.mainFilter);
    }

    public void testSerialization() throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        this.mainFilter.write((DataOutput)out);
        out.close();
        byte[] buffer = stream.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        InclusiveStopFilter newFilter = new InclusiveStopFilter();
        newFilter.readFields((DataInput)in);
        this.stopRowTests((Filter)newFilter);
    }

    private void stopRowTests(Filter filter) throws Exception {
        TestInclusiveStopFilter.assertFalse((String)("Filtering on " + Bytes.toString((byte[])this.GOOD_ROW)), (boolean)filter.filterRowKey(this.GOOD_ROW, 0, this.GOOD_ROW.length));
        TestInclusiveStopFilter.assertFalse((String)("Filtering on " + Bytes.toString((byte[])this.STOP_ROW)), (boolean)filter.filterRowKey(this.STOP_ROW, 0, this.STOP_ROW.length));
        TestInclusiveStopFilter.assertTrue((String)("Filtering on " + Bytes.toString((byte[])this.PAST_STOP_ROW)), (boolean)filter.filterRowKey(this.PAST_STOP_ROW, 0, this.PAST_STOP_ROW.length));
        TestInclusiveStopFilter.assertTrue((String)"FilterAllRemaining", (boolean)filter.filterAllRemaining());
        TestInclusiveStopFilter.assertFalse((String)"FilterNotNull", (boolean)filter.filterRow());
        TestInclusiveStopFilter.assertFalse((String)"Filter a null", (boolean)filter.filterRowKey(null, 0, 0));
    }
}

