/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSingleColumnValueExcludeFilter
extends TestCase {
    private static final byte[] ROW = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_QUALIFIER = Bytes.toBytes((String)"foo");
    private static final byte[] COLUMN_QUALIFIER_2 = Bytes.toBytes((String)"foo_2");
    private static final byte[] VAL_1 = Bytes.toBytes((String)"a");
    private static final byte[] VAL_2 = Bytes.toBytes((String)"ab");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void testFilterKeyValue() throws Exception {
        SingleColumnValueExcludeFilter filter = new SingleColumnValueExcludeFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.EQUAL, VAL_1);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        kvs.add(new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1));
        kvs.add(new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1));
        kvs.add(new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1));
        filter.filterRow(kvs);
        TestSingleColumnValueExcludeFilter.assertEquals((String)"resultSize", (int)kvs.size(), (int)2);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"leftKV1", (KeyValue.COMPARATOR.compare((KeyValue)kvs.get(0), kv) == 0 ? 1 : 0) != 0);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"leftKV2", (KeyValue.COMPARATOR.compare((KeyValue)kvs.get(1), kv) == 0 ? 1 : 0) != 0);
        TestSingleColumnValueExcludeFilter.assertFalse((String)"allRemainingWhenMatch", (boolean)filter.filterAllRemaining());
        filter.reset();
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"otherColumn", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"testedMismatch", (filter.filterKeyValue(kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"otherColumn", (filter.filterKeyValue(kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
    }
}

