/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHbaseObjectWritable
extends TestCase {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReadOldObjectDataInput() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        byte[] baForText = new byte[]{13, 13, 3, 79, 108, 100};
        Text txt = (Text)this.readByteArray(conf, baForText);
        Text oldTxt = new Text("Old");
        TestHbaseObjectWritable.assertEquals((Object)txt, (Object)oldTxt);
        int A2 = 65;
        byte[] bytes = new byte[]{65};
        byte[] baForByteArray = new byte[]{11, 1, 65};
        byte[] baOut = (byte[])this.readByteArray(conf, baForByteArray);
        TestHbaseObjectWritable.assertTrue((boolean)Bytes.equals((byte[])baOut, (byte[])bytes));
    }

    private Object readByteArray(Configuration conf, byte[] ba) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        DataInputStream dis = new DataInputStream(bais);
        Object product = HbaseObjectWritable.readObject((DataInput)dis, (Configuration)conf);
        dis.close();
        return product;
    }

    public void testReadObjectDataInputConfiguration() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        int COUNT = 101;
        TestHbaseObjectWritable.assertTrue((boolean)this.doType(conf, 101, Integer.TYPE).equals(101));
        byte[] testing = "testing".getBytes();
        byte[] result = (byte[])this.doType(conf, testing, testing.getClass());
        TestHbaseObjectWritable.assertTrue((WritableComparator.compareBytes((byte[])testing, (int)0, (int)testing.length, (byte[])result, (int)0, (int)result.length) == 0 ? 1 : 0) != 0);
        boolean exception = false;
        try {
            this.doType(conf, new Object(), Object.class);
        }
        catch (UnsupportedOperationException uoe) {
            exception = true;
        }
        TestHbaseObjectWritable.assertTrue((boolean)exception);
        int A2 = 65;
        byte[] bytes = new byte[]{65};
        Object obj = this.doType(conf, bytes, byte[].class);
        TestHbaseObjectWritable.assertTrue((((byte[])obj)[0] == 65 ? 1 : 0) != 0);
        obj = this.doType(conf, new Text(""), Text.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof Text));
        ArrayList<String> list = new ArrayList<String>();
        list.add("hello");
        list.add("world");
        list.add("universe");
        obj = this.doType(conf, list, List.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof List));
        Assert.assertArrayEquals((Object[])list.toArray(), (Object[])((List)obj).toArray());
        ArrayList<String> listWithNulls = new ArrayList<String>();
        listWithNulls.add("hello");
        listWithNulls.add("world");
        listWithNulls.add(null);
        obj = this.doType(conf, listWithNulls, List.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof List));
        Assert.assertArrayEquals((Object[])listWithNulls.toArray(), (Object[])((List)obj).toArray());
        ArrayList<String> arr = new ArrayList<String>();
        arr.add("hello");
        arr.add("world");
        arr.add("universe");
        obj = this.doType(conf, arr, ArrayList.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof ArrayList));
        Assert.assertArrayEquals((Object[])list.toArray(), (Object[])((ArrayList)obj).toArray());
        obj = this.doType(conf, new PrefixFilter(HConstants.EMPTY_BYTE_ARRAY), PrefixFilter.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof PrefixFilter));
    }

    public void testCustomWritable() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        CustomWritable custom = new CustomWritable("test phrase");
        Object obj = this.doType(conf, custom, CustomWritable.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof Writable));
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof CustomWritable));
        TestHbaseObjectWritable.assertEquals((String)"test phrase", (String)((CustomWritable)obj).getValue());
        CustomFilter filt = new CustomFilter("mykey");
        FilterList filtlist = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        filtlist.addFilter((Filter)filt);
        obj = this.doType(conf, filtlist, FilterList.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof FilterList));
        TestHbaseObjectWritable.assertNotNull((Object)((FilterList)obj).getFilters());
        TestHbaseObjectWritable.assertEquals((int)1, (int)((FilterList)obj).getFilters().size());
        Filter child = (Filter)((FilterList)obj).getFilters().get(0);
        TestHbaseObjectWritable.assertTrue((boolean)(child instanceof CustomFilter));
        TestHbaseObjectWritable.assertEquals((String)"mykey", (String)((CustomFilter)child).getKey());
    }

    public void testCustomSerializable() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        CustomSerializable custom = new CustomSerializable("test phrase");
        Object obj = this.doType(conf, custom, CustomSerializable.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof Serializable));
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof CustomSerializable));
        TestHbaseObjectWritable.assertEquals((String)"test phrase", (String)((CustomSerializable)obj).getValue());
    }

    private Object doType(Configuration conf, Object value, Class<?> clazz) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        HbaseObjectWritable.writeObject((DataOutput)out, (Object)value, clazz, (Configuration)conf);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(byteStream.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        Object product = HbaseObjectWritable.readObject((DataInput)dis, (Configuration)conf);
        dis.close();
        return product;
    }

    public void testPolymorphismInSequences() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        ArrayList list = Lists.newArrayList((Object[])new A[]{new A(42), new B(10, 100)});
        Object ret = this.doType(conf, list, list.getClass());
        TestHbaseObjectWritable.assertEquals((Object)ret, (Object)list);
        Object[] warr = new Writable[]{new A(42), new B(10, 100)};
        ret = this.doType(conf, warr, warr.getClass());
        Assert.assertArrayEquals((Object[])((Writable[])ret), (Object[])warr);
        A[] arr = new A[]{new A(42), new B(10, 100)};
        ret = this.doType(conf, arr, arr.getClass());
        Assert.assertArrayEquals((Object[])((A[])ret), (Object[])arr);
        A[][] darr = new A[][]{{new A(42), new B(10, 100)}, {new A(12)}};
        ret = this.doType(conf, darr, darr.getClass());
        Assert.assertArrayEquals((Object[])((A[][])ret), (Object[])darr);
        ArrayList larr = Lists.newArrayList((Object[])new A[][]{arr, {new A(99)}});
        ret = this.doType(conf, larr, larr.getClass());
        List lret = (List)ret;
        TestHbaseObjectWritable.assertEquals((int)larr.size(), (int)lret.size());
        for (int i = 0; i < lret.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])larr.get(i)), (Object[])((Object[])lret.get(i)));
        }
        Object[] alarr = new List[]{Lists.newArrayList((Object[])new A[]{new A(1), new A(2)}), Lists.newArrayList((Object[])new B[]{new B(4, 5)})};
        ret = this.doType(conf, alarr, alarr.getClass());
        Object[] alret = (List[])ret;
        Assert.assertArrayEquals((Object[])alarr, (Object[])alret);
        Object[] tarr = new Text[]{new Text("foo"), new Text("bar")};
        ret = this.doType(conf, tarr, tarr.getClass());
        Assert.assertArrayEquals((Object[])tarr, (Object[])((Text[])ret));
        byte[][] barr = new byte[][]{"foo".getBytes(), "baz".getBytes()};
        ret = this.doType(conf, barr, barr.getClass());
        Assert.assertArrayEquals((Object[])barr, (Object[])((byte[][])ret));
    }

    public void testGetClassCode() throws IOException {
        TestHbaseObjectWritable.assertEquals((int)1, (int)HbaseObjectWritable.getClassCode(Boolean.TYPE));
        TestHbaseObjectWritable.assertEquals((int)2, (int)HbaseObjectWritable.getClassCode(Byte.TYPE));
        TestHbaseObjectWritable.assertEquals((int)3, (int)HbaseObjectWritable.getClassCode(Character.TYPE));
        TestHbaseObjectWritable.assertEquals((int)4, (int)HbaseObjectWritable.getClassCode(Short.TYPE));
        TestHbaseObjectWritable.assertEquals((int)5, (int)HbaseObjectWritable.getClassCode(Integer.TYPE));
        TestHbaseObjectWritable.assertEquals((int)6, (int)HbaseObjectWritable.getClassCode(Long.TYPE));
        TestHbaseObjectWritable.assertEquals((int)7, (int)HbaseObjectWritable.getClassCode(Float.TYPE));
        TestHbaseObjectWritable.assertEquals((int)8, (int)HbaseObjectWritable.getClassCode(Double.TYPE));
        TestHbaseObjectWritable.assertEquals((int)9, (int)HbaseObjectWritable.getClassCode(Void.TYPE));
        TestHbaseObjectWritable.assertEquals((int)10, (int)HbaseObjectWritable.getClassCode(String.class));
        TestHbaseObjectWritable.assertEquals((int)11, (int)HbaseObjectWritable.getClassCode(byte[].class));
        TestHbaseObjectWritable.assertEquals((int)12, (int)HbaseObjectWritable.getClassCode(byte[][].class));
        TestHbaseObjectWritable.assertEquals((int)13, (int)HbaseObjectWritable.getClassCode(Text.class));
        TestHbaseObjectWritable.assertEquals((int)14, (int)HbaseObjectWritable.getClassCode(Writable.class));
        TestHbaseObjectWritable.assertEquals((int)15, (int)HbaseObjectWritable.getClassCode(Writable[].class));
        TestHbaseObjectWritable.assertEquals((int)16, (int)HbaseObjectWritable.getClassCode(HbaseMapWritable.class));
        TestHbaseObjectWritable.assertEquals((int)18, (int)HbaseObjectWritable.getClassCode(HColumnDescriptor.class));
        TestHbaseObjectWritable.assertEquals((int)19, (int)HbaseObjectWritable.getClassCode(HConstants.Modify.class));
        TestHbaseObjectWritable.assertEquals((int)22, (int)HbaseObjectWritable.getClassCode(HRegion.class));
        TestHbaseObjectWritable.assertEquals((int)23, (int)HbaseObjectWritable.getClassCode(HRegion[].class));
        TestHbaseObjectWritable.assertEquals((int)24, (int)HbaseObjectWritable.getClassCode(HRegionInfo.class));
        TestHbaseObjectWritable.assertEquals((int)25, (int)HbaseObjectWritable.getClassCode(HRegionInfo[].class));
        TestHbaseObjectWritable.assertEquals((int)26, (int)HbaseObjectWritable.getClassCode(HServerAddress.class));
        TestHbaseObjectWritable.assertEquals((int)27, (int)HbaseObjectWritable.getClassCode(HServerInfo.class));
        TestHbaseObjectWritable.assertEquals((int)28, (int)HbaseObjectWritable.getClassCode(HTableDescriptor.class));
        TestHbaseObjectWritable.assertEquals((int)29, (int)HbaseObjectWritable.getClassCode(MapWritable.class));
        TestHbaseObjectWritable.assertEquals((int)30, (int)HbaseObjectWritable.getClassCode(ClusterStatus.class));
        TestHbaseObjectWritable.assertEquals((int)31, (int)HbaseObjectWritable.getClassCode(Delete.class));
        TestHbaseObjectWritable.assertEquals((int)32, (int)HbaseObjectWritable.getClassCode(Get.class));
        TestHbaseObjectWritable.assertEquals((int)33, (int)HbaseObjectWritable.getClassCode(KeyValue.class));
        TestHbaseObjectWritable.assertEquals((int)34, (int)HbaseObjectWritable.getClassCode(KeyValue[].class));
        TestHbaseObjectWritable.assertEquals((int)35, (int)HbaseObjectWritable.getClassCode(Put.class));
        TestHbaseObjectWritable.assertEquals((int)36, (int)HbaseObjectWritable.getClassCode(Put[].class));
        TestHbaseObjectWritable.assertEquals((int)37, (int)HbaseObjectWritable.getClassCode(Result.class));
        TestHbaseObjectWritable.assertEquals((int)38, (int)HbaseObjectWritable.getClassCode(Result[].class));
        TestHbaseObjectWritable.assertEquals((int)39, (int)HbaseObjectWritable.getClassCode(Scan.class));
        TestHbaseObjectWritable.assertEquals((int)40, (int)HbaseObjectWritable.getClassCode(WhileMatchFilter.class));
        TestHbaseObjectWritable.assertEquals((int)41, (int)HbaseObjectWritable.getClassCode(PrefixFilter.class));
        TestHbaseObjectWritable.assertEquals((int)42, (int)HbaseObjectWritable.getClassCode(PageFilter.class));
        TestHbaseObjectWritable.assertEquals((int)43, (int)HbaseObjectWritable.getClassCode(InclusiveStopFilter.class));
        TestHbaseObjectWritable.assertEquals((int)44, (int)HbaseObjectWritable.getClassCode(ColumnCountGetFilter.class));
        TestHbaseObjectWritable.assertEquals((int)45, (int)HbaseObjectWritable.getClassCode(SingleColumnValueFilter.class));
        TestHbaseObjectWritable.assertEquals((int)46, (int)HbaseObjectWritable.getClassCode(SingleColumnValueExcludeFilter.class));
        TestHbaseObjectWritable.assertEquals((int)47, (int)HbaseObjectWritable.getClassCode(BinaryComparator.class));
        TestHbaseObjectWritable.assertEquals((int)48, (int)HbaseObjectWritable.getClassCode(BitComparator.class));
        TestHbaseObjectWritable.assertEquals((int)49, (int)HbaseObjectWritable.getClassCode(CompareFilter.class));
        TestHbaseObjectWritable.assertEquals((int)50, (int)HbaseObjectWritable.getClassCode(RowFilter.class));
        TestHbaseObjectWritable.assertEquals((int)51, (int)HbaseObjectWritable.getClassCode(ValueFilter.class));
        TestHbaseObjectWritable.assertEquals((int)52, (int)HbaseObjectWritable.getClassCode(QualifierFilter.class));
        TestHbaseObjectWritable.assertEquals((int)53, (int)HbaseObjectWritable.getClassCode(SkipFilter.class));
        TestHbaseObjectWritable.assertEquals((int)54, (int)HbaseObjectWritable.getClassCode(WritableByteArrayComparable.class));
        TestHbaseObjectWritable.assertEquals((int)55, (int)HbaseObjectWritable.getClassCode(FirstKeyOnlyFilter.class));
        TestHbaseObjectWritable.assertEquals((int)56, (int)HbaseObjectWritable.getClassCode(DependentColumnFilter.class));
        TestHbaseObjectWritable.assertEquals((int)57, (int)HbaseObjectWritable.getClassCode(Delete[].class));
        TestHbaseObjectWritable.assertEquals((int)58, (int)HbaseObjectWritable.getClassCode(HLog.Entry.class));
        TestHbaseObjectWritable.assertEquals((int)59, (int)HbaseObjectWritable.getClassCode(HLog.Entry[].class));
        TestHbaseObjectWritable.assertEquals((int)60, (int)HbaseObjectWritable.getClassCode(HLogKey.class));
        TestHbaseObjectWritable.assertEquals((int)61, (int)HbaseObjectWritable.getClassCode(List.class));
        TestHbaseObjectWritable.assertEquals((int)62, (int)HbaseObjectWritable.getClassCode(NavigableSet.class));
        TestHbaseObjectWritable.assertEquals((int)63, (int)HbaseObjectWritable.getClassCode(ColumnPrefixFilter.class));
        TestHbaseObjectWritable.assertEquals((int)64, (int)HbaseObjectWritable.getClassCode(Row.class));
        TestHbaseObjectWritable.assertEquals((int)65, (int)HbaseObjectWritable.getClassCode(Action.class));
        TestHbaseObjectWritable.assertEquals((int)66, (int)HbaseObjectWritable.getClassCode(MultiAction.class));
        TestHbaseObjectWritable.assertEquals((int)67, (int)HbaseObjectWritable.getClassCode(MultiResponse.class));
        TestHbaseObjectWritable.assertEquals((int)68, (int)HbaseObjectWritable.getClassCode(Exec.class));
        TestHbaseObjectWritable.assertEquals((int)69, (int)HbaseObjectWritable.getClassCode(Increment.class));
        TestHbaseObjectWritable.assertEquals((int)70, (int)HbaseObjectWritable.getClassCode(KeyOnlyFilter.class));
        TestHbaseObjectWritable.assertEquals((int)71, (int)HbaseObjectWritable.getClassCode(Serializable.class));
        TestHbaseObjectWritable.assertEquals((int)72, (int)HbaseObjectWritable.getClassCode(RandomRowFilter.class));
        TestHbaseObjectWritable.assertEquals((int)73, (int)HbaseObjectWritable.getClassCode(CompareFilter.CompareOp.class));
        TestHbaseObjectWritable.assertEquals((int)74, (int)HbaseObjectWritable.getClassCode(ColumnRangeFilter.class));
        TestHbaseObjectWritable.assertEquals((int)75, (int)HbaseObjectWritable.getClassCode(HServerLoad.class));
        TestHbaseObjectWritable.assertEquals((int)76, (int)HbaseObjectWritable.getClassCode(RegionOpeningState.class));
        TestHbaseObjectWritable.assertEquals((int)77, (int)HbaseObjectWritable.getClassCode(HTableDescriptor[].class));
        TestHbaseObjectWritable.assertEquals((int)78, (int)HbaseObjectWritable.getClassCode(Append.class));
        TestHbaseObjectWritable.assertEquals((int)79, (int)HbaseObjectWritable.getClassCode(RowMutations.class));
        TestHbaseObjectWritable.assertEquals((int)80, (int)HbaseObjectWritable.getClassCode(Message.class));
        TestHbaseObjectWritable.assertEquals((int)81, (int)HbaseObjectWritable.getClassCode(Array.class));
    }

    public void testGetNextObjectCode() {
        TestHbaseObjectWritable.assertEquals((int)83, (int)HbaseObjectWritable.getNextClassCode());
    }

    public static class CustomFilter
    extends FilterBase {
        private String key = null;

        public CustomFilter() {
        }

        public CustomFilter(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.key);
        }

        public void readFields(DataInput in) throws IOException {
            this.key = Text.readString((DataInput)in);
        }
    }

    public static class CustomWritable
    implements Writable {
        private String value = null;

        public CustomWritable() {
        }

        public CustomWritable(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.value);
        }

        public void readFields(DataInput in) throws IOException {
            this.value = Text.readString((DataInput)in);
        }
    }

    public static class CustomSerializable
    implements Serializable {
        private static final long serialVersionUID = 1048445561865740632L;
        private String value = null;

        public CustomSerializable() {
        }

        public CustomSerializable(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class B
    extends A {
        int b;

        public B() {
        }

        public B(int a, int b) {
            super(a);
            this.b = b;
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
            out.writeInt(this.b);
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.b = in.readInt();
        }

        public boolean equals(Object o) {
            if (o instanceof B) {
                return this.get() == ((B)((Object)o)).get() && this.b == ((B)((Object)o)).b;
            }
            return false;
        }
    }

    public static class A
    extends IntWritable {
        public A() {
        }

        public A(int a) {
            super(a);
        }
    }
}

