/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.RedundantKVGenerator;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaConfigured;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestHFileDataBlockEncoder {
    private Configuration conf;
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private HFileDataBlockEncoderImpl blockEncoder;
    private RedundantKVGenerator generator = new RedundantKVGenerator();
    private SchemaConfigured UNKNOWN_TABLE_AND_CF = SchemaConfigured.createUnknown();
    private boolean includesMemstoreTS;

    public TestHFileDataBlockEncoder(HFileDataBlockEncoderImpl blockEncoder, boolean includesMemstoreTS) {
        this.blockEncoder = blockEncoder;
        this.includesMemstoreTS = includesMemstoreTS;
        System.err.println("On-disk encoding: " + blockEncoder.getEncodingOnDisk() + ", in-cache encoding: " + blockEncoder.getEncodingInCache() + ", includesMemstoreTS: " + includesMemstoreTS);
    }

    @Before
    public void setUp() {
        this.conf = this.TEST_UTIL.getConfiguration();
        SchemaMetrics.configureGlobally((Configuration)this.conf);
    }

    @After
    public void tearDown() throws IOException {
        this.TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testEncodingWithCache() {
        HFileBlock block = this.getSampleHFileBlock();
        LruBlockCache blockCache = new LruBlockCache(0x800000L, 32768L, this.TEST_UTIL.getConfiguration());
        HFileBlock cacheBlock = this.blockEncoder.diskToCacheFormat(block, false);
        BlockCacheKey cacheKey = new BlockCacheKey("test", 0L);
        blockCache.cacheBlock(cacheKey, (Cacheable)cacheBlock);
        Cacheable heapSize = blockCache.getBlock(cacheKey, false, false);
        Assert.assertTrue((boolean)(heapSize instanceof HFileBlock));
        HFileBlock returnedBlock = (HFileBlock)heapSize;
        if (this.blockEncoder.getEncodingInCache() == DataBlockEncoding.NONE) {
            Assert.assertEquals((Object)block.getBufferWithHeader(), (Object)returnedBlock.getBufferWithHeader());
        } else {
            if (BlockType.ENCODED_DATA != returnedBlock.getBlockType()) {
                System.out.println(this.blockEncoder);
            }
            Assert.assertEquals((Object)BlockType.ENCODED_DATA, (Object)returnedBlock.getBlockType());
        }
    }

    @Test
    public void testEncodingWritePath() {
        HFileBlock block = this.getSampleHFileBlock();
        Pair result = this.blockEncoder.beforeWriteToDisk(block.getBufferWithoutHeader(), this.includesMemstoreTS, HFileBlock.DUMMY_HEADER_WITH_CHECKSUM);
        int size = ((ByteBuffer)result.getFirst()).limit() - 33;
        HFileBlock blockOnDisk = new HFileBlock((BlockType)result.getSecond(), size, size, -1L, (ByteBuffer)result.getFirst(), true, 0L, this.includesMemstoreTS, block.getMinorVersion(), block.getBytesPerChecksum(), block.getChecksumType(), block.getOnDiskDataSizeWithHeader());
        if (this.blockEncoder.getEncodingOnDisk() != DataBlockEncoding.NONE) {
            Assert.assertEquals((Object)BlockType.ENCODED_DATA, (Object)blockOnDisk.getBlockType());
            Assert.assertEquals((long)this.blockEncoder.getEncodingOnDisk().getId(), (long)blockOnDisk.getDataBlockEncodingId());
        } else {
            Assert.assertEquals((Object)BlockType.DATA, (Object)blockOnDisk.getBlockType());
        }
    }

    @Test
    public void testEncodingReadPath() {
        HFileBlock origBlock = this.getSampleHFileBlock();
        this.blockEncoder.diskToCacheFormat(origBlock, false);
    }

    private HFileBlock getSampleHFileBlock() {
        ByteBuffer keyValues = RedundantKVGenerator.convertKvToByteBuffer(this.generator.generateTestKeyValues(60), this.includesMemstoreTS);
        int size = keyValues.limit();
        ByteBuffer buf = ByteBuffer.allocate(size + 33);
        buf.position(33);
        keyValues.rewind();
        buf.put(keyValues);
        HFileBlock b = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, 0L, this.includesMemstoreTS, 1, 0, ChecksumType.NULL.getCode(), 0);
        this.UNKNOWN_TABLE_AND_CF.passSchemaMetricsTo((SchemaConfigured)b);
        return b;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getAllConfigurations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        for (DataBlockEncoding diskAlgo : DataBlockEncoding.values()) {
            for (DataBlockEncoding cacheAlgo : DataBlockEncoding.values()) {
                if (diskAlgo != cacheAlgo && diskAlgo != DataBlockEncoding.NONE) continue;
                for (boolean includesMemstoreTS : new boolean[]{false, true}) {
                    configurations.add(new Object[]{new HFileDataBlockEncoderImpl(diskAlgo, cacheAlgo), new Boolean(includesMemstoreTS)});
                }
            }
        }
        return configurations;
    }
}

