/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHFileReaderV1 {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private FileSystem fs;
    private Map<String, Long> startingMetrics;
    private static final int N = 1000;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Before
    public void setUp() throws IOException {
        this.startingMetrics = SchemaMetrics.getMetricsSnapshot();
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = FileSystem.get((Configuration)this.conf);
        SchemaMetrics.configureGlobally((Configuration)this.conf);
    }

    @After
    public void tearDown() throws Exception {
        SchemaMetrics.validateMetricChanges(this.startingMetrics);
    }

    @Test
    public void testReadingExistingVersion1HFile() throws IOException {
        URL url = TestHFileReaderV1.class.getResource("8e8ab58dcf39412da19833fcd8f687ac");
        Path existingHFilePath = new Path(url.getPath());
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)existingHFilePath, (CacheConfig)new CacheConfig(this.conf));
        reader.loadFileInfo();
        FixedFileTrailer trailer = reader.getTrailer();
        Assert.assertEquals((long)1000L, (long)reader.getEntries());
        Assert.assertEquals((long)1000L, (long)trailer.getEntryCount());
        Assert.assertEquals((long)1L, (long)trailer.getMajorVersion());
        Assert.assertEquals((Object)Compression.Algorithm.GZ, (Object)trailer.getCompressionCodec());
        for (boolean pread : new boolean[]{false, true}) {
            int totalDataSize = 0;
            int n = 0;
            HFileScanner scanner = reader.getScanner(false, pread);
            Assert.assertTrue((boolean)scanner.seekTo());
            do {
                totalDataSize += scanner.getKey().limit() + scanner.getValue().limit() + 8;
                ++n;
            } while (scanner.next());
            Assert.assertEquals((long)1000L, (long)n);
            Assert.assertEquals((long)trailer.getTotalUncompressedBytes(), (long)(totalDataSize += 8 * trailer.getDataIndexCount()));
        }
        reader.close();
    }
}

