/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestProtocolExtension {
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestProtocolExtension.class);
    private static Configuration conf = new Configuration();
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCalls() throws Exception {
        RpcServer server = HBaseRPC.getServer(TestProtocol.class, (Object)new TestImpl(), (Class[])new Class[]{ProtocolExtention.class}, (String)ADDRESS, (int)6016, (int)10, (int)10, (boolean)false, (Configuration)conf, (int)10);
        RpcEngine rpcEngine = null;
        try {
            server.start();
            rpcEngine = HBaseRPC.getProtocolEngine((Configuration)conf);
            InetSocketAddress addr = server.getListenerAddress();
            TestProtocol proxy = (TestProtocol)rpcEngine.getProxy(TestProtocol.class, 7L, addr, conf, 10000);
            proxy.ping();
            proxy.logClassName();
        }
        finally {
            server.stop();
            if (rpcEngine != null) {
                rpcEngine.close();
            }
        }
    }

    public static class TestImpl
    implements TestProtocol {
        public long getProtocolVersion(String protocol, long clientVersion) {
            return 7L;
        }

        @Override
        public void ping() {
        }

        @Override
        public void logClassName() {
            LOG.info((Object)this.getClass().getName());
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return new ProtocolSignature(7L, null);
        }
    }

    public static interface TestProtocol
    extends VersionedProtocol,
    ProtocolExtention {
        public static final long VERSION = 7L;

        public void ping() throws IOException;
    }

    public static interface ProtocolExtention {
        public void logClassName();
    }
}

