/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.IdentityTableReduce;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTableMapReduce {
    private static final Log LOG = LogFactory.getLog((String)TestTableMapReduce.class.getName());
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    static final byte[] MULTI_REGION_TABLE_NAME = Bytes.toBytes((String)"mrtest");
    static final byte[] INPUT_FAMILY = Bytes.toBytes((String)"contents");
    static final byte[] OUTPUT_FAMILY = Bytes.toBytes((String)"text");
    private static final byte[][] columns = new byte[][]{INPUT_FAMILY, OUTPUT_FAMILY};
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
        HTable table = UTIL.createTable(MULTI_REGION_TABLE_NAME, new byte[][]{INPUT_FAMILY, OUTPUT_FAMILY});
        UTIL.createMultiRegions(table, INPUT_FAMILY);
        UTIL.loadTable(table, INPUT_FAMILY);
        UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniMapReduceCluster();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMultiRegionTable() throws IOException {
        this.runTestOnTable(new HTable(UTIL.getConfiguration(), MULTI_REGION_TABLE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestOnTable(HTable table) throws IOException {
        JobConf jobConf = null;
        try {
            LOG.info((Object)"Before map/reduce startup");
            jobConf = new JobConf(UTIL.getConfiguration(), TestTableMapReduce.class);
            jobConf.setJobName("process column contents");
            jobConf.setNumReduceTasks(1);
            TableMapReduceUtil.initTableMapJob((String)Bytes.toString((byte[])table.getTableName()), (String)Bytes.toString((byte[])INPUT_FAMILY), ProcessContentsMapper.class, ImmutableBytesWritable.class, Put.class, (JobConf)jobConf);
            TableMapReduceUtil.initTableReduceJob((String)Bytes.toString((byte[])table.getTableName()), IdentityTableReduce.class, (JobConf)jobConf);
            LOG.info((Object)("Started " + Bytes.toString((byte[])table.getTableName())));
            RunningJob job = JobClient.runJob((JobConf)jobConf);
            Assert.assertTrue((boolean)job.isSuccessful());
            LOG.info((Object)"After map/reduce completion");
            this.verify(Bytes.toString((byte[])table.getTableName()));
        }
        finally {
            if (jobConf != null) {
                FileUtil.fullyDelete((File)new File(jobConf.get("hadoop.tmp.dir")));
            }
        }
    }

    private void verify(String tableName) throws IOException {
        HTable table = new HTable(UTIL.getConfiguration(), tableName);
        boolean verified = false;
        long pause = UTIL.getConfiguration().getLong("hbase.client.pause", 5000L);
        int numRetries = UTIL.getConfiguration().getInt("hbase.client.retries.number", 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                LOG.info((Object)("Verification attempt #" + i));
                this.verifyAttempt(table);
                verified = true;
                break;
            }
            catch (NullPointerException e) {
                LOG.debug((Object)("Verification attempt failed: " + e.getMessage()));
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        Assert.assertTrue((boolean)verified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAttempt(HTable table) throws IOException, NullPointerException {
        Scan scan = new Scan();
        TableInputFormat.addColumns((Scan)scan, (byte[][])columns);
        ResultScanner scanner = table.getScanner(scan);
        try {
            Iterator itr = scanner.iterator();
            Assert.assertTrue((boolean)itr.hasNext());
            while (itr.hasNext()) {
                Result r = (Result)itr.next();
                if (LOG.isDebugEnabled() && r.size() > 2) {
                    throw new IOException("Too many results, expected 2 got " + r.size());
                }
                byte[] firstValue = null;
                byte[] secondValue = null;
                int count = 0;
                for (KeyValue kv : r.list()) {
                    if (count == 0) {
                        firstValue = kv.getValue();
                    }
                    if (count == 1) {
                        secondValue = kv.getValue();
                    }
                    if (++count != 2) continue;
                    break;
                }
                String first = "";
                if (firstValue == null) {
                    throw new NullPointerException(Bytes.toString((byte[])r.getRow()) + ": first value is null");
                }
                first = new String(firstValue, "UTF-8");
                String second = "";
                if (secondValue == null) {
                    throw new NullPointerException(Bytes.toString((byte[])r.getRow()) + ": second value is null");
                }
                byte[] secondReversed = new byte[secondValue.length];
                int i = 0;
                int j = secondValue.length - 1;
                while (j >= 0) {
                    secondReversed[i] = secondValue[j];
                    --j;
                    ++i;
                }
                second = new String(secondReversed, "UTF-8");
                if (first.compareTo(second) == 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("second key is not the reverse of first. row=" + r.getRow() + ", first value=" + first + ", second value=" + second));
                }
                Assert.fail();
            }
        }
        finally {
            scanner.close();
        }
    }

    public static class ProcessContentsMapper
    extends MapReduceBase
    implements TableMap<ImmutableBytesWritable, Put> {
        public void map(ImmutableBytesWritable key, Result value, OutputCollector<ImmutableBytesWritable, Put> output, Reporter reporter) throws IOException {
            if (value.size() != 1) {
                throw new IOException("There should only be one input column");
            }
            NavigableMap cf = value.getMap();
            if (!cf.containsKey(INPUT_FAMILY)) {
                throw new IOException("Wrong input columns. Missing: '" + Bytes.toString((byte[])INPUT_FAMILY) + "'.");
            }
            String originalValue = new String(value.getValue(INPUT_FAMILY, null), "UTF-8");
            StringBuilder newValue = new StringBuilder(originalValue);
            newValue.reverse();
            Put outval = new Put(key.get());
            outval.add(OUTPUT_FAMILY, null, Bytes.toBytes((String)newValue.toString()));
            output.collect((Object)key, (Object)outval);
        }
    }
}

