/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.PerformanceEvaluation;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.NMapInputFormat;
import org.apache.hadoop.hbase.mapreduce.SimpleTotalOrderPartitioner;
import org.apache.hadoop.hbase.mapreduce.hadoopbackport.InputSampler;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestHFileOutputFormat {
    private static final int ROWSPERSPLIT = 1024;
    private static final byte[][] FAMILIES = new byte[][]{Bytes.add((byte[])PerformanceEvaluation.FAMILY_NAME, (byte[])Bytes.toBytes((String)"-A")), Bytes.add((byte[])PerformanceEvaluation.FAMILY_NAME, (byte[])Bytes.toBytes((String)"-B"))};
    private static final byte[] TABLE_NAME = Bytes.toBytes((String)"TestTable");
    private HBaseTestingUtility util = new HBaseTestingUtility();
    private static Log LOG = LogFactory.getLog(TestHFileOutputFormat.class);
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Before
    public void cleanupDir() throws IOException {
        this.util.cleanupTestDir();
    }

    private void setupRandomGeneratorMapper(Job job) {
        job.setInputFormatClass(NMapInputFormat.class);
        job.setMapperClass(RandomKVGeneratingMapper.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(KeyValue.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test_LATEST_TIMESTAMP_isReplaced() throws Exception {
        Path dir;
        Configuration conf;
        block3: {
            conf = new Configuration(this.util.getConfiguration());
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = this.util.getDataTestDir("test_LATEST_TIMESTAMP_isReplaced");
            try {
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = this.getTestTaskAttemptContext(job);
                HFileOutputFormat hof = new HFileOutputFormat();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                KeyValue kv = new KeyValue(b, b, b);
                KeyValue original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertFalse((boolean)original.equals((Object)kv));
                Assert.assertTrue((boolean)Bytes.equals((byte[])original.getRow(), (byte[])kv.getRow()));
                Assert.assertTrue((boolean)original.matchingColumn(kv.getFamily(), kv.getQualifier()));
                Assert.assertNotSame((Object)original.getTimestamp(), (Object)kv.getTimestamp());
                Assert.assertNotSame((Object)Long.MAX_VALUE, (Object)kv.getTimestamp());
                kv = new KeyValue(b, b, b, kv.getTimestamp() - 1L, b);
                original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertTrue((boolean)original.equals((Object)kv));
                if (writer == null || context == null) break block3;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    private static boolean isPost020MapReduce() {
        return TaskAttemptContext.class.isInterface();
    }

    private TaskAttemptContext getTestTaskAttemptContext(Job job) throws IOException, Exception {
        TaskAttemptContext context;
        if (TestHFileOutputFormat.isPost020MapReduce()) {
            TaskAttemptID id = TaskAttemptID.forName((String)"attempt_200707121733_0001_m_000000_0");
            Class<?> clazz = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
            Constructor<?> c = clazz.getConstructor(Configuration.class, TaskAttemptID.class);
            context = (TaskAttemptContext)c.newInstance(job.getConfiguration(), id);
        } else {
            context = InputSampler.getTaskAttemptContext((Job)job);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test_TIMERANGE() throws Exception {
        Path dir;
        Configuration conf;
        block3: {
            conf = new Configuration(this.util.getConfiguration());
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = this.util.getDataTestDir("test_TIMERANGE_present");
            LOG.info((Object)("Timerange dir writing to dir: " + dir));
            try {
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = this.getTestTaskAttemptContext(job);
                HFileOutputFormat hof = new HFileOutputFormat();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                KeyValue kv = new KeyValue(b, b, b, 2000L, b);
                KeyValue original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertEquals((Object)original, (Object)kv);
                kv = new KeyValue(b, b, b, 1000L, b);
                original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertEquals((Object)original, (Object)kv);
                writer.close(context);
                FileSystem fs = FileSystem.get((Configuration)conf);
                Path attemptDirectory = hof.getDefaultWorkFile(context, "").getParent();
                FileStatus[] sub1 = fs.listStatus(attemptDirectory);
                FileStatus[] file = fs.listStatus(sub1[0].getPath());
                HFile.Reader rd = HFile.createReader((FileSystem)fs, (Path)file[0].getPath(), (CacheConfig)new CacheConfig(conf));
                Map finfo = rd.loadFileInfo();
                byte[] range = (byte[])finfo.get("TIMERANGE".getBytes());
                Assert.assertNotNull((Object)range);
                TimeRangeTracker timeRangeTracker = new TimeRangeTracker();
                Writables.copyWritable((byte[])range, (Writable)timeRangeTracker);
                LOG.info((Object)(timeRangeTracker.getMinimumTimestamp() + "...." + timeRangeTracker.getMaximumTimestamp()));
                Assert.assertEquals((long)1000L, (long)timeRangeTracker.getMinimumTimestamp());
                Assert.assertEquals((long)2000L, (long)timeRangeTracker.getMaximumTimestamp());
                rd.close();
                if (writer == null || context == null) break block3;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    @Test
    public void testWritingPEData() throws Exception {
        Configuration conf = this.util.getConfiguration();
        Path testDir = this.util.getDataTestDir("testWritingPEData");
        FileSystem fs = testDir.getFileSystem(conf);
        conf.setInt("io.sort.mb", 20);
        conf.setLong("hbase.hregion.max.filesize", 65536L);
        Job job = new Job(conf, "testWritingPEData");
        this.setupRandomGeneratorMapper(job);
        byte[] startKey = new byte[10];
        byte[] endKey = new byte[10];
        Arrays.fill(startKey, (byte)0);
        Arrays.fill(endKey, (byte)-1);
        job.setPartitionerClass(SimpleTotalOrderPartitioner.class);
        SimpleTotalOrderPartitioner.setStartKey((Configuration)job.getConfiguration(), (byte[])startKey);
        SimpleTotalOrderPartitioner.setEndKey((Configuration)job.getConfiguration(), (byte[])endKey);
        job.setReducerClass(KeyValueSortReducer.class);
        job.setOutputFormatClass(HFileOutputFormat.class);
        job.setNumReduceTasks(4);
        FileOutputFormat.setOutputPath((Job)job, (Path)testDir);
        Assert.assertTrue((boolean)job.waitForCompletion(false));
        FileStatus[] files = fs.listStatus(testDir);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJobConfiguration() throws Exception {
        Job job = new Job();
        HTable table = (HTable)Mockito.mock(HTable.class);
        this.setupMockStartKeys(table);
        HFileOutputFormat.configureIncrementalLoad((Job)job, (HTable)table);
        Assert.assertEquals((long)job.getNumReduceTasks(), (long)4L);
    }

    private byte[][] generateRandomStartKeys(int numKeys) {
        Random random = new Random();
        byte[][] ret = new byte[numKeys][];
        ret[0] = HConstants.EMPTY_BYTE_ARRAY;
        for (int i = 1; i < numKeys; ++i) {
            ret[i] = PerformanceEvaluation.generateValue(random);
        }
        return ret;
    }

    @Test
    public void testMRIncrementalLoad() throws Exception {
        this.doIncrementalLoadTest(false);
    }

    @Test
    public void testMRIncrementalLoadWithSplit() throws Exception {
        this.doIncrementalLoadTest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIncrementalLoadTest(boolean shouldChangeRegions) throws Exception {
        Configuration conf = this.util.getConfiguration();
        Path testDir = this.util.getDataTestDir("testLocalMRIncrementalLoad");
        byte[][] startKeys = this.generateRandomStartKeys(5);
        try {
            this.util.startMiniCluster();
            HBaseAdmin admin = new HBaseAdmin(conf);
            HTable table = this.util.createTable(TABLE_NAME, FAMILIES);
            Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows(table));
            int numRegions = this.util.createMultiRegions(this.util.getConfiguration(), table, FAMILIES[0], startKeys);
            Assert.assertEquals((String)"Should make 5 regions", (long)numRegions, (long)5L);
            this.util.startMiniMapReduceCluster();
            this.runIncrementalPELoad(conf, table, testDir);
            Assert.assertEquals((String)"HFOF should not touch actual table", (long)0L, (long)this.util.countRows(table));
            int dir = 0;
            for (FileStatus f : testDir.getFileSystem(conf).listStatus(testDir)) {
                for (byte[] family : FAMILIES) {
                    if (!Bytes.toString((byte[])family).equals(f.getPath().getName())) continue;
                    ++dir;
                }
            }
            Assert.assertEquals((String)"Column family not found in FS.", (long)FAMILIES.length, (long)dir);
            if (shouldChangeRegions) {
                LOG.info((Object)"Changing regions in table");
                admin.disableTable(table.getTableName());
                while (this.util.getMiniHBaseCluster().getMaster().getAssignmentManager().isRegionsInTransition()) {
                    Threads.sleep((long)200L);
                    LOG.info((Object)"Waiting on table to finish disabling");
                }
                byte[][] newStartKeys = this.generateRandomStartKeys(15);
                this.util.createMultiRegions(this.util.getConfiguration(), table, FAMILIES[0], newStartKeys);
                admin.enableTable(table.getTableName());
                while (table.getRegionsInfo().size() != 15 || !admin.isTableAvailable(table.getTableName())) {
                    Thread.sleep(200L);
                    LOG.info((Object)"Waiting for new region assignment to happen");
                }
            }
            new LoadIncrementalHFiles(conf).doBulkLoad(testDir, table);
            int expectedRows = NMapInputFormat.getNumMapTasks(conf) * 1024;
            Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)expectedRows, (long)this.util.countRows(table));
            Scan scan = new Scan();
            ResultScanner results = table.getScanner(scan);
            int count = 0;
            for (Result res : results) {
                ++count;
                Assert.assertEquals((long)FAMILIES.length, (long)res.raw().length);
                KeyValue first = res.raw()[0];
                for (KeyValue kv : res.raw()) {
                    Assert.assertTrue((boolean)KeyValue.COMPARATOR.matchingRows(first, kv));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])first.getValue(), (byte[])kv.getValue()));
                }
            }
            results.close();
            String tableDigestBefore = this.util.checksumRows(table);
            admin.disableTable(TABLE_NAME);
            while (!admin.isTableDisabled(TABLE_NAME)) {
                Thread.sleep(200L);
                LOG.info((Object)"Waiting for table to disable");
            }
            admin.enableTable(TABLE_NAME);
            this.util.waitTableAvailable(TABLE_NAME, 30000L);
            Assert.assertEquals((String)"Data should remain after reopening of regions", (Object)tableDigestBefore, (Object)this.util.checksumRows(table));
        }
        finally {
            this.util.shutdownMiniMapReduceCluster();
            this.util.shutdownMiniCluster();
        }
    }

    private void runIncrementalPELoad(Configuration conf, HTable table, Path outDir) throws Exception {
        Job job = new Job(conf, "testLocalMRIncrementalLoad");
        this.setupRandomGeneratorMapper(job);
        HFileOutputFormat.configureIncrementalLoad((Job)job, (HTable)table);
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        junit.framework.Assert.assertFalse((boolean)this.util.getTestFileSystem().exists(outDir));
        Assert.assertEquals((long)table.getRegionsInfo().size(), (long)job.getNumReduceTasks());
        Assert.assertTrue((boolean)job.waitForCompletion(true));
    }

    @Test
    public void testCreateFamilyCompressionMap() throws IOException {
        for (int numCfs = 0; numCfs <= 3; ++numCfs) {
            Configuration conf = new Configuration(this.util.getConfiguration());
            Map<String, Compression.Algorithm> familyToCompression = this.getMockColumnFamilies(numCfs);
            HTable table = (HTable)Mockito.mock(HTable.class);
            this.setupMockColumnFamilies(table, familyToCompression);
            HFileOutputFormat.configureCompression((HTable)table, (Configuration)conf);
            Map retrievedFamilyToCompressionMap = HFileOutputFormat.createFamilyCompressionMap((Configuration)conf);
            for (Map.Entry<String, Compression.Algorithm> entry : familyToCompression.entrySet()) {
                Assert.assertEquals((String)("Compression configuration incorrect for column family:" + entry.getKey()), (Object)entry.getValue().getName(), retrievedFamilyToCompressionMap.get(entry.getKey().getBytes()));
            }
        }
    }

    private void setupMockColumnFamilies(HTable table, Map<String, Compression.Algorithm> familyToCompression) throws IOException {
        HTableDescriptor mockTableDescriptor = new HTableDescriptor(TABLE_NAME);
        for (Map.Entry<String, Compression.Algorithm> entry : familyToCompression.entrySet()) {
            mockTableDescriptor.addFamily(new HColumnDescriptor(entry.getKey()).setMaxVersions(1).setCompressionType(entry.getValue()).setBlockCacheEnabled(false).setTimeToLive(0));
        }
        ((HTable)Mockito.doReturn((Object)mockTableDescriptor).when((Object)table)).getTableDescriptor();
    }

    private void setupMockStartKeys(HTable table) throws IOException {
        byte[][] mockKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"zzz")};
        ((HTable)Mockito.doReturn((Object)mockKeys).when((Object)table)).getStartKeys();
    }

    private Map<String, Compression.Algorithm> getMockColumnFamilies(int numCfs) {
        HashMap<String, Compression.Algorithm> familyToCompression = new HashMap<String, Compression.Algorithm>();
        if (numCfs-- > 0) {
            familyToCompression.put("Family1!@#!@#&", Compression.Algorithm.LZO);
        }
        if (numCfs-- > 0) {
            familyToCompression.put("Family2=asdads&!AASD", Compression.Algorithm.SNAPPY);
        }
        if (numCfs-- > 0) {
            familyToCompression.put("Family2=asdads&!AASD", Compression.Algorithm.GZ);
        }
        if (numCfs-- > 0) {
            familyToCompression.put("Family3", Compression.Algorithm.NONE);
        }
        return familyToCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColumnFamilyCompression() throws Exception {
        Configuration conf = new Configuration(this.util.getConfiguration());
        RecordWriter writer = null;
        TaskAttemptContext context = null;
        Path dir = this.util.getDataTestDir("testColumnFamilyCompression");
        HTable table = (HTable)Mockito.mock(HTable.class);
        HashMap<String, Compression.Algorithm> configuredCompression = new HashMap<String, Compression.Algorithm>();
        Compression.Algorithm[] supportedAlgos = this.getSupportedCompressionAlgorithms();
        int familyIndex = 0;
        for (byte[] family : FAMILIES) {
            configuredCompression.put(Bytes.toString((byte[])family), supportedAlgos[familyIndex++ % supportedAlgos.length]);
        }
        this.setupMockColumnFamilies(table, configuredCompression);
        this.setupMockStartKeys(table);
        try {
            conf.set("io.seqfile.compression.type", "NONE");
            Job job = new Job(conf, "testLocalMRIncrementalLoad");
            this.setupRandomGeneratorMapper(job);
            HFileOutputFormat.configureIncrementalLoad((Job)job, (HTable)table);
            FileOutputFormat.setOutputPath((Job)job, (Path)dir);
            context = this.getTestTaskAttemptContext(job);
            HFileOutputFormat hof = new HFileOutputFormat();
            writer = hof.getRecordWriter(context);
            this.writeRandomKeyValues((RecordWriter<ImmutableBytesWritable, KeyValue>)writer, context, 1024);
            writer.close(context);
            FileSystem fileSystem = dir.getFileSystem(conf);
            hof.getOutputCommitter(context).commitTask(context);
            hof.getOutputCommitter(context).commitJob((JobContext)context);
            for (byte[] family : FAMILIES) {
                String familyStr = new String(family);
                boolean found = false;
                for (FileStatus f : fileSystem.listStatus(dir)) {
                    if (!Bytes.toString((byte[])family).equals(f.getPath().getName())) continue;
                    found = true;
                    Path dataFilePath = fileSystem.listStatus(f.getPath())[0].getPath();
                    HFile.Reader reader = HFile.createReader((FileSystem)fileSystem, (Path)dataFilePath, (CacheConfig)new CacheConfig(conf));
                    reader.loadFileInfo();
                    Assert.assertEquals((String)("Incorrect compression used for column family " + familyStr + "(reader: " + reader + ")"), configuredCompression.get(familyStr), (Object)reader.getCompressionAlgorithm());
                    break;
                }
                if (found) continue;
                Assert.fail((String)("HFile for column family " + familyStr + " not found"));
            }
        }
        finally {
            dir.getFileSystem(conf).delete(dir, true);
        }
    }

    private Compression.Algorithm[] getSupportedCompressionAlgorithms() {
        String[] allAlgos = HFile.getSupportedCompressionAlgorithms();
        ArrayList supportedAlgos = Lists.newArrayList();
        for (String algoName : allAlgos) {
            try {
                Compression.Algorithm algo = Compression.getCompressionAlgorithmByName((String)algoName);
                algo.getCompressor();
                supportedAlgos.add(algo);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return supportedAlgos.toArray(new Compression.Algorithm[0]);
    }

    private void writeRandomKeyValues(RecordWriter<ImmutableBytesWritable, KeyValue> writer, TaskAttemptContext context, int numRows) throws IOException, InterruptedException {
        byte[] keyBytes = new byte[4];
        int valLength = 10;
        byte[] valBytes = new byte[valLength];
        int taskId = context.getTaskAttemptID().getTaskID().getId();
        assert (taskId < 127) : "Unit tests dont support > 127 tasks!";
        Random random = new Random();
        for (int i = 0; i < numRows; ++i) {
            Bytes.putInt((byte[])keyBytes, (int)0, (int)i);
            random.nextBytes(valBytes);
            ImmutableBytesWritable key = new ImmutableBytesWritable(keyBytes);
            for (byte[] family : FAMILIES) {
                KeyValue kv = new KeyValue(keyBytes, family, PerformanceEvaluation.QUALIFIER_NAME, valBytes);
                writer.write((Object)key, (Object)kv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcludeAllFromMinorCompaction() throws Exception {
        Configuration conf = this.util.getConfiguration();
        conf.setInt("hbase.hstore.compaction.min", 2);
        this.generateRandomStartKeys(5);
        try {
            this.util.startMiniCluster();
            final FileSystem fs = this.util.getDFSCluster().getFileSystem();
            HBaseAdmin admin = new HBaseAdmin(conf);
            HTable table = this.util.createTable(TABLE_NAME, FAMILIES);
            Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows(table));
            final Path storePath = Store.getStoreHomedir((Path)HTableDescriptor.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (byte[])TABLE_NAME), (String)((HRegionInfo)admin.getTableRegions(TABLE_NAME).get(0)).getEncodedName(), (byte[])FAMILIES[0]);
            Assert.assertEquals((long)0L, (long)fs.listStatus(storePath).length);
            conf.setBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", true);
            this.util.startMiniMapReduceCluster();
            for (int i = 0; i < 2; ++i) {
                Path testDir = this.util.getDataTestDir("testExcludeAllFromMinorCompaction_" + i);
                this.runIncrementalPELoad(conf, table, testDir);
                new LoadIncrementalHFiles(conf).doBulkLoad(testDir, table);
            }
            int expectedRows = 2 * NMapInputFormat.getNumMapTasks(conf) * 1024;
            Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)expectedRows, (long)this.util.countRows(table));
            Assert.assertEquals((long)2L, (long)fs.listStatus(storePath).length);
            admin.compact(TABLE_NAME);
            try {
                this.quickPoll(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return fs.listStatus(storePath).length == 1;
                    }
                }, 5000);
                throw new IOException("SF# = " + fs.listStatus(storePath).length);
            }
            catch (AssertionError ae) {
                admin.majorCompact(TABLE_NAME);
                this.quickPoll(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return fs.listStatus(storePath).length == 1;
                    }
                }, 5000);
                this.util.shutdownMiniMapReduceCluster();
                this.util.shutdownMiniCluster();
            }
        }
        catch (Throwable throwable) {
            this.util.shutdownMiniMapReduceCluster();
            this.util.shutdownMiniCluster();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcludeMinorCompaction() throws Exception {
        Configuration conf = this.util.getConfiguration();
        conf.setInt("hbase.hstore.compaction.min", 2);
        Path testDir = this.util.getDataTestDir("testExcludeMinorCompaction");
        this.generateRandomStartKeys(5);
        try {
            this.util.startMiniCluster();
            final FileSystem fs = this.util.getDFSCluster().getFileSystem();
            HBaseAdmin admin = new HBaseAdmin(conf);
            HTable table = this.util.createTable(TABLE_NAME, FAMILIES);
            Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows(table));
            final Path storePath = Store.getStoreHomedir((Path)HTableDescriptor.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (byte[])TABLE_NAME), (String)((HRegionInfo)admin.getTableRegions(TABLE_NAME).get(0)).getEncodedName(), (byte[])FAMILIES[0]);
            Assert.assertEquals((long)0L, (long)fs.listStatus(storePath).length);
            Put p = new Put(Bytes.toBytes((String)"test"));
            p.add(FAMILIES[0], Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1"));
            table.put(p);
            admin.flush(TABLE_NAME);
            Assert.assertEquals((long)1L, (long)this.util.countRows(table));
            this.quickPoll(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return fs.listStatus(storePath).length == 1;
                }
            }, 5000);
            conf.setBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", true);
            this.util.startMiniMapReduceCluster();
            this.runIncrementalPELoad(conf, table, testDir);
            new LoadIncrementalHFiles(conf).doBulkLoad(testDir, table);
            int expectedRows = NMapInputFormat.getNumMapTasks(conf) * 1024;
            Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)(expectedRows + 1), (long)this.util.countRows(table));
            Assert.assertEquals((long)2L, (long)fs.listStatus(storePath).length);
            admin.compact(TABLE_NAME);
            try {
                this.quickPoll(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return fs.listStatus(storePath).length == 1;
                    }
                }, 5000);
                throw new IOException("SF# = " + fs.listStatus(storePath).length);
            }
            catch (AssertionError ae) {
                admin.majorCompact(TABLE_NAME);
                this.quickPoll(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return fs.listStatus(storePath).length == 1;
                    }
                }, 5000);
                this.util.shutdownMiniMapReduceCluster();
                this.util.shutdownMiniCluster();
            }
        }
        catch (Throwable throwable) {
            this.util.shutdownMiniMapReduceCluster();
            this.util.shutdownMiniCluster();
            throw throwable;
        }
    }

    private void quickPoll(Callable<Boolean> c, int waitMs) throws Exception {
        int sleepMs = 10;
        int retries = (int)Math.ceil((double)waitMs / (double)sleepMs);
        while (retries-- > 0) {
            if (c.call().booleanValue()) {
                return;
            }
            Thread.sleep(sleepMs);
        }
        Assert.fail();
    }

    public static void main(String[] args) throws Exception {
        new TestHFileOutputFormat().manualTest(args);
    }

    public void manualTest(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        this.util = new HBaseTestingUtility(conf);
        if ("newtable".equals(args[0])) {
            byte[] tname = args[1].getBytes();
            HTable table = this.util.createTable(tname, FAMILIES);
            HBaseAdmin admin = new HBaseAdmin(conf);
            admin.disableTable(tname);
            byte[][] startKeys = this.generateRandomStartKeys(5);
            this.util.createMultiRegions(conf, table, FAMILIES[0], startKeys);
            admin.enableTable(tname);
        } else if ("incremental".equals(args[0])) {
            byte[] tname = args[1].getBytes();
            HTable table = new HTable(conf, tname);
            Path outDir = new Path("incremental-out");
            this.runIncrementalPELoad(conf, table, outDir);
        } else {
            throw new RuntimeException("usage: TestHFileOutputFormat newtable | incremental");
        }
    }

    static class RandomKVGeneratingMapper
    extends Mapper<NullWritable, NullWritable, ImmutableBytesWritable, KeyValue> {
        private int keyLength;
        private static final int KEYLEN_DEFAULT = 10;
        private static final String KEYLEN_CONF = "randomkv.key.length";
        private int valLength;
        private static final int VALLEN_DEFAULT = 10;
        private static final String VALLEN_CONF = "randomkv.val.length";

        RandomKVGeneratingMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Configuration conf = context.getConfiguration();
            this.keyLength = conf.getInt(KEYLEN_CONF, 10);
            this.valLength = conf.getInt(VALLEN_CONF, 10);
        }

        protected void map(NullWritable n1, NullWritable n2, Mapper.Context context) throws IOException, InterruptedException {
            byte[] keyBytes = new byte[this.keyLength];
            byte[] valBytes = new byte[this.valLength];
            int taskId = context.getTaskAttemptID().getTaskID().getId();
            assert (taskId < 127) : "Unit tests dont support > 127 tasks!";
            Random random = new Random();
            for (int i = 0; i < 1024; ++i) {
                random.nextBytes(keyBytes);
                keyBytes[this.keyLength - 1] = (byte)(taskId & 0xFF);
                random.nextBytes(valBytes);
                ImmutableBytesWritable key = new ImmutableBytesWritable(keyBytes);
                for (byte[] family : FAMILIES) {
                    KeyValue kv = new KeyValue(keyBytes, family, PerformanceEvaluation.QUALIFIER_NAME, valBytes);
                    context.write((Object)key, (Object)kv);
                }
            }
        }
    }
}

