/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TsvImporterMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class TsvImporterCustomTestMapper
extends TsvImporterMapper {
    protected void setup(Mapper.Context context) {
        this.doSetup(context);
    }

    public void map(LongWritable offset, Text value, Mapper.Context context) throws IOException {
        byte[] family = Bytes.toBytes((String)"FAM");
        byte[][] qualifiers = new byte[][]{Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B")};
        byte[] lineBytes = value.getBytes();
        String[] valueTokens = new String(lineBytes, "UTF-8").split("\u001b");
        ImmutableBytesWritable rowKey = new ImmutableBytesWritable(Bytes.toBytes((String)valueTokens[0]));
        Put put = new Put(rowKey.copyBytes());
        put.setWriteToWAL(false);
        for (int i = 1; i < valueTokens.length; ++i) {
            String prefix = valueTokens[i].substring(0, "VALUE".length());
            String suffix = valueTokens[i].substring("VALUE".length());
            String newValue = prefix + Integer.parseInt(suffix) * 3;
            KeyValue kv = new KeyValue(rowKey.copyBytes(), family, qualifiers[i - 1], Bytes.toBytes((String)newValue));
            put.add(kv);
        }
        try {
            context.write((Object)rowKey, (Object)put);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

