/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveTestingUtil;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestCatalogJanitor {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testGetHRegionInfo() throws IOException {
        Assert.assertNull((Object)CatalogJanitor.getHRegionInfo((Result)new Result()));
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        Result r = new Result(kvs);
        Assert.assertNull((Object)CatalogJanitor.getHRegionInfo((Result)r));
        byte[] f = HConstants.CATALOG_FAMILY;
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.SERVER_QUALIFIER, f));
        r = new Result(kvs);
        Assert.assertNull((Object)CatalogJanitor.getHRegionInfo((Result)r));
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, f));
        HRegionInfo hri = CatalogJanitor.getHRegionInfo((Result)new Result(kvs));
        Assert.assertTrue((hri == null ? 1 : 0) != 0);
        kvs.clear();
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)HRegionInfo.FIRST_META_REGIONINFO)));
        hri = CatalogJanitor.getHRegionInfo((Result)new Result(kvs));
        Assert.assertNotNull((Object)hri);
        Assert.assertTrue((boolean)hri.equals((Object)HRegionInfo.FIRST_META_REGIONINFO));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanParent() throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testCleanParent");
        MockServer server = new MockServer(htu);
        try {
            MockMasterServices services = new MockMasterServices(server);
            CatalogJanitor janitor = new CatalogJanitor((Server)server, (MasterServices)services);
            HTableDescriptor htd = new HTableDescriptor("table");
            htd.addFamily(new HColumnDescriptor("f"));
            HRegionInfo parent = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
            HRegionInfo splita = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
            HRegionInfo splitb = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
            kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, Writables.getBytes((Writable)splita)));
            kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, Writables.getBytes((Writable)splitb)));
            Result r = new Result(kvs);
            Path rootdir = services.getMasterFileSystem().getRootDir();
            Path tabledir = HTableDescriptor.getTableDir((Path)rootdir, (byte[])htd.getName());
            Path storedir = Store.getStoreHomedir((Path)tabledir, (String)splita.getEncodedName(), (byte[])htd.getColumnFamilies()[0].getName());
            Reference ref = new Reference(Bytes.toBytes((String)"ccc"), Reference.Range.top);
            long now = System.currentTimeMillis();
            Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
            FileSystem fs = services.getMasterFileSystem().getFileSystem();
            Path path = ref.write(fs, p);
            Assert.assertTrue((boolean)fs.exists(path));
            Assert.assertFalse((boolean)janitor.cleanParent(parent, r));
            Assert.assertTrue((boolean)fs.delete(p, true));
            Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        }
        finally {
            server.stop("shutdown");
        }
    }

    @Test
    public void testParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst("testParentCleanedEvenIfDaughterGoneFirst", Bytes.toBytes((String)"eee"));
    }

    @Test
    public void testLastParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst("testLastParentCleanedEvenIfDaughterGoneFirst", new byte[0]);
    }

    private void parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst(String rootDir, byte[] lastEndKey) throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, rootDir);
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor((Server)server, (MasterServices)services);
        HTableDescriptor htd = this.createHTableDescriptor();
        HRegionInfo parent = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), lastEndKey);
        Thread.sleep(1001L);
        HRegionInfo splita = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        Thread.sleep(1001L);
        HRegionInfo splitaa = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        HRegionInfo splitab = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"ccc"), lastEndKey);
        Thread.sleep(1001L);
        HRegionInfo splitba = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"));
        HRegionInfo splitbb = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"ddd"), lastEndKey);
        TreeMap<HRegionInfo, Result> regions = new TreeMap<HRegionInfo, Result>((Comparator<HRegionInfo>)new CatalogJanitor.SplitParentFirstComparator());
        regions.put(parent, this.createResult(parent, splita, splitb));
        regions.put(splitb, this.createResult(splitb, splitba, splitbb));
        regions.put(splita, this.createResult(splita, splitaa, splitab));
        int index = 0;
        for (Map.Entry e : regions.entrySet()) {
            if (index == 0) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(parent.getEncodedName()));
            } else if (index == 1) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(splita.getEncodedName()));
            } else if (index == 2) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(splitb.getEncodedName()));
            }
            ++index;
        }
        Path splitaRef = this.createReferences(services, htd, parent, splita, Bytes.toBytes((String)"ccc"), false);
        Assert.assertFalse((boolean)janitor.cleanParent(parent, (Result)regions.get(parent)));
        Assert.assertTrue((boolean)janitor.cleanParent(splitb, (Result)regions.get(splitb)));
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        Path splitaaRef = this.createReferences(services, htd, splita, splitaa, Bytes.toBytes((String)"bbb"), false);
        Path splitabRef = this.createReferences(services, htd, splita, splitab, Bytes.toBytes((String)"bbb"), true);
        Assert.assertFalse((boolean)janitor.cleanParent(splita, (Result)regions.get(splita)));
        Assert.assertTrue((boolean)fs.delete(splitaaRef, true));
        Assert.assertTrue((boolean)fs.delete(splitabRef, true));
        Assert.assertTrue((boolean)janitor.cleanParent(splita, (Result)regions.get(splita)));
        Assert.assertTrue((boolean)janitor.cleanParent(parent, (Result)regions.get(parent)));
        services.stop("test finished");
        janitor.join();
    }

    @Test
    public void testScanDoesNotCleanRegionsWithExistingParents() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testScanDoesNotCleanRegionsWithExistingParents");
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        HTableDescriptor htd = this.createHTableDescriptor();
        HRegionInfo parent = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), new byte[0], true);
        Thread.sleep(1001L);
        HRegionInfo splita = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"), true);
        Thread.sleep(1001L);
        HRegionInfo splitaa = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), false);
        HRegionInfo splitab = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), false);
        HRegionInfo splitb = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"ccc"), new byte[0]);
        Thread.sleep(1001L);
        TreeMap<HRegionInfo, Result> splitParents = new TreeMap<HRegionInfo, Result>((Comparator<HRegionInfo>)new CatalogJanitor.SplitParentFirstComparator());
        splitParents.put(parent, this.makeResultFromHRegionInfo(parent, splita, splitb));
        splita.setOffline(true);
        splitParents.put(splita, this.makeResultFromHRegionInfo(splita, splitaa, splitab));
        CatalogJanitor janitor = (CatalogJanitor)Mockito.spy((Object)new CatalogJanitor((Server)server, (MasterServices)services));
        ((CatalogJanitor)Mockito.doReturn((Object)new Pair((Object)10, splitParents)).when((Object)janitor)).getSplitParents();
        Path splitaRef = this.createReferences(services, htd, parent, splita, Bytes.toBytes((String)"ccc"), false);
        Assert.assertEquals((long)0L, (long)janitor.scan());
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        Assert.assertEquals((long)2L, (long)janitor.scan());
        services.stop("test finished");
        janitor.join();
    }

    @Test
    public void testArchiveOldRegion() throws Exception {
        FileStatus[] storeFiles;
        String table = "table";
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testCleanParent");
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor((Server)server, (MasterServices)services);
        HTableDescriptor htd = new HTableDescriptor(table);
        htd.addFamily(new HColumnDescriptor("f"));
        HRegionInfo parent = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        HRegionInfo splita = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, Writables.getBytes((Writable)splita)));
        kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, Writables.getBytes((Writable)splitb)));
        Result r = new Result(kvs);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Path rootdir = services.getMasterFileSystem().getRootDir();
        FSUtils.setRootDir((Configuration)fs.getConf(), (Path)rootdir);
        Path tabledir = HTableDescriptor.getTableDir((Path)rootdir, (byte[])htd.getName());
        Path storedir = Store.getStoreHomedir((Path)tabledir, (String)parent.getEncodedName(), (byte[])htd.getColumnFamilies()[0].getName());
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath((Configuration)services.getConfiguration(), (HRegionInfo)parent, (Path)tabledir, (byte[])htd.getColumnFamilies()[0].getName());
        this.addMockStoreFiles(2, services, storedir);
        for (FileStatus file : storeFiles = fs.listStatus(storedir)) {
            System.out.println("Have store file:" + file.getPath());
        }
        Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        services.stop("Test finished");
        server.stop("shutdown");
        janitor.join();
    }

    @Test
    public void testDuplicateHFileResolution() throws Exception {
        String table = "table";
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testCleanParent");
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor((Server)server, (MasterServices)services);
        HTableDescriptor htd = new HTableDescriptor(table);
        htd.addFamily(new HColumnDescriptor("f"));
        HRegionInfo parent = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        HRegionInfo splita = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(htd.getName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, Writables.getBytes((Writable)splita)));
        kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, Writables.getBytes((Writable)splitb)));
        Result r = new Result(kvs);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Path rootdir = services.getMasterFileSystem().getRootDir();
        FSUtils.setRootDir((Configuration)fs.getConf(), (Path)rootdir);
        Path tabledir = HTableDescriptor.getTableDir((Path)rootdir, (byte[])parent.getTableName());
        Path storedir = Store.getStoreHomedir((Path)tabledir, (String)parent.getEncodedName(), (byte[])htd.getColumnFamilies()[0].getName());
        System.out.println("Old root:" + rootdir);
        System.out.println("Old table:" + tabledir);
        System.out.println("Old store:" + storedir);
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath((Configuration)services.getConfiguration(), (HRegionInfo)parent, (Path)tabledir, (byte[])htd.getColumnFamilies()[0].getName());
        System.out.println("Old archive:" + storeArchive);
        this.addMockStoreFiles(2, services, storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        this.addMockStoreFiles(2, services, storedir);
        Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs, true);
        services.stop("Test finished");
        server.stop("shutdown");
        janitor.join();
    }

    private void addMockStoreFiles(int count, MasterServices services, Path storedir) throws IOException {
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        fs.mkdirs(storedir);
        for (int i = 0; i < count; ++i) {
            Path storeFile = new Path(storedir, "_store" + i);
            FSDataOutputStream dos = fs.create(storeFile, true);
            dos.writeBytes("Some data: " + i);
            dos.close();
        }
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertEquals((long)count, (long)storeFiles.length);
    }

    private Result makeResultFromHRegionInfo(HRegionInfo region, HRegionInfo splita, HRegionInfo splitb) throws IOException {
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(region.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)region)));
        if (splita != null) {
            kvs.add(new KeyValue(region.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, Writables.getBytes((Writable)splita)));
        }
        if (splitb != null) {
            kvs.add(new KeyValue(region.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, Writables.getBytes((Writable)splitb)));
        }
        return new Result(kvs);
    }

    private String setRootDirAndCleanIt(HBaseTestingUtility htu, String subdir) throws IOException {
        Path testdir = htu.getDataTestDir(subdir);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        if (fs.exists(testdir)) {
            Assert.assertTrue((boolean)fs.delete(testdir, true));
        }
        htu.getConfiguration().set("hbase.rootdir", testdir.toString());
        return htu.getConfiguration().get("hbase.rootdir");
    }

    private Path createReferences(MasterServices services, HTableDescriptor htd, HRegionInfo parent, HRegionInfo daughter, byte[] midkey, boolean top) throws IOException {
        Path rootdir = services.getMasterFileSystem().getRootDir();
        Path tabledir = HTableDescriptor.getTableDir((Path)rootdir, (byte[])parent.getTableName());
        Path storedir = Store.getStoreHomedir((Path)tabledir, (String)daughter.getEncodedName(), (byte[])htd.getColumnFamilies()[0].getName());
        Reference ref = new Reference(midkey, top ? Reference.Range.top : Reference.Range.bottom);
        long now = System.currentTimeMillis();
        Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        ref.write(fs, p);
        return p;
    }

    private Result createResult(HRegionInfo parent, HRegionInfo a, HRegionInfo b) throws IOException {
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, Writables.getBytes((Writable)a)));
        kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, Writables.getBytes((Writable)b)));
        return new Result(kvs);
    }

    private HTableDescriptor createHTableDescriptor() {
        HTableDescriptor htd = new HTableDescriptor("t");
        htd.addFamily(new HColumnDescriptor("f"));
        return htd;
    }

    class MockMasterServices
    implements MasterServices {
        private final MasterFileSystem mfs;
        private final AssignmentManager asm;
        private boolean stopped = false;

        MockMasterServices(Server server) throws IOException {
            this.mfs = new MasterFileSystem(server, (MasterServices)this, null, false);
            this.asm = (AssignmentManager)Mockito.mock(AssignmentManager.class);
        }

        public void checkTableModifiable(byte[] tableName) throws IOException {
        }

        public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        }

        public AssignmentManager getAssignmentManager() {
            return this.asm;
        }

        public ExecutorService getExecutorService() {
            return null;
        }

        public MasterFileSystem getMasterFileSystem() {
            return this.mfs;
        }

        public ServerManager getServerManager() {
            return null;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        public CatalogTracker getCatalogTracker() {
            return null;
        }

        public Configuration getConfiguration() {
            return this.mfs.conf;
        }

        public ServerName getServerName() {
            return null;
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public TableDescriptors getTableDescriptors() {
            return new TableDescriptors(){

                public HTableDescriptor remove(String tablename) throws IOException {
                    return null;
                }

                public Map<String, HTableDescriptor> getAll() throws IOException {
                    return null;
                }

                public HTableDescriptor get(byte[] tablename) throws IOException {
                    return this.get(Bytes.toString((byte[])tablename));
                }

                public HTableDescriptor get(String tablename) throws IOException {
                    return TestCatalogJanitor.this.createHTableDescriptor();
                }

                public void add(HTableDescriptor htd) throws IOException {
                }
            };
        }

        public boolean isServerShutdownHandlerEnabled() {
            return true;
        }

        public MasterCoprocessorHost getCoprocessorHost() {
            return null;
        }

        public <T extends CoprocessorProtocol> boolean registerProtocol(Class<T> protocol, T handler) {
            return false;
        }

        public void deleteTable(byte[] tableName) throws IOException {
        }

        public void modifyTable(byte[] tableName, HTableDescriptor descriptor) throws IOException {
        }

        public void enableTable(byte[] tableName) throws IOException {
        }

        public void disableTable(byte[] tableName) throws IOException {
        }

        public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        }

        public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        }

        public void deleteColumn(byte[] tableName, byte[] columnName) throws IOException {
        }
    }

    class MockServer
    implements Server {
        private final HConnection connection;
        private final Configuration c;
        private final CatalogTracker ct;

        MockServer(HBaseTestingUtility htu) throws NotAllMetaRegionsOnlineException, IOException, InterruptedException {
            this.c = htu.getConfiguration();
            this.connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(this.c, (HRegionInterface)Mockito.mock(HRegionInterface.class), new ServerName("example.org,12345,6789"), HRegionInfo.FIRST_META_REGIONINFO);
            FileSystem fs = FileSystem.get((Configuration)this.c);
            Path rootdir = fs.makeQualified(new Path(this.c.get("hbase.rootdir")));
            this.c.set("hbase.rootdir", rootdir.toString());
            this.ct = (CatalogTracker)Mockito.mock(CatalogTracker.class);
            HRegionInterface hri = (HRegionInterface)Mockito.mock(HRegionInterface.class);
            Mockito.when((Object)this.ct.getConnection()).thenReturn((Object)this.connection);
            Mockito.when((Object)this.ct.waitForMetaServerConnection(Mockito.anyLong())).thenReturn((Object)hri);
        }

        public CatalogTracker getCatalogTracker() {
            return this.ct;
        }

        public Configuration getConfiguration() {
            return this.c;
        }

        public ServerName getServerName() {
            return new ServerName("mockserver.example.org", 1234, -1L);
        }

        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public boolean isStopped() {
            return false;
        }

        public void stop(String why) {
            if (this.ct != null) {
                this.ct.stop();
            }
            if (this.connection != null) {
                HConnectionManager.deleteConnection((Configuration)this.connection.getConfiguration());
            }
        }
    }
}

