/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.master.TestSplitLogManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestDistributedLogSplitting {
    private static final Log LOG = LogFactory.getLog(TestSplitLogManager.class);
    final int NUM_MASTERS = 2;
    final int NUM_RS = 6;
    MiniHBaseCluster cluster;
    HMaster master;
    Configuration conf;
    HBaseTestingUtility TEST_UTIL;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    private void startCluster(int num_rs) throws Exception {
        ZKSplitLog.Counters.resetCounters();
        LOG.info((Object)"Starting cluster");
        this.conf = HBaseConfiguration.create();
        this.conf.getLong("hbase.splitlog.max.resubmit", 0L);
        this.conf.setInt("zookeeper.recovery.retry", 0);
        this.TEST_UTIL = new HBaseTestingUtility(this.conf);
        this.TEST_UTIL.startMiniCluster(2, num_rs);
        this.cluster = this.TEST_UTIL.getHBaseCluster();
        LOG.info((Object)"Waiting for active/ready master");
        this.cluster.waitForActiveAndReadyMaster();
        this.master = this.cluster.getMaster();
        while (this.cluster.getLiveRegionServerThreads().size() < num_rs) {
            Threads.sleep((long)1L);
        }
    }

    @After
    public void after() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testThreeRSAbort() throws Exception {
        LOG.info((Object)"testThreeRSAbort");
        int NUM_REGIONS_TO_CREATE = 40;
        int NUM_ROWS_PER_REGION = 100;
        this.startCluster(6);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "distributed log splitting test", null);
        HTable ht = this.installTable(zkw, "table", "family", 40);
        this.populateDataInTable(100, "family");
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)6L, (long)rsts.size());
        rsts.get(0).getRegionServer().abort("testing");
        rsts.get(1).getRegionServer().abort("testing");
        rsts.get(2).getRegionServer().abort("testing");
        long start = EnvironmentEdgeManager.currentTimeMillis();
        while (this.cluster.getLiveRegionServerThreads().size() > 3) {
            if (EnvironmentEdgeManager.currentTimeMillis() - start > 60000L) {
                Assert.assertTrue((boolean)false);
            }
            Thread.sleep(200L);
        }
        start = EnvironmentEdgeManager.currentTimeMillis();
        while (this.getAllOnlineRegions(this.cluster).size() < 42) {
            if (EnvironmentEdgeManager.currentTimeMillis() - start > 60000L) {
                Assert.assertTrue((boolean)false);
            }
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)4000L, (long)this.TEST_UTIL.countRows(ht));
        ht.close();
    }

    @Test(timeout=300000L)
    public void testRecoveredEdits() throws Exception {
        LOG.info((Object)"testRecoveredEdits");
        this.startCluster(6);
        int NUM_LOG_LINES = 1000;
        SplitLogManager slm = this.master.getMasterFileSystem().splitLogManager;
        this.master.balanceSwitch(false);
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        Path rootdir = FSUtils.getRootDir((Configuration)this.conf);
        this.installTable(new ZooKeeperWatcher(this.conf, "table-creation", null), "table", "family", 40);
        byte[] table = Bytes.toBytes((String)"table");
        List regions = null;
        HRegionServer hrs = null;
        for (int i = 0; i < 6 && (regions = (hrs = rsts.get(i).getRegionServer()).getOnlineRegions()).size() == 0; ++i) {
        }
        Path logDir = new Path(rootdir, HLog.getHLogDirectoryName((String)hrs.getServerName().toString()));
        LOG.info((Object)("#regions = " + regions.size()));
        Iterator it = regions.iterator();
        while (it.hasNext()) {
            HRegionInfo region = (HRegionInfo)it.next();
            if (!region.isMetaTable()) continue;
            it.remove();
        }
        this.makeHLog(hrs.getWAL(), regions, "table", 1000, 100);
        slm.splitLogDistributed(logDir);
        int count = 0;
        for (HRegionInfo hri : regions) {
            Path tdir = HTableDescriptor.getTableDir((Path)rootdir, (byte[])table);
            Path editsdir = HLog.getRegionDirRecoveredEditsDir((Path)HRegion.getRegionDir((Path)tdir, (String)hri.getEncodedName()));
            LOG.debug((Object)("checking edits dir " + editsdir));
            FileStatus[] files = fs.listStatus(editsdir);
            Assert.assertEquals((long)1L, (long)files.length);
            int c = this.countHLog(files[0].getPath(), fs, this.conf);
            count += c;
            LOG.info((Object)(c + " edits in " + files[0].getPath()));
        }
        Assert.assertEquals((long)1000L, (long)count);
    }

    @Test(timeout=300000L)
    public void testWorkerAbort() throws Exception {
        LOG.info((Object)"testWorkerAbort");
        this.startCluster(1);
        int NUM_LOG_LINES = 10000;
        SplitLogManager slm = this.master.getMasterFileSystem().splitLogManager;
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        final List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        HRegionServer hrs = rsts.get(0).getRegionServer();
        Path rootdir = FSUtils.getRootDir((Configuration)this.conf);
        Path logDir = new Path(rootdir, HLog.getHLogDirectoryName((String)hrs.getServerName().toString()));
        this.installTable(new ZooKeeperWatcher(this.conf, "table-creation", null), "table", "family", 40);
        this.makeHLog(hrs.getWAL(), hrs.getOnlineRegions(), "table", 10000, 100);
        new Thread(){

            @Override
            public void run() {
                TestDistributedLogSplitting.this.waitForCounter(ZKSplitLog.Counters.tot_wkr_task_acquired, 0L, 1L, 1000L);
                for (JVMClusterUtil.RegionServerThread rst : rsts) {
                    rst.getRegionServer().abort("testing");
                }
            }
        }.start();
        FileStatus[] logfiles = fs.listStatus(logDir);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        slm.enqueueSplitTask(logfiles[0].getPath().toString(), batch);
        long curt = System.currentTimeMillis();
        long waitTime = 80000L;
        long endt = curt + waitTime;
        while (curt < endt) {
            if (ZKSplitLog.Counters.tot_wkr_task_resigned.get() + ZKSplitLog.Counters.tot_wkr_task_err.get() + ZKSplitLog.Counters.tot_wkr_final_transistion_failed.get() + ZKSplitLog.Counters.tot_wkr_task_done.get() + ZKSplitLog.Counters.tot_wkr_preempt_task.get() == 0L) {
                Thread.yield();
                curt = System.currentTimeMillis();
                continue;
            }
            Assert.assertEquals((long)1L, (long)(ZKSplitLog.Counters.tot_wkr_task_resigned.get() + ZKSplitLog.Counters.tot_wkr_task_err.get() + ZKSplitLog.Counters.tot_wkr_final_transistion_failed.get() + ZKSplitLog.Counters.tot_wkr_task_done.get() + ZKSplitLog.Counters.tot_wkr_preempt_task.get()));
            return;
        }
        Assert.fail((String)("none of the following counters went up in " + waitTime + " milliseconds - " + "tot_wkr_task_resigned, tot_wkr_task_err, " + "tot_wkr_final_transistion_failed, tot_wkr_task_done, " + "tot_wkr_preempt_task"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDelayedDeleteOnFailure() throws Exception {
        LOG.info((Object)"testDelayedDeleteOnFailure");
        this.startCluster(1);
        final SplitLogManager slm = this.master.getMasterFileSystem().splitLogManager;
        final FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        final Path logDir = new Path(FSUtils.getRootDir((Configuration)this.conf), "x");
        fs.mkdirs(logDir);
        ExecutorService executor = null;
        try {
            final Path corruptedLogFile = new Path(logDir, "x");
            FSDataOutputStream out = fs.create(corruptedLogFile);
            out.write(0);
            out.write(Bytes.toBytes((String)"corrupted bytes"));
            out.close();
            slm.ignoreZKDeleteForTesting = true;
            executor = Executors.newSingleThreadExecutor();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        slm.splitLogDistributed(logDir);
                    }
                    catch (IOException ioe) {
                        try {
                            Assert.assertTrue((boolean)fs.exists(corruptedLogFile));
                            slm.splitLogDistributed(logDir);
                        }
                        catch (IOException e) {
                            Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                            return;
                        }
                        Assert.fail((String)"did not get the expected IOException from the 2nd call");
                    }
                    Assert.fail((String)"did not get the expected IOException from the 1st call");
                }
            };
            Future<?> result = executor.submit(runnable);
            try {
                result.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                // empty catch block
            }
            this.waitForCounter(ZKSplitLog.Counters.tot_mgr_wait_for_zk_delete, 0L, 1L, 10000L);
            executor.shutdownNow();
            executor = null;
            result.get();
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
            fs.delete(logDir, true);
        }
    }

    HTable installTable(ZooKeeperWatcher zkw, String tname, String fname, int nrs) throws Exception {
        byte[] table = Bytes.toBytes((String)tname);
        byte[] family = Bytes.toBytes((String)fname);
        LOG.info((Object)("Creating table with " + nrs + " regions"));
        HTable ht = this.TEST_UTIL.createTable(table, family);
        int numRegions = this.TEST_UTIL.createMultiRegions(this.conf, ht, family, nrs);
        Assert.assertEquals((long)nrs, (long)numRegions);
        LOG.info((Object)"Waiting for no more RIT\n");
        this.blockUntilNoRIT(zkw, this.master);
        LOG.debug((Object)"Disabling table\n");
        this.TEST_UTIL.getHBaseAdmin().disableTable(table);
        LOG.debug((Object)"Waiting for no more RIT\n");
        this.blockUntilNoRIT(zkw, this.master);
        NavigableSet<String> regions = this.getAllOnlineRegions(this.cluster);
        LOG.debug((Object)"Verifying only catalog regions are assigned\n");
        if (regions.size() != 2) {
            for (String oregion : regions) {
                LOG.debug((Object)("Region still online: " + oregion));
            }
        }
        Assert.assertEquals((long)2L, (long)regions.size());
        LOG.debug((Object)"Enabling table\n");
        this.TEST_UTIL.getHBaseAdmin().enableTable(table);
        LOG.debug((Object)"Waiting for no more RIT\n");
        this.blockUntilNoRIT(zkw, this.master);
        LOG.debug((Object)("Verifying there are " + numRegions + " assigned on cluster\n"));
        regions = this.getAllOnlineRegions(this.cluster);
        Assert.assertEquals((long)(numRegions + 2), (long)regions.size());
        return ht;
    }

    void populateDataInTable(int nrows, String fname) throws Exception {
        byte[] family = Bytes.toBytes((String)fname);
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)6L, (long)rsts.size());
        for (JVMClusterUtil.RegionServerThread rst : rsts) {
            HRegionServer hrs = rst.getRegionServer();
            List hris = hrs.getOnlineRegions();
            for (HRegionInfo hri : hris) {
                if (hri.isMetaTable()) continue;
                LOG.debug((Object)("adding data to rs = " + rst.getName() + " region = " + hri.getRegionNameAsString()));
                HRegion region = hrs.getOnlineRegion(hri.getRegionName());
                Assert.assertTrue((region != null ? 1 : 0) != 0);
                this.putData(region, hri.getStartKey(), nrows, Bytes.toBytes((String)"q"), new byte[][]{family});
            }
        }
    }

    public void makeHLog(HLog log, List<HRegionInfo> hris, String tname, int num_edits, int edit_size) throws IOException {
        int i;
        byte[] table = Bytes.toBytes((String)tname);
        HTableDescriptor htd = new HTableDescriptor(tname);
        byte[] value = new byte[edit_size];
        for (int i2 = 0; i2 < edit_size; ++i2) {
            value[i2] = (byte)(97 + i2 % 26);
        }
        int n = hris.size();
        int[] counts = new int[n];
        int j = 0;
        if (n > 0) {
            for (i = 0; i < num_edits; ++i) {
                WALEdit e = new WALEdit();
                byte[] row = Bytes.toBytes((String)("r" + Integer.toString(i)));
                byte[] family = Bytes.toBytes((String)"f");
                byte[] qualifier = Bytes.toBytes((String)("c" + Integer.toString(i)));
                e.add(new KeyValue(row, family, qualifier, System.currentTimeMillis(), value));
                log.append(hris.get(++j % n), table, e, System.currentTimeMillis(), htd);
                int n2 = j % n;
                counts[n2] = counts[n2] + 1;
            }
        }
        log.sync();
        log.close();
        for (i = 0; i < n; ++i) {
            LOG.info((Object)("region " + hris.get(i).getRegionNameAsString() + " has " + counts[i] + " edits"));
        }
    }

    private int countHLog(Path log, FileSystem fs, Configuration conf) throws IOException {
        int count = 0;
        HLog.Reader in = HLog.getReader((FileSystem)fs, (Path)log, (Configuration)conf);
        while (in.next() != null) {
            ++count;
        }
        return count;
    }

    private void blockUntilNoRIT(ZooKeeperWatcher zkw, HMaster master) throws KeeperException, InterruptedException {
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        master.assignmentManager.waitUntilNoRegionsInTransition(60000L);
    }

    private void putData(HRegion region, byte[] startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            Put put = new Put(Bytes.add((byte[])startRow, (byte[])Bytes.toBytes((int)i)));
            for (byte[] family : families) {
                put.add(family, qf, null);
            }
            region.put(put);
        }
    }

    private NavigableSet<String> getAllOnlineRegions(MiniHBaseCluster cluster) throws IOException {
        TreeSet<String> online = new TreeSet<String>();
        for (JVMClusterUtil.RegionServerThread rst : cluster.getLiveRegionServerThreads()) {
            for (HRegionInfo region : rst.getRegionServer().getOnlineRegions()) {
                online.add(region.getRegionNameAsString());
            }
        }
        return online;
    }

    private void waitForCounter(AtomicLong ctr, long oldval, long newval, long timems) {
        long curt = System.currentTimeMillis();
        long endt = curt + timems;
        while (curt < endt) {
            if (ctr.get() == oldval) {
                Thread.yield();
                curt = System.currentTimeMillis();
                continue;
            }
            Assert.assertEquals((long)newval, (long)ctr.get());
            return;
        }
        Assert.assertTrue((boolean)false);
    }

    static {
        Logger.getLogger((String)"org.apache.hadoop.hbase").setLevel(Level.DEBUG);
    }
}

