/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.HashSet;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MXBeanImpl;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMXBean {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniCluster(1, 4);
    }

    @AfterClass
    public static void teardown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private void verifyRegionServers(Map<String, HServerLoad> regions) {
        HashSet<String> expected = new HashSet<String>();
        for (int i = 0; i < 4; ++i) {
            HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(i);
            expected.add(rs.getServerName().getServerName());
        }
        int found = 0;
        for (Map.Entry<String, HServerLoad> entry : regions.entrySet()) {
            if (!expected.contains(entry.getKey())) continue;
            ++found;
        }
        Assert.assertEquals((int)4, (int)found);
    }

    @Test
    public void testInfo() {
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        MXBeanImpl info = MXBeanImpl.init((HMaster)master);
        Assert.assertEquals((Object)master.getAverageLoad(), (Object)info.getAverageLoad());
        Assert.assertEquals((String)master.getClusterId(), (String)info.getClusterId());
        Assert.assertEquals((long)master.getMasterActiveTime(), (long)info.getMasterActiveTime());
        Assert.assertEquals((long)master.getMasterStartTime(), (long)info.getMasterStartTime());
        Assert.assertEquals((int)master.getCoprocessors().length, (int)info.getCoprocessors().length);
        Assert.assertEquals((int)master.getServerManager().getOnlineServersList().size(), (int)info.getRegionServers().size());
        Assert.assertEquals((boolean)master.getAssignmentManager().isRegionsInTransition(), (info.getRegionsInTransition().length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((info.getRegionServers().size() == 4 ? 1 : 0) != 0);
        String zkServers = info.getZookeeperQuorum();
        Assert.assertEquals((int)zkServers.split(",").length, (int)TEST_UTIL.getZkCluster().getZooKeeperServerNum());
        this.verifyRegionServers(info.getRegionServers());
        TEST_UTIL.getMiniHBaseCluster().stopRegionServer(3, false);
        TEST_UTIL.getMiniHBaseCluster().waitOnRegionServer(3);
        Assert.assertTrue((info.getRegionServers().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((info.getDeadRegionServers().length == 1 ? 1 : 0) != 0);
    }
}

