/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMaster {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestMaster.class);
    private static final byte[] TABLENAME = Bytes.toBytes((String)"TestMaster");
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterOpsWhileSplitting() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILYNAME);
        Assert.assertTrue((boolean)m.assignmentManager.getZKTable().isEnabledTable(Bytes.toString((byte[])TABLENAME)));
        TEST_UTIL.loadTable(ht, FAMILYNAME);
        ht.close();
        List tableRegions = MetaReader.getTableRegionsAndLocations((CatalogTracker)m.getCatalogTracker(), (String)Bytes.toString((byte[])TABLENAME));
        LOG.info((Object)("Regions after load: " + Joiner.on((char)',').join((Iterable)tableRegions)));
        Assert.assertEquals((long)1L, (long)tableRegions.size());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])((HRegionInfo)((Pair)tableRegions.get(0)).getFirst()).getStartKey());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])((HRegionInfo)((Pair)tableRegions.get(0)).getFirst()).getEndKey());
        CountDownLatch split = new CountDownLatch(1);
        CountDownLatch proceed = new CountDownLatch(1);
        RegionSplitListener list = new RegionSplitListener(split, proceed);
        cluster.getMaster().executorService.registerListener(EventHandler.EventType.RS_ZK_REGION_SPLIT, (EventHandler.EventHandlerListener)list);
        LOG.info((Object)"Splitting table");
        TEST_UTIL.getHBaseAdmin().split(TABLENAME);
        LOG.info((Object)"Waiting for split result to be about to open");
        split.await(60L, TimeUnit.SECONDS);
        try {
            LOG.info((Object)"Making sure we can call getTableRegions while opening");
            tableRegions = MetaReader.getTableRegionsAndLocations((CatalogTracker)m.getCatalogTracker(), (byte[])TABLENAME, (boolean)false);
            LOG.info((Object)("Regions: " + Joiner.on((char)',').join((Iterable)tableRegions)));
            Assert.assertEquals((long)3L, (long)tableRegions.size());
            LOG.info((Object)"Making sure we can call getTableRegionClosest while opening");
            Pair pair = m.getTableRegionForRow(TABLENAME, Bytes.toBytes((String)"cde"));
            LOG.info((Object)("Result is: " + pair));
            Pair tableRegionFromName = MetaReader.getRegion((CatalogTracker)m.getCatalogTracker(), (byte[])((HRegionInfo)pair.getFirst()).getRegionName());
            Assert.assertEquals((Object)tableRegionFromName.getFirst(), (Object)pair.getFirst());
        }
        finally {
            proceed.countDown();
        }
    }

    static class RegionSplitListener
    implements EventHandler.EventHandlerListener {
        CountDownLatch split;
        CountDownLatch proceed;

        public RegionSplitListener(CountDownLatch split, CountDownLatch proceed) {
            this.split = split;
            this.proceed = proceed;
        }

        public void afterProcess(EventHandler event) {
            if (event.getEventType() != EventHandler.EventType.RS_ZK_REGION_SPLIT) {
                return;
            }
            try {
                this.split.countDown();
                this.proceed.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }

        public void beforeProcess(EventHandler event) {
        }
    }
}

