/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMasterShutdown {
    private static final Log LOG = LogFactory.getLog(TestMasterShutdown.class);
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test(timeout=240000L)
    public void testMasterShutdown() throws Exception {
        int NUM_MASTERS = 3;
        int NUM_RS = 3;
        Configuration conf = HBaseConfiguration.create();
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(3, 3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (JVMClusterUtil.MasterThread mt : masterThreads) {
            Assert.assertTrue((boolean)mt.isAlive());
        }
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            active = masterThreads.get(i).getMaster();
            break;
        }
        Assert.assertNotNull(active);
        ClusterStatus status = active.getClusterStatus();
        Assert.assertEquals((long)2L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)2L, (long)status.getBackupMasters().size());
        active.shutdown();
        for (int i = 2; i >= 0; --i) {
            cluster.waitOnMaster(i);
        }
        Assert.assertEquals((long)0L, (long)masterThreads.size());
        TEST_UTIL.shutdownMiniCluster();
    }
}

