/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl;
import org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestMasterStatusServlet {
    private HMaster master;
    private Configuration conf;
    private HBaseAdmin admin;
    static final ServerName FAKE_HOST = new ServerName("fakehost", 12345, 1234567890L);
    static final HTableDescriptor FAKE_TABLE = new HTableDescriptor("mytable");
    static final HRegionInfo FAKE_HRI = new HRegionInfo(FAKE_TABLE.getName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Before
    public void setupBasicMocks() {
        this.conf = HBaseConfiguration.create();
        this.master = (HMaster)Mockito.mock(HMaster.class);
        ((HMaster)Mockito.doReturn((Object)FAKE_HOST).when((Object)this.master)).getServerName();
        ((HMaster)Mockito.doReturn((Object)this.conf).when((Object)this.master)).getConfiguration();
        ServerManager serverManager = (ServerManager)Mockito.mock(ServerManager.class);
        ((ServerManager)Mockito.doReturn((Object)1.0).when((Object)serverManager)).getAverageLoad();
        ((HMaster)Mockito.doReturn((Object)serverManager).when((Object)this.master)).getServerManager();
        AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
        TreeMap regionsInTransition = Maps.newTreeMap();
        regionsInTransition.put("r1", new AssignmentManager.RegionState(FAKE_HRI, AssignmentManager.RegionState.State.CLOSING, 12345L, FAKE_HOST));
        ((AssignmentManager)Mockito.doReturn((Object)regionsInTransition).when((Object)am)).getRegionsInTransition();
        ((HMaster)Mockito.doReturn((Object)am).when((Object)this.master)).getAssignmentManager();
        ZooKeeperWatcher zkw = (ZooKeeperWatcher)Mockito.mock(ZooKeeperWatcher.class);
        ((ZooKeeperWatcher)Mockito.doReturn((Object)"fakequorum").when((Object)zkw)).getQuorum();
        ((HMaster)Mockito.doReturn((Object)zkw).when((Object)this.master)).getZooKeeperWatcher();
        this.admin = (HBaseAdmin)Mockito.mock(HBaseAdmin.class);
    }

    private void setupMockTables() throws IOException {
        HTableDescriptor[] tables = new HTableDescriptor[]{new HTableDescriptor("foo"), new HTableDescriptor("bar")};
        ((HBaseAdmin)Mockito.doReturn((Object)tables).when((Object)this.admin)).listTables();
    }

    @Test
    public void testStatusTemplateNoTables() throws IOException {
        new MasterStatusTmpl().render((Writer)new StringWriter(), this.master, this.admin);
    }

    @Test
    public void testStatusTemplateRootAvailable() throws IOException {
        new MasterStatusTmpl().setRootLocation(new ServerName("rootserver:123,12345")).render((Writer)new StringWriter(), this.master, this.admin);
    }

    @Test
    public void testStatusTemplateRootAndMetaAvailable() throws IOException {
        this.setupMockTables();
        new MasterStatusTmpl().setRootLocation(new ServerName("rootserver:123,12345")).setMetaLocation(new ServerName("metaserver:123,12345")).render((Writer)new StringWriter(), this.master, this.admin);
    }

    @Test
    public void testStatusTemplateWithServers() throws IOException {
        this.setupMockTables();
        ArrayList servers = Lists.newArrayList((Object[])new ServerName[]{new ServerName("rootserver:123,12345"), new ServerName("metaserver:123,12345")});
        HashSet deadServers = new HashSet(Lists.newArrayList((Object[])new ServerName[]{new ServerName("badserver:123,12345"), new ServerName("uglyserver:123,12345")}));
        new MasterStatusTmpl().setRootLocation(new ServerName("rootserver:123,12345")).setMetaLocation(new ServerName("metaserver:123,12345")).setServers((List)servers).setDeadServers(deadServers).render((Writer)new StringWriter(), this.master, this.admin);
    }

    @Test
    public void testAssignmentManagerTruncatedList() throws IOException {
        AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
        TreeMap regionsInTransition = Maps.newTreeMap();
        for (byte i = 0; i < 100; i = (byte)((byte)(i + 1))) {
            HRegionInfo hri = new HRegionInfo(FAKE_TABLE.getName(), new byte[]{i}, new byte[]{(byte)(i + 1)});
            regionsInTransition.put(hri.getEncodedName(), new AssignmentManager.RegionState(hri, AssignmentManager.RegionState.State.CLOSING, 12345L, FAKE_HOST));
        }
        regionsInTransition.put(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName(), new AssignmentManager.RegionState(HRegionInfo.FIRST_META_REGIONINFO, AssignmentManager.RegionState.State.CLOSING, 12345L, FAKE_HOST));
        ((AssignmentManager)Mockito.doReturn((Object)regionsInTransition).when((Object)am)).getRegionsInTransition();
        StringWriter sw = new StringWriter();
        new AssignmentManagerStatusTmpl().setLimit(50).render((Writer)sw, am);
        String result = sw.toString();
        Assert.assertTrue((boolean)result.contains(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName()));
        Matcher matcher = Pattern.compile("CLOSING").matcher(result);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        Assert.assertEquals((long)50L, (long)count);
    }
}

