/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.regionserver.TestMasterAddressManager;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSplitLogManager {
    private static final Log LOG = LogFactory.getLog(TestSplitLogManager.class);
    private ZooKeeperWatcher zkw;
    private static boolean stopped;
    private SplitLogManager slm;
    private Configuration conf;
    private int to;
    private static final HBaseTestingUtility TEST_UTIL;
    static Stoppable stopper;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setup() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        this.conf = TEST_UTIL.getConfiguration();
        this.zkw = new ZooKeeperWatcher(this.conf, "split-log-manager-tests", null);
        ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)this.zkw, (String)this.zkw.baseZNode);
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.zkw, (String)this.zkw.baseZNode);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)this.zkw.baseZNode) != -1 ? 1 : 0) != 0);
        LOG.debug((Object)(this.zkw.baseZNode + " created"));
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.zkw, (String)this.zkw.splitLogZNode);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)this.zkw.splitLogZNode) != -1 ? 1 : 0) != 0);
        LOG.debug((Object)(this.zkw.splitLogZNode + " created"));
        stopped = false;
        ZKSplitLog.Counters.resetCounters();
        this.to = 6000;
        this.conf.setInt("hbase.splitlog.manager.timeout", this.to);
        this.conf.setInt("hbase.splitlog.manager.unassigned.timeout", 2 * this.to);
        this.conf.setInt("hbase.splitlog.manager.timeoutmonitor.period", 100);
        this.to += 400;
    }

    @After
    public void teardown() throws IOException, KeeperException {
        stopper.stop("");
        this.slm.stop();
        TEST_UTIL.shutdownMiniZKCluster();
    }

    private void waitForCounter(final AtomicLong ctr, long oldval, long newval, long timems) {
        Expr e = new Expr(){

            @Override
            public long eval() {
                return ctr.get();
            }
        };
        this.waitForCounter(e, oldval, newval, timems);
    }

    private void waitForCounter(Expr e, long oldval, long newval, long timems) {
        long curt = System.currentTimeMillis();
        long endt = curt + timems;
        while (curt < endt) {
            if (e.eval() == oldval) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException eintr) {
                    // empty catch block
                }
                curt = System.currentTimeMillis();
                continue;
            }
            Assert.assertEquals((long)newval, (long)e.eval());
            return;
        }
        Assert.assertTrue((boolean)false);
    }

    private String submitTaskAndWait(SplitLogManager.TaskBatch batch, String name) throws KeeperException, InterruptedException {
        String tasknode = ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)name);
        TestMasterAddressManager.NodeCreationListener listener = new TestMasterAddressManager.NodeCreationListener(this.zkw, tasknode);
        this.zkw.registerListener((ZooKeeperListener)listener);
        ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        this.slm.enqueueSplitTask(name, batch);
        Assert.assertEquals((long)1L, (long)batch.installed);
        Assert.assertTrue((this.slm.findOrCreateOrphanTask((String)tasknode).batch == batch ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)ZKSplitLog.Counters.tot_mgr_node_create_queued.get());
        LOG.debug((Object)"waiting for task node creation");
        listener.waitForCreation();
        LOG.debug((Object)"task created");
        return tasknode;
    }

    @Test
    public void testTaskCreation() throws Exception {
        LOG.info((Object)"TestTaskCreation - test the creation of a task in zk");
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        byte[] data = ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)tasknode);
        LOG.info((Object)("Task node created " + new String(data)));
        Assert.assertTrue((boolean)ZKSplitLog.TaskState.TASK_UNASSIGNED.equals(data, "dummy-master"));
    }

    @Test
    public void testOrphanTaskAcquisition() throws Exception {
        LOG.info((Object)"TestOrphanTaskAcquisition");
        String tasknode = ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"orphan/test/slash");
        this.zkw.getRecoverableZooKeeper().create(tasknode, ZKSplitLog.TaskState.TASK_OWNED.get("dummy-worker"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_orphan_task_acquired, 0L, 1L, (long)(this.to / 2));
        SplitLogManager.Task task = this.slm.findOrCreateOrphanTask(tasknode);
        Assert.assertTrue((boolean)task.isOrphan());
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_heartbeat, 0L, 1L, (long)(this.to / 2));
        Assert.assertFalse((boolean)task.isUnassigned());
        long curt = System.currentTimeMillis();
        Assert.assertTrue((task.last_update <= curt && task.last_update > curt - 1000L ? 1 : 0) != 0);
        LOG.info((Object)"waiting for manager to resubmit the orphan task");
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_resubmit, 0L, 1L, (long)(this.to + this.to / 2));
        Assert.assertTrue((boolean)task.isUnassigned());
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_rescan, 0L, 1L, (long)(this.to + this.to / 2));
    }

    @Test
    public void testUnassignedOrphan() throws Exception {
        LOG.info((Object)"TestUnassignedOrphan - an unassigned task is resubmitted at startup");
        String tasknode = ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"orphan/test/slash");
        this.zkw.getRecoverableZooKeeper().create(tasknode, ZKSplitLog.TaskState.TASK_UNASSIGNED.get("dummy-worker"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int version = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_orphan_task_acquired, 0L, 1L, (long)(this.to / 2));
        SplitLogManager.Task task = this.slm.findOrCreateOrphanTask(tasknode);
        Assert.assertTrue((boolean)task.isOrphan());
        Assert.assertTrue((boolean)task.isUnassigned());
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_rescan, 0L, 1L, (long)(this.to / 2));
        SplitLogManager.Task task2 = this.slm.findOrCreateOrphanTask(tasknode);
        Assert.assertTrue((task == task2 ? 1 : 0) != 0);
        LOG.debug((Object)("task = " + task));
        Assert.assertEquals((long)1L, (long)ZKSplitLog.Counters.tot_mgr_resubmit.get());
        Assert.assertEquals((long)1L, (long)task.incarnation);
        Assert.assertEquals((long)0L, (long)task.unforcedResubmits);
        Assert.assertTrue((boolean)task.isOrphan());
        Assert.assertTrue((boolean)task.isUnassigned());
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode) > version ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleResubmits() throws Exception {
        LOG.info((Object)"TestMultipleResbmits - no indefinite resubmissions");
        this.conf.setInt("hbase.splitlog.max.resubmit", 2);
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        int version = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)tasknode, (byte[])ZKSplitLog.TaskState.TASK_OWNED.get("worker1"));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_heartbeat, 0L, 1L, (long)(this.to / 2));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_resubmit, 0L, 1L, (long)(this.to + this.to / 2));
        int version1 = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        Assert.assertTrue((version1 > version ? 1 : 0) != 0);
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)tasknode, (byte[])ZKSplitLog.TaskState.TASK_OWNED.get("worker2"));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_heartbeat, 1L, 2L, (long)(this.to / 2));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_resubmit, 1L, 2L, (long)(this.to + this.to / 2));
        int version2 = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        Assert.assertTrue((version2 > version1 ? 1 : 0) != 0);
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)tasknode, (byte[])ZKSplitLog.TaskState.TASK_OWNED.get("worker3"));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_heartbeat, 1L, 2L, (long)(this.to / 2));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_resubmit_threshold_reached, 0L, 1L, (long)(this.to + this.to / 2));
        Thread.sleep(this.to + this.to / 2);
        Assert.assertEquals((long)2L, (long)ZKSplitLog.Counters.tot_mgr_resubmit.get());
    }

    @Test
    public void testRescanCleanup() throws Exception {
        LOG.info((Object)"TestRescanCleanup - ensure RESCAN nodes are cleaned up");
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        int version = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)tasknode, (byte[])ZKSplitLog.TaskState.TASK_OWNED.get("worker1"));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_heartbeat, 0L, 1L, (long)(this.to / 2));
        this.waitForCounter(new Expr(){

            @Override
            public long eval() {
                return ZKSplitLog.Counters.tot_mgr_resubmit.get() + ZKSplitLog.Counters.tot_mgr_resubmit_failed.get();
            }
        }, 0L, 1L, 300000L);
        if (ZKSplitLog.Counters.tot_mgr_resubmit_failed.get() == 0L) {
            int version1 = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
            Assert.assertTrue((version1 > version ? 1 : 0) != 0);
            byte[] taskstate = ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)tasknode);
            Assert.assertTrue((boolean)Arrays.equals(ZKSplitLog.TaskState.TASK_UNASSIGNED.get("dummy-master"), taskstate));
            this.waitForCounter(ZKSplitLog.Counters.tot_mgr_rescan_deleted, 0L, 1L, (long)(this.to / 2));
        } else {
            LOG.warn((Object)"Could not run test. Lost ZK connection?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskDone() throws Exception {
        LOG.info((Object)"TestTaskDone - cleanup task node once in DONE state");
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)tasknode, (byte[])ZKSplitLog.TaskState.TASK_DONE.get("worker"));
        SplitLogManager.TaskBatch taskBatch = batch;
        synchronized (taskBatch) {
            while (batch.installed != batch.done) {
                batch.wait();
            }
        }
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_task_deleted, 0L, 1L, (long)(this.to / 2));
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode) == -1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskErr() throws Exception {
        LOG.info((Object)"TestTaskErr - cleanup task node once in ERR state");
        this.conf.setInt("hbase.splitlog.max.resubmit", 0);
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)tasknode, (byte[])ZKSplitLog.TaskState.TASK_ERR.get("worker"));
        SplitLogManager.TaskBatch taskBatch = batch;
        synchronized (taskBatch) {
            while (batch.installed != batch.error) {
                batch.wait();
            }
        }
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_task_deleted, 0L, 1L, (long)(this.to / 2));
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode) == -1 ? 1 : 0) != 0);
        this.conf.setInt("hbase.splitlog.max.resubmit", 3);
    }

    @Test
    public void testTaskResigned() throws Exception {
        LOG.info((Object)"TestTaskResigned - resubmit task node once in RESIGNED state");
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)tasknode, (byte[])ZKSplitLog.TaskState.TASK_RESIGNED.get("worker"));
        int version = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_resubmit, 0L, 1L, (long)(this.to / 2));
        int version1 = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        Assert.assertTrue((version1 > version ? 1 : 0) != 0);
        byte[] taskstate = ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)tasknode);
        Assert.assertTrue((boolean)Arrays.equals(taskstate, ZKSplitLog.TaskState.TASK_UNASSIGNED.get("dummy-master")));
    }

    @Test
    public void testUnassignedTimeout() throws Exception {
        LOG.info((Object)"TestUnassignedTimeout - iff all tasks are unassigned then resubmit");
        String tasknode1 = ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)"orphan/1");
        this.zkw.getRecoverableZooKeeper().create(tasknode1, ZKSplitLog.TaskState.TASK_OWNED.get("dummy-worker"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_orphan_task_acquired, 0L, 1L, (long)(this.to / 2));
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        this.submitTaskAndWait(batch, "foo/1");
        for (int i = 0; i < 3 * this.to / 100; ++i) {
            Thread.sleep(100L);
            ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)tasknode1, (byte[])ZKSplitLog.TaskState.TASK_OWNED.get("dummy-worker"));
        }
        LOG.info((Object)"waiting for manager to resubmit the orphan task");
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_resubmit, 0L, 1L, (long)(this.to + this.to / 2));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_resubmit_unassigned, 0L, 1L, (long)(2 * this.to + this.to / 2));
    }

    @Test
    public void testDeadWorker() throws Exception {
        LOG.info((Object)"testDeadWorker");
        this.conf.setLong("hbase.splitlog.max.resubmit", 0L);
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        int version = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        ZKUtil.setData((ZooKeeperWatcher)this.zkw, (String)tasknode, (byte[])ZKSplitLog.TaskState.TASK_OWNED.get("worker1"));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_heartbeat, 0L, 1L, (long)(this.to / 2));
        this.slm.handleDeadWorker("worker1");
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_resubmit, 0L, 1L, (long)(this.to / 2));
        this.waitForCounter(ZKSplitLog.Counters.tot_mgr_resubmit_dead_server_task, 0L, 1L, (long)(this.to + this.to / 2));
        int version1 = ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)tasknode);
        Assert.assertTrue((version1 > version ? 1 : 0) != 0);
        byte[] taskstate = ZKUtil.getData((ZooKeeperWatcher)this.zkw, (String)tasknode);
        Assert.assertTrue((boolean)Arrays.equals(ZKSplitLog.TaskState.TASK_UNASSIGNED.get("dummy-master"), taskstate));
    }

    @Test
    public void testEmptyLogDir() throws Exception {
        LOG.info((Object)"testEmptyLogDir");
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path emptyLogDirPath = new Path(fs.getWorkingDirectory(), UUID.randomUUID().toString());
        fs.mkdirs(emptyLogDirPath);
        this.slm.splitLogDistributed(emptyLogDirPath);
        Assert.assertFalse((boolean)fs.exists(emptyLogDirPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=45000L)
    public void testVanishingTaskZNode() throws Exception {
        LOG.info((Object)"testVanishingTaskZNode");
        this.conf.setInt("hbase.splitlog.manager.unassigned.timeout", 0);
        this.conf.setInt("hbase.splitlog.manager.timeoutmonitor.period", 1000);
        this.slm = new SplitLogManager(this.zkw, this.conf, stopper, "dummy-master", null);
        this.slm.finishInitialization();
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        final Path logDir = new Path(fs.getWorkingDirectory(), UUID.randomUUID().toString());
        fs.mkdirs(logDir);
        Thread thread = null;
        try {
            Path logFile = new Path(logDir, UUID.randomUUID().toString());
            fs.createNewFile(logFile);
            thread = new Thread(){

                @Override
                public void run() {
                    try {
                        TestSplitLogManager.this.slm.splitLogDistributed(logDir);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"splitLogDistributed failed", (Throwable)e);
                    }
                }
            };
            thread.start();
            this.waitForCounter(ZKSplitLog.Counters.tot_mgr_node_create_result, 0L, 1L, 10000L);
            String znode = ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)this.zkw, (String)logFile.toString());
            ZKUtil.deleteNode((ZooKeeperWatcher)this.zkw, (String)znode);
            this.waitForCounter(ZKSplitLog.Counters.tot_mgr_get_data_nonode, 0L, 1L, 30000L);
            this.waitForCounter(ZKSplitLog.Counters.tot_mgr_log_split_batch_success, 0L, 1L, (long)(this.to / 2));
            Assert.assertTrue((boolean)fs.exists(logFile));
        }
        finally {
            if (thread != null) {
                thread.interrupt();
            }
            fs.delete(logDir, true);
        }
    }

    static {
        Logger.getLogger((String)"org.apache.hadoop.hbase").setLevel(Level.DEBUG);
        stopped = false;
        TEST_UTIL = new HBaseTestingUtility();
        stopper = new Stoppable(){

            public void stop(String why) {
                stopped = true;
            }

            public boolean isStopped() {
                return stopped;
            }
        };
    }

    private static interface Expr {
        public long eval();
    }
}

