/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import com.yammer.metrics.stats.Snapshot;
import java.util.HashMap;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.metrics.MetricsMBeanBase;
import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.metrics.histogram.MetricsHistogram;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestMetricsMBeanBase
extends TestCase {
    private MetricsRegistry registry;
    private MetricsRecord metricsRecord;
    private TestStatistics stats;
    private MetricsRate metricsRate;
    private MetricsIntValue intValue;
    private MetricsTimeVaryingRate varyRate;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void setUp() {
        this.registry = new MetricsRegistry();
        this.metricsRate = new MetricsRate("metricsRate", this.registry, "test");
        this.intValue = new MetricsIntValue("intValue", this.registry, "test");
        this.varyRate = new MetricsTimeVaryingRate("varyRate", this.registry, "test");
        this.stats = new TestStatistics(this.registry);
        MetricsContext context = MetricsUtil.getContext((String)"hbase");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"test");
        this.metricsRecord.setTag("TestStatistics", "test");
    }

    public void tearDown() {
    }

    public void testGetAttribute() throws Exception {
        this.metricsRate.inc(2);
        Thread.sleep(1000L);
        this.metricsRate.pushMetric(this.metricsRecord);
        this.intValue.set(5);
        this.intValue.pushMetric(this.metricsRecord);
        this.varyRate.inc(10L);
        this.varyRate.inc(50L);
        this.varyRate.pushMetric(this.metricsRecord);
        TestMetricsMBeanBase.assertEquals((double)2.0, (double)((Float)this.stats.getAttribute("metricsRate")).floatValue(), (double)0.005);
        TestMetricsMBeanBase.assertEquals((Object)5, (Object)this.stats.getAttribute("intValue"));
        TestMetricsMBeanBase.assertEquals((Object)10L, (Object)this.stats.getAttribute("varyRateMinTime"));
        TestMetricsMBeanBase.assertEquals((Object)50L, (Object)this.stats.getAttribute("varyRateMaxTime"));
        TestMetricsMBeanBase.assertEquals((Object)30L, (Object)this.stats.getAttribute("varyRateAvgTime"));
        TestMetricsMBeanBase.assertEquals((Object)2, (Object)this.stats.getAttribute("varyRateNumOps"));
    }

    public void testGetMBeanInfo() {
        MBeanInfo info = this.stats.getMBeanInfo();
        MBeanAttributeInfo[] attributes = info.getAttributes();
        TestMetricsMBeanBase.assertEquals((int)6, (int)attributes.length);
        HashMap<String, MBeanAttributeInfo> attributeByName = new HashMap<String, MBeanAttributeInfo>(attributes.length);
        for (MBeanAttributeInfo attr : attributes) {
            attributeByName.put(attr.getName(), attr);
        }
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("metricsRate"), "metricsRate", "java.lang.Float", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("intValue"), "intValue", "java.lang.Integer", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("varyRateMinTime"), "varyRateMinTime", "java.lang.Long", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("varyRateMaxTime"), "varyRateMaxTime", "java.lang.Long", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("varyRateAvgTime"), "varyRateAvgTime", "java.lang.Long", "test");
        this.assertAttribute((MBeanAttributeInfo)attributeByName.get("varyRateNumOps"), "varyRateNumOps", "java.lang.Integer", "test");
    }

    public void testMetricsMBeanBaseHistogram() throws ReflectionException, AttributeNotFoundException, MBeanException {
        MetricsRegistry mr = new MetricsRegistry();
        MetricsHistogram histo = (MetricsHistogram)Mockito.mock(MetricsHistogram.class);
        Snapshot snap = (Snapshot)Mockito.mock(Snapshot.class);
        String histoName = "MockHisto";
        Mockito.when((Object)histo.getName()).thenReturn((Object)histoName);
        Mockito.when((Object)histo.getCount()).thenReturn((Object)20L);
        Mockito.when((Object)histo.getMin()).thenReturn((Object)1L);
        Mockito.when((Object)histo.getMax()).thenReturn((Object)999L);
        Mockito.when((Object)histo.getMean()).thenReturn((Object)500.2);
        Mockito.when((Object)histo.getStdDev()).thenReturn((Object)1.2);
        Mockito.when((Object)histo.getSnapshot()).thenReturn((Object)snap);
        Mockito.when((Object)snap.getMedian()).thenReturn((Object)490.0);
        Mockito.when((Object)snap.get75thPercentile()).thenReturn((Object)550.0);
        Mockito.when((Object)snap.get95thPercentile()).thenReturn((Object)900.0);
        Mockito.when((Object)snap.get99thPercentile()).thenReturn((Object)990.0);
        mr.add("myTestHisto", (MetricsBase)histo);
        MetricsMBeanBase mBeanBase = new MetricsMBeanBase(mr, "test");
        TestMetricsMBeanBase.assertEquals((Object)new Long(20L), (Object)mBeanBase.getAttribute(histoName + "_num_ops"));
        TestMetricsMBeanBase.assertEquals((Object)new Long(1L), (Object)mBeanBase.getAttribute(histoName + "_min"));
        TestMetricsMBeanBase.assertEquals((Object)new Long(999L), (Object)mBeanBase.getAttribute(histoName + "_max"));
        TestMetricsMBeanBase.assertEquals((Object)new Float(500.2), (Object)mBeanBase.getAttribute(histoName + "_mean"));
        TestMetricsMBeanBase.assertEquals((Object)new Float(1.2), (Object)mBeanBase.getAttribute(histoName + "_std_dev"));
        TestMetricsMBeanBase.assertEquals((Object)new Float(490.0), (Object)mBeanBase.getAttribute(histoName + "_median"));
        TestMetricsMBeanBase.assertEquals((Object)new Float(550.0), (Object)mBeanBase.getAttribute(histoName + "_75th_percentile"));
        TestMetricsMBeanBase.assertEquals((Object)new Float(900.0), (Object)mBeanBase.getAttribute(histoName + "_95th_percentile"));
        TestMetricsMBeanBase.assertEquals((Object)new Float(990.0), (Object)mBeanBase.getAttribute(histoName + "_99th_percentile"));
    }

    protected void assertAttribute(MBeanAttributeInfo attr, String name, String type, String description) {
        TestMetricsMBeanBase.assertEquals((String)attr.getName(), (String)name);
        TestMetricsMBeanBase.assertEquals((String)attr.getType(), (String)type);
        TestMetricsMBeanBase.assertEquals((String)attr.getDescription(), (String)description);
    }

    private class TestStatistics
    extends MetricsMBeanBase {
        public TestStatistics(MetricsRegistry registry) {
            super(registry, "TestStatistics");
        }
    }
}

