/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.migration.HRegionInfo090x;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMigrationFrom090To092 {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testMigrateHRegionInfoFromVersion0toVersion1() throws IOException {
        HTableDescriptor htd = this.getHTableDescriptor("testMigrateHRegionInfoFromVersion0toVersion1");
        HRegionInfo090x ninety = new HRegionInfo090x(htd, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        byte[] bytes = Writables.getBytes((Writable)ninety);
        HRegionInfo hri = Writables.getHRegionInfo((byte[])bytes);
        Assert.assertEquals((String)hri.getTableNameAsString(), (String)ninety.getTableDesc().getNameAsString());
        Assert.assertEquals((byte)1, (byte)hri.getVersion());
    }

    private HTableDescriptor getHTableDescriptor(String name) {
        HTableDescriptor htd = new HTableDescriptor(name);
        htd.addFamily(new HColumnDescriptor("family"));
        return htd;
    }
}

