/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.EncodedDataBlock;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public class DataBlockEncodingTool {
    private static final Log LOG = LogFactory.getLog(DataBlockEncodingTool.class);
    private static final boolean includesMemstoreTS = true;
    public static int BENCHMARK_N_TIMES = 12;
    public static int BENCHMARK_N_OMIT = 2;
    private static final Compression.Algorithm DEFAULT_COMPRESSION = Compression.Algorithm.GZ;
    private List<EncodedDataBlock> codecs = new ArrayList<EncodedDataBlock>();
    private int totalPrefixLength = 0;
    private int totalKeyLength = 0;
    private int totalValueLength = 0;
    private int totalKeyRedundancyLength = 0;
    private final String compressionAlgorithmName;
    private final Compression.Algorithm compressionAlgorithm;
    private final Compressor compressor;
    private final Decompressor decompressor;

    public DataBlockEncodingTool(String compressionAlgorithmName) {
        this.compressionAlgorithmName = compressionAlgorithmName;
        this.compressionAlgorithm = Compression.getCompressionAlgorithmByName((String)compressionAlgorithmName);
        this.compressor = this.compressionAlgorithm.getCompressor();
        this.decompressor = this.compressionAlgorithm.getDecompressor();
    }

    public void checkStatistics(KeyValueScanner scanner, int kvLimit) throws IOException {
        KeyValue currentKv;
        scanner.seek(KeyValue.LOWESTKEY);
        byte[] previousKey = null;
        List dataBlockEncoders = DataBlockEncoding.getAllEncoders();
        for (DataBlockEncoder d : dataBlockEncoders) {
            this.codecs.add(new EncodedDataBlock(d, true));
        }
        int j = 0;
        while ((currentKv = scanner.next()) != null && j < kvLimit) {
            ++j;
            byte[] currentKey = currentKv.getKey();
            if (previousKey != null) {
                for (int i = 0; i < previousKey.length && i < currentKey.length && previousKey[i] == currentKey[i]; ++i) {
                    ++this.totalKeyRedundancyLength;
                }
            }
            for (EncodedDataBlock codec : this.codecs) {
                codec.addKv(currentKv);
            }
            previousKey = currentKey;
            this.totalPrefixLength += currentKv.getLength() - currentKv.getKeyLength() - currentKv.getValueLength();
            this.totalKeyLength += currentKv.getKeyLength();
            this.totalValueLength += currentKv.getValueLength();
        }
    }

    public boolean verifyCodecs(KeyValueScanner scanner, int kvLimit) throws IOException {
        KeyValue currentKv;
        scanner.seek(KeyValue.LOWESTKEY);
        ArrayList<Iterator> codecIterators = new ArrayList<Iterator>();
        for (EncodedDataBlock codec : this.codecs) {
            codecIterators.add(codec.getIterator());
        }
        int j = 0;
        while ((currentKv = scanner.next()) != null && j < kvLimit) {
            ++j;
            for (Iterator it : codecIterators) {
                KeyValue codecKv = (KeyValue)it.next();
                if (codecKv != null && 0 == Bytes.compareTo((byte[])codecKv.getBuffer(), (int)codecKv.getOffset(), (int)codecKv.getLength(), (byte[])currentKv.getBuffer(), (int)currentKv.getOffset(), (int)currentKv.getLength())) continue;
                if (codecKv == null) {
                    LOG.error((Object)("There is a bug in codec " + it + " it returned null KeyValue,"));
                } else {
                    int prefix;
                    int limitLength = 8 + Math.min(codecKv.getLength(), currentKv.getLength());
                    for (prefix = 0; prefix < limitLength && codecKv.getBuffer()[prefix + codecKv.getOffset()] == currentKv.getBuffer()[prefix + currentKv.getOffset()]; ++prefix) {
                    }
                    LOG.error((Object)("There is bug in codec " + it.toString() + "\n on element " + j + "\n codecKv.getKeyLength() " + codecKv.getKeyLength() + "\n codecKv.getValueLength() " + codecKv.getValueLength() + "\n codecKv.getLength() " + codecKv.getLength() + "\n currentKv.getKeyLength() " + currentKv.getKeyLength() + "\n currentKv.getValueLength() " + currentKv.getValueLength() + "\n codecKv.getLength() " + currentKv.getLength() + "\n currentKV rowLength " + currentKv.getRowLength() + " familyName " + currentKv.getFamilyLength() + " qualifier " + currentKv.getQualifierLength() + "\n prefix " + prefix + "\n codecKv   '" + Bytes.toStringBinary((byte[])codecKv.getBuffer(), (int)codecKv.getOffset(), (int)prefix) + "' diff '" + Bytes.toStringBinary((byte[])codecKv.getBuffer(), (int)(codecKv.getOffset() + prefix), (int)(codecKv.getLength() - prefix)) + "'" + "\n currentKv '" + Bytes.toStringBinary((byte[])currentKv.getBuffer(), (int)currentKv.getOffset(), (int)prefix) + "' diff '" + Bytes.toStringBinary((byte[])currentKv.getBuffer(), (int)(currentKv.getOffset() + prefix), (int)(currentKv.getLength() - prefix)) + "'"));
                }
                return false;
            }
        }
        LOG.info((Object)"Verification was successful!");
        return true;
    }

    public void benchmarkCodecs() {
        int prevTotalSize = -1;
        for (EncodedDataBlock codec : this.codecs) {
            prevTotalSize = this.benchmarkEncoder(prevTotalSize, codec);
        }
        byte[] buffer = this.codecs.get(0).getRawKeyValues();
        this.benchmarkDefaultCompression(prevTotalSize, buffer);
    }

    private int benchmarkEncoder(int previousTotalSize, EncodedDataBlock codec) {
        long finishTime;
        long startTime;
        int prevTotalSize = previousTotalSize;
        int totalSize = 0;
        ArrayList<Long> durations = new ArrayList<Long>();
        for (int itTime = 0; itTime < BENCHMARK_N_TIMES; ++itTime) {
            totalSize = 0;
            Iterator it = codec.getIterator();
            startTime = System.nanoTime();
            while (it.hasNext()) {
                totalSize += ((KeyValue)it.next()).getLength();
            }
            finishTime = System.nanoTime();
            if (itTime >= BENCHMARK_N_OMIT) {
                durations.add(finishTime - startTime);
            }
            if (prevTotalSize != -1 && prevTotalSize != totalSize) {
                throw new IllegalStateException(String.format("Algorithm '%s' decoded data to different size", codec.toString()));
            }
            prevTotalSize = totalSize;
        }
        ArrayList<Long> compressDurations = new ArrayList<Long>();
        for (int itTime = 0; itTime < BENCHMARK_N_TIMES; ++itTime) {
            startTime = System.nanoTime();
            codec.doCompressData();
            finishTime = System.nanoTime();
            if (itTime < BENCHMARK_N_OMIT) continue;
            compressDurations.add(finishTime - startTime);
        }
        System.out.println(codec.toString() + ":");
        DataBlockEncodingTool.printBenchmarkResult(totalSize, compressDurations, false);
        DataBlockEncodingTool.printBenchmarkResult(totalSize, durations, true);
        return prevTotalSize;
    }

    private void benchmarkDefaultCompression(int totalSize, byte[] rawBuffer) {
        DataBlockEncodingTool.benchmarkAlgorithm(this.compressionAlgorithm, this.compressor, this.decompressor, this.compressionAlgorithmName.toUpperCase(), rawBuffer, 0, totalSize);
    }

    public static void benchmarkAlgorithm(Compression.Algorithm algorithm, Compressor compressorCodec, Decompressor decompressorCodec, String name, byte[] buffer, int offset, int length) {
        System.out.println(name + ":");
        ArrayList<Long> compressDurations = new ArrayList<Long>();
        ByteArrayOutputStream compressedStream = new ByteArrayOutputStream();
        try {
            for (int itTime = 0; itTime < BENCHMARK_N_TIMES; ++itTime) {
                long startTime = System.nanoTime();
                OutputStream compressingStream = algorithm.createCompressionStream((OutputStream)compressedStream, compressorCodec, 0);
                compressingStream.write(buffer, offset, length);
                compressingStream.flush();
                compressedStream.toByteArray();
                long finishTime = System.nanoTime();
                if (itTime >= BENCHMARK_N_OMIT) {
                    compressDurations.add(finishTime - startTime);
                }
                if (itTime + 1 >= BENCHMARK_N_TIMES) continue;
                compressedStream.reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Benchmark, or encoding algorithm '%s' cause some stream problems", name), e);
        }
        DataBlockEncodingTool.printBenchmarkResult(length, compressDurations, false);
        byte[] compBuffer = compressedStream.toByteArray();
        ArrayList<Long> durations = new ArrayList<Long>();
        for (int itTime = 0; itTime < BENCHMARK_N_TIMES; ++itTime) {
            long startTime = System.nanoTime();
            byte[] newBuf = new byte[length + 1];
            try {
                KeyValue kv;
                int nextChunk;
                ByteArrayInputStream downStream = new ByteArrayInputStream(compBuffer, 0, compBuffer.length);
                InputStream decompressedStream = algorithm.createDecompressionStream((InputStream)downStream, decompressorCodec, 0);
                int destOffset = 0;
                while ((nextChunk = decompressedStream.available()) > 0) {
                    destOffset += decompressedStream.read(newBuf, destOffset, nextChunk);
                }
                decompressedStream.close();
                for (int pos = 0; pos < length; pos += kv.getLength()) {
                    kv = new KeyValue(newBuf, pos);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Decoding path in '%s' algorithm cause exception ", name), e);
            }
            long finishTime = System.nanoTime();
            if (0 != Bytes.compareTo((byte[])buffer, (int)0, (int)length, (byte[])newBuf, (int)0, (int)length)) {
                for (int prefix = 0; prefix < buffer.length && prefix < newBuf.length && buffer[prefix] == newBuf[prefix]; ++prefix) {
                }
                throw new RuntimeException(String.format("Algorithm '%s' is corrupting the data", name));
            }
            if (itTime < BENCHMARK_N_OMIT) continue;
            durations.add(finishTime - startTime);
        }
        DataBlockEncodingTool.printBenchmarkResult(length, durations, true);
    }

    private static void printBenchmarkResult(int totalSize, List<Long> durationsInNanoSed, boolean isDecompression) {
        long meanTime = 0L;
        for (long time : durationsInNanoSed) {
            meanTime += time;
        }
        meanTime /= (long)durationsInNanoSed.size();
        long standardDev = 0L;
        for (long time : durationsInNanoSed) {
            standardDev += (time - meanTime) * (time - meanTime);
        }
        standardDev = (long)Math.sqrt(standardDev / (long)durationsInNanoSed.size());
        double million = 1.0E9;
        double mbPerSec = (double)totalSize * 1.0E9 / (1048576.0 * (double)meanTime);
        double mbPerSecDev = (double)totalSize * 1.0E9 / (1048576.0 * (double)(meanTime - standardDev));
        System.out.println(String.format("  %s performance:%s %6.2f MB/s (+/- %.2f MB/s)", isDecompression ? "Decompression" : "Compression", isDecompression ? "" : "  ", mbPerSec, mbPerSecDev - mbPerSec));
    }

    public void displayStatistics() {
        int totalLength = this.totalPrefixLength + this.totalKeyLength + this.totalValueLength;
        if (this.compressor != null) {
            this.compressor.reset();
        }
        for (EncodedDataBlock codec : this.codecs) {
            System.out.println(codec.toString());
            int saved = this.totalKeyLength + this.totalPrefixLength + this.totalValueLength - codec.getSize();
            System.out.println(String.format("  Saved bytes:                 %8d", saved));
            double keyRatio = (double)saved * 100.0 / (double)(this.totalPrefixLength + this.totalKeyLength);
            double allRatio = (double)saved * 100.0 / (double)totalLength;
            System.out.println(String.format("  Key compression ratio:        %.2f %%", keyRatio));
            System.out.println(String.format("  All compression ratio:        %.2f %%", allRatio));
            String compressedSizeCaption = String.format("  %s compressed size:         ", this.compressionAlgorithmName.toUpperCase());
            String compressOnlyRatioCaption = String.format("  %s compression ratio:        ", this.compressionAlgorithmName.toUpperCase());
            if (this.compressor != null) {
                int compressedSize = codec.checkCompressedSize(this.compressor);
                System.out.println(compressedSizeCaption + String.format("%8d", compressedSize));
                double compressOnlyRatio = 100.0 * (1.0 - (double)compressedSize / (0.0 + (double)totalLength));
                System.out.println(compressOnlyRatioCaption + String.format("%.2f %%", compressOnlyRatio));
                continue;
            }
            System.out.println(compressedSizeCaption + "N/A");
            System.out.println(compressOnlyRatioCaption + "N/A");
        }
        System.out.println(String.format("Total KV prefix length:   %8d", this.totalPrefixLength));
        System.out.println(String.format("Total key length:         %8d", this.totalKeyLength));
        System.out.println(String.format("Total key redundancy:     %8d", this.totalKeyRedundancyLength));
        System.out.println(String.format("Total value length:       %8d", this.totalValueLength));
    }

    public static void testCodecs(Configuration conf, int kvLimit, String hfilePath, String compressionName, boolean doBenchmark, boolean doVerify) throws IOException {
        Path path = new Path(hfilePath);
        CacheConfig cacheConf = new CacheConfig(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        StoreFile hsf = new StoreFile(fs, path, conf, cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        StoreFile.Reader reader = hsf.createReader();
        reader.loadFileInfo();
        StoreFileScanner scanner = reader.getStoreFileScanner(true, true);
        DataBlockEncodingTool comp = new DataBlockEncodingTool(compressionName);
        comp.checkStatistics((KeyValueScanner)scanner, kvLimit);
        if (doVerify) {
            comp.verifyCodecs((KeyValueScanner)scanner, kvLimit);
        }
        if (doBenchmark) {
            comp.benchmarkCodecs();
        }
        comp.displayStatistics();
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
    }

    private static void printUsage(Options options) {
        System.err.println("Usage:");
        System.err.println(String.format("./hbase %s <options>", DataBlockEncodingTool.class.getName()));
        System.err.println("Options:");
        for (Object it : options.getOptions()) {
            Option opt = (Option)it;
            if (opt.hasArg()) {
                System.err.println(String.format("-%s %s: %s", opt.getOpt(), opt.getArgName(), opt.getDescription()));
                continue;
            }
            System.err.println(String.format("-%s: %s", opt.getOpt(), opt.getDescription()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Options options = new Options();
        options.addOption("f", true, "HFile to analyse (REQUIRED)");
        options.getOption("f").setArgName("FILENAME");
        options.addOption("n", true, "Limit number of KeyValue which will be analysed");
        options.getOption("n").setArgName("NUMBER");
        options.addOption("b", false, "Measure read throughput");
        options.addOption("c", false, "Omit corectness tests.");
        options.addOption("a", true, "What kind of compression algorithm use for comparison.");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Could not parse arguments!");
            System.exit(-1);
            return;
        }
        int kvLimit = Integer.MAX_VALUE;
        if (cmd.hasOption("n")) {
            kvLimit = Integer.parseInt(cmd.getOptionValue("n"));
        }
        if (!cmd.hasOption("f")) {
            System.err.println("ERROR: Filename is required!");
            DataBlockEncodingTool.printUsage(options);
            System.exit(-1);
        }
        String pathName = cmd.getOptionValue("f");
        String compressionName = DEFAULT_COMPRESSION.getName();
        if (cmd.hasOption("a")) {
            compressionName = cmd.getOptionValue("a").toLowerCase();
        }
        boolean doBenchmark = cmd.hasOption("b");
        boolean doVerify = !cmd.hasOption("c");
        Configuration conf = HBaseConfiguration.create();
        try {
            DataBlockEncodingTool.testCodecs(conf, kvLimit, pathName, compressionName, doBenchmark, doVerify);
        }
        finally {
            new CacheConfig(conf).getBlockCache().shutdown();
        }
    }
}

