/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;

public class EncodedSeekPerformanceTest {
    private static final double NANOSEC_IN_SEC = 1.0E9;
    private static final double BYTES_IN_MEGABYTES = 1048576.0;
    public static int DEFAULT_NUMBER_OF_SEEKS = 10000;
    private final HBaseTestingUtility testingUtility = new HBaseTestingUtility();
    private Configuration configuration = this.testingUtility.getConfiguration();
    private CacheConfig cacheConf = new CacheConfig(this.configuration);
    private Random randomizer;
    private int numberOfSeeks;

    public EncodedSeekPerformanceTest() {
        this.configuration.setFloat("hfile.block.cache.size", 0.5f);
        this.randomizer = new Random(42L);
        this.numberOfSeeks = DEFAULT_NUMBER_OF_SEEKS;
    }

    private List<KeyValue> prepareListOfTestSeeks(Path path) throws IOException {
        KeyValue current;
        ArrayList<KeyValue> allKeyValues = new ArrayList<KeyValue>();
        StoreFile storeFile = new StoreFile(this.testingUtility.getTestFileSystem(), path, this.configuration, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        StoreFile.Reader reader = storeFile.createReader();
        StoreFileScanner scanner = reader.getStoreFileScanner(true, false);
        scanner.seek(KeyValue.LOWESTKEY);
        while (null != (current = scanner.next())) {
            allKeyValues.add(current);
        }
        storeFile.closeReader(this.cacheConf.shouldEvictOnClose());
        ArrayList<KeyValue> seeks = new ArrayList<KeyValue>();
        for (int i = 0; i < this.numberOfSeeks; ++i) {
            KeyValue keyValue = (KeyValue)allKeyValues.get(this.randomizer.nextInt(allKeyValues.size()));
            seeks.add(keyValue);
        }
        this.clearBlockCache();
        return seeks;
    }

    private void runTest(Path path, HFileDataBlockEncoder blockEncoder, List<KeyValue> seeks) throws IOException {
        long finishSeeksTime;
        KeyValue current;
        StoreFile storeFile = new StoreFile(this.testingUtility.getTestFileSystem(), path, this.configuration, this.cacheConf, StoreFile.BloomType.NONE, blockEncoder);
        long totalSize = 0L;
        StoreFile.Reader reader = storeFile.createReader();
        StoreFileScanner scanner = reader.getStoreFileScanner(true, false);
        long startReadingTime = System.nanoTime();
        scanner.seek(KeyValue.LOWESTKEY);
        while (null != (current = scanner.next())) {
            if (current.getLength() < 0) {
                throw new IOException("Negative KV size: " + current);
            }
            totalSize += (long)current.getLength();
        }
        long finishReadingTime = System.nanoTime();
        long startSeeksTime = System.nanoTime();
        for (KeyValue keyValue : seeks) {
            scanner.seek(keyValue);
            KeyValue toVerify = scanner.next();
            if (keyValue.equals((Object)toVerify)) continue;
            System.out.println(String.format("KeyValue doesn't match:\nOrig key: %s\nRet key:  %s", keyValue.getKeyString(), toVerify.getKeyString()));
            break;
        }
        if ((finishSeeksTime = System.nanoTime()) < startSeeksTime) {
            throw new AssertionError((Object)("Finish time " + finishSeeksTime + " is earlier than start time " + startSeeksTime));
        }
        double readInMbPerSec = (double)totalSize * 1.0E9 / (1048576.0 * (double)(finishReadingTime - startReadingTime));
        double seeksPerSec = (double)seeks.size() * 1.0E9 / (double)(finishSeeksTime - startSeeksTime);
        storeFile.closeReader(this.cacheConf.shouldEvictOnClose());
        this.clearBlockCache();
        System.out.println(blockEncoder);
        System.out.printf("  Read speed:       %8.2f (MB/s)\n", readInMbPerSec);
        System.out.printf("  Seeks per second: %8.2f (#/s)\n", seeksPerSec);
        System.out.printf("  Total KV size:    %d\n", totalSize);
    }

    public void runTests(Path path, List<HFileDataBlockEncoder> encoders) throws IOException {
        List<KeyValue> seeks = this.prepareListOfTestSeeks(path);
        for (HFileDataBlockEncoder blockEncoder : encoders) {
            this.runTest(path, blockEncoder, seeks);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            EncodedSeekPerformanceTest.printUsage();
            System.exit(-1);
        }
        Path path = new Path(args[0]);
        ArrayList<HFileDataBlockEncoder> encoders = new ArrayList<HFileDataBlockEncoder>();
        encoders.add((HFileDataBlockEncoder)new HFileDataBlockEncoderImpl(DataBlockEncoding.NONE));
        for (DataBlockEncoding encodingAlgo : DataBlockEncoding.values()) {
            encoders.add((HFileDataBlockEncoder)new HFileDataBlockEncoderImpl(DataBlockEncoding.NONE, encodingAlgo));
        }
        EncodedSeekPerformanceTest utility = new EncodedSeekPerformanceTest();
        utility.runTests(path, encoders);
        System.exit(0);
    }

    private static void printUsage() {
        System.out.println("Usage: one argument, name of the HFile");
    }

    private void clearBlockCache() {
        ((LruBlockCache)this.cacheConf.getBlockCache()).clearCache();
    }
}

