/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestAtomicOperation
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestAtomicOperation.class);
    HRegion region = null;
    private HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String DIR = this.TEST_UTIL.getDataTestDir("TestAtomicOperation").toString();
    static final byte[] tableName = Bytes.toBytes((String)"testtable");
    static final byte[] qual1 = Bytes.toBytes((String)"qual1");
    static final byte[] qual2 = Bytes.toBytes((String)"qual2");
    static final byte[] qual3 = Bytes.toBytes((String)"qual3");
    static final byte[] value1 = Bytes.toBytes((String)"value1");
    static final byte[] value2 = Bytes.toBytes((String)"value2");
    static final byte[] row = Bytes.toBytes((String)"rowA");
    static final byte[] row2 = Bytes.toBytes((String)"rowB");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        EnvironmentEdgeManagerTestHelper.reset();
    }

    public void testAppend() throws IOException {
        this.initHRegion(tableName, this.getName(), new byte[][]{fam1});
        String v1 = "Ultimate Answer to the Ultimate Question of Life, The Universe, and Everything";
        String v2 = " is... 42.";
        Append a = new Append(row);
        a.setReturnResults(false);
        a.add(fam1, qual1, Bytes.toBytes((String)v1));
        a.add(fam1, qual2, Bytes.toBytes((String)v2));
        TestAtomicOperation.assertNull((Object)this.region.append(a, null, true));
        a = new Append(row);
        a.add(fam1, qual1, Bytes.toBytes((String)v2));
        a.add(fam1, qual2, Bytes.toBytes((String)v1));
        Result result = this.region.append(a, null, true);
        TestAtomicOperation.assertEquals((int)0, (int)Bytes.compareTo((byte[])Bytes.toBytes((String)(v1 + v2)), (byte[])result.getValue(fam1, qual1)));
        TestAtomicOperation.assertEquals((int)0, (int)Bytes.compareTo((byte[])Bytes.toBytes((String)(v2 + v1)), (byte[])result.getValue(fam1, qual2)));
    }

    public void testIncrementColumnValue() throws IOException {
        LOG.info((Object)"Starting test testIncrementColumnValue");
        this.initHRegion(tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(row);
        put.add(fam1, qual1, Bytes.toBytes((long)value));
        this.region.put(put);
        long result = this.region.incrementColumnValue(row, fam1, qual1, amount, true);
        TestAtomicOperation.assertEquals((long)(value + amount), (long)result);
        Store store = this.region.getStore(fam1);
        TestAtomicOperation.assertEquals((int)1, (int)store.memstore.kvset.size());
        TestAtomicOperation.assertTrue((boolean)store.memstore.snapshot.isEmpty());
        this.assertICV(row, fam1, qual1, value + amount);
    }

    public void testIncrementMultiThreads() throws IOException {
        int i;
        LOG.info((Object)"Starting test testIncrementMultiThreads");
        this.initHRegion(tableName, this.getName(), new byte[][]{fam1});
        int numThreads = 100;
        int incrementsPerThread = 1000;
        Incrementer[] all = new Incrementer[numThreads];
        int expectedTotal = 0;
        for (i = 0; i < numThreads; ++i) {
            all[i] = new Incrementer(this.region, i, i, incrementsPerThread);
            expectedTotal += i * incrementsPerThread;
        }
        for (i = 0; i < numThreads; ++i) {
            all[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                all[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.assertICV(row, fam1, qual1, expectedTotal);
        LOG.info((Object)("testIncrementMultiThreads successfully verified that total is " + expectedTotal));
    }

    private void assertICV(byte[] row, byte[] familiy, byte[] qualifier, long amount) throws IOException {
        Get get = new Get(row);
        get.addColumn(familiy, qualifier);
        Result result = this.region.get(get, null);
        TestAtomicOperation.assertEquals((int)1, (int)result.size());
        KeyValue kv = result.raw()[0];
        long r = Bytes.toLong((byte[])kv.getValue());
        TestAtomicOperation.assertEquals((long)amount, (long)r);
    }

    private void initHRegion(byte[] tableName, String callingMethod, byte[] ... families) throws IOException {
        this.initHRegion(tableName, callingMethod, HBaseConfiguration.create(), families);
    }

    private void initHRegion(byte[] tableName, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo info = new HRegionInfo(htd.getName(), null, null, false);
        Path path = new Path(this.DIR + callingMethod);
        if (this.fs.exists(path) && !this.fs.delete(path, true)) {
            throw new IOException("Failed delete of " + path);
        }
        this.region = HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)conf, (HTableDescriptor)htd);
    }

    public void testRowMutationMultiThreads() throws IOException {
        int i;
        LOG.info((Object)"Starting test testRowMutationMultiThreads");
        this.initHRegion(tableName, this.getName(), new byte[][]{fam1});
        int numThreads = 10;
        int opsPerThread = 500;
        AtomicOperation[] all = new AtomicOperation[numThreads];
        AtomicLong timeStamps = new AtomicLong(0L);
        AtomicInteger failures = new AtomicInteger(0);
        for (i = 0; i < numThreads; ++i) {
            all[i] = new AtomicOperation(this.region, opsPerThread, timeStamps, failures){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean op = true;
                    for (int i = 0; i < this.numOps; ++i) {
                        try {
                            if (i % 10 == 0) {
                                HRegion hRegion = this.region;
                                synchronized (hRegion) {
                                    LOG.debug((Object)"flushing");
                                    this.region.flushcache();
                                    if (i % 100 == 0) {
                                        this.region.compactStores();
                                    }
                                }
                            }
                            long ts = this.timeStamps.incrementAndGet();
                            RowMutations rm = new RowMutations(row);
                            if (op) {
                                Put p = new Put(row, ts);
                                p.add(fam1, qual1, value1);
                                rm.add(p);
                                Delete d = new Delete(row);
                                d.deleteColumns(fam1, qual2, ts);
                                rm.add(d);
                            } else {
                                Delete d = new Delete(row);
                                d.deleteColumns(fam1, qual1, ts);
                                rm.add(d);
                                Put p = new Put(row, ts);
                                p.add(fam1, qual2, value2);
                                rm.add(p);
                            }
                            this.region.mutateRow(rm);
                            op ^= true;
                            Get g = new Get(row);
                            Result r = this.region.get(g, null);
                            if (r.size() == 1) continue;
                            LOG.debug((Object)r);
                            this.failures.incrementAndGet();
                            Assert.fail();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            this.failures.incrementAndGet();
                            Assert.fail();
                        }
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            all[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                all[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        TestAtomicOperation.assertEquals((int)0, (int)failures.get());
    }

    public void testMultiRowMutationMultiThreads() throws IOException {
        int i;
        LOG.info((Object)"Starting test testMultiRowMutationMultiThreads");
        this.initHRegion(tableName, this.getName(), new byte[][]{fam1});
        int numThreads = 10;
        int opsPerThread = 500;
        AtomicOperation[] all = new AtomicOperation[numThreads];
        AtomicLong timeStamps = new AtomicLong(0L);
        AtomicInteger failures = new AtomicInteger(0);
        final List rowsToLock = Arrays.asList(row, row2);
        for (i = 0; i < numThreads; ++i) {
            all[i] = new AtomicOperation(this.region, opsPerThread, timeStamps, failures){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean op = true;
                    for (int i = 0; i < this.numOps; ++i) {
                        try {
                            if (i % 10 == 0) {
                                HRegion hRegion = this.region;
                                synchronized (hRegion) {
                                    LOG.debug((Object)"flushing");
                                    this.region.flushcache();
                                    if (i % 100 == 0) {
                                        this.region.compactStores();
                                    }
                                }
                            }
                            long ts = this.timeStamps.incrementAndGet();
                            ArrayList<Object> mrm = new ArrayList<Object>();
                            if (op) {
                                Put p = new Put(row2, ts);
                                p.add(fam1, qual1, value1);
                                mrm.add(p);
                                Delete d = new Delete(row);
                                d.deleteColumns(fam1, qual1, ts);
                                mrm.add(d);
                            } else {
                                Delete d = new Delete(row2);
                                d.deleteColumns(fam1, qual1, ts);
                                mrm.add(d);
                                Put p = new Put(row, ts);
                                p.add(fam1, qual1, value2);
                                mrm.add(p);
                            }
                            this.region.mutateRowsWithLocks(mrm, (Collection)rowsToLock);
                            op ^= true;
                            Scan s = new Scan(row);
                            RegionScanner rs = this.region.getScanner(s);
                            ArrayList r = new ArrayList();
                            while (rs.next(r)) {
                            }
                            rs.close();
                            if (r.size() == 1) continue;
                            LOG.debug(r);
                            this.failures.incrementAndGet();
                            Assert.fail();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            this.failures.incrementAndGet();
                            Assert.fail();
                        }
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            all[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                all[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        TestAtomicOperation.assertEquals((int)0, (int)failures.get());
    }

    public static class AtomicOperation
    extends Thread {
        protected final HRegion region;
        protected final int numOps;
        protected final AtomicLong timeStamps;
        protected final AtomicInteger failures;
        protected final Random r = new Random();

        public AtomicOperation(HRegion region, int numOps, AtomicLong timeStamps, AtomicInteger failures) {
            this.region = region;
            this.numOps = numOps;
            this.timeStamps = timeStamps;
            this.failures = failures;
        }
    }

    public static class Incrementer
    extends Thread {
        private final HRegion region;
        private final int threadNumber;
        private final int numIncrements;
        private final int amount;
        private int count;

        public Incrementer(HRegion region, int threadNumber, int amount, int numIncrements) {
            this.region = region;
            this.threadNumber = threadNumber;
            this.numIncrements = numIncrements;
            this.count = 0;
            this.amount = amount;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            for (int i = 0; i < this.numIncrements; ++i) {
                try {
                    long result = this.region.incrementColumnValue(row, fam1, qual1, (long)this.amount, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++this.count;
            }
        }
    }
}

