/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBlocksScanned
extends HBaseTestCase {
    private static byte[] TABLE = Bytes.toBytes((String)"TestBlocksScanned");
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static byte[] COL = Bytes.toBytes((String)"col");
    private static byte[] START_KEY = Bytes.toBytes((String)"aaa");
    private static byte[] END_KEY = Bytes.toBytes((String)"zzz");
    private static int BLOCK_SIZE = 70;
    private static HBaseTestingUtility TEST_UTIL = null;
    private static HTableDescriptor TESTTABLEDESC = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        SchemaMetrics.setUseTableNameInTest((boolean)true);
        TEST_UTIL = new HBaseTestingUtility();
        TESTTABLEDESC = new HTableDescriptor(TABLE);
        TESTTABLEDESC.addFamily(new HColumnDescriptor(FAMILY).setMaxVersions(10).setBlockCacheEnabled(true).setBlocksize(BLOCK_SIZE).setCompressionType(Compression.Algorithm.NONE));
    }

    @Test
    public void testBlocksScanned() throws Exception {
        long expectDataBlockRead;
        HRegion r = this.createNewHRegion(TESTTABLEDESC, START_KEY, END_KEY, TEST_UTIL.getConfiguration());
        TestBlocksScanned.addContent(r, FAMILY, COL);
        r.flushcache();
        SchemaMetrics schemaMetrics = SchemaMetrics.getInstance((String)Bytes.toString((byte[])TABLE), (String)Bytes.toString((byte[])FAMILY));
        Map schemaMetricSnapshot = SchemaMetrics.getMetricsSnapshot();
        Scan scan = new Scan(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"aaz"));
        scan.addColumn(FAMILY, COL);
        scan.setMaxVersions(1);
        RegionScanner s = r.getScanner(scan);
        ArrayList results = new ArrayList();
        while (s.next(results)) {
        }
        s.close();
        int expectResultSize = 25;
        Assert.assertEquals((long)expectResultSize, (long)results.size());
        int kvPerBlock = (int)Math.ceil((double)BLOCK_SIZE / (double)((KeyValue)results.get(0)).getLength());
        Assert.assertEquals((long)2L, (long)kvPerBlock);
        long expectIndexBlockRead = expectDataBlockRead = (long)Math.ceil((double)expectResultSize / (double)kvPerBlock);
        this.verifyDataAndIndexBlockRead(schemaMetricSnapshot, schemaMetrics, expectDataBlockRead, expectIndexBlockRead);
    }

    private void verifyDataAndIndexBlockRead(Map<String, Long> previousMetricSnapshot, SchemaMetrics schemaMetrics, long expectDataBlockRead, long expectedIndexBlockRead) {
        Map currentMetricsSnapshot = SchemaMetrics.getMetricsSnapshot();
        Map diffs = SchemaMetrics.diffMetrics(previousMetricSnapshot, (Map)currentMetricsSnapshot);
        long dataBlockRead = SchemaMetrics.getLong((Map)diffs, (String)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.DATA, false, SchemaMetrics.BlockMetricType.READ_COUNT));
        long indexBlockRead = SchemaMetrics.getLong((Map)diffs, (String)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.INDEX, false, SchemaMetrics.BlockMetricType.READ_COUNT));
        Assert.assertEquals((long)expectDataBlockRead, (long)dataBlockRead);
        Assert.assertEquals((long)expectedIndexBlockRead, (long)indexBlockRead);
    }
}

