/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestExplicitColumnTracker
extends HBaseTestCase {
    private boolean PRINT = false;
    private final byte[] col1 = Bytes.toBytes((String)"col1");
    private final byte[] col2 = Bytes.toBytes((String)"col2");
    private final byte[] col3 = Bytes.toBytes((String)"col3");
    private final byte[] col4 = Bytes.toBytes((String)"col4");
    private final byte[] col5 = Bytes.toBytes((String)"col5");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    private void runTest(int maxVersions, TreeSet<byte[]> trackColumns, List<byte[]> scannerColumns, List<ScanQueryMatcher.MatchCode> expected) throws IOException {
        ExplicitColumnTracker exp = new ExplicitColumnTracker(trackColumns, 0, maxVersions, Long.MIN_VALUE);
        ArrayList<ScanQueryMatcher.MatchCode> result = new ArrayList<ScanQueryMatcher.MatchCode>();
        long timestamp = 0L;
        for (byte[] col : scannerColumns) {
            result.add(exp.checkColumn(col, 0, col.length, ++timestamp, KeyValue.Type.Put.getCode(), false));
        }
        TestExplicitColumnTracker.assertEquals((int)expected.size(), (int)result.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestExplicitColumnTracker.assertEquals((Object)expected.get(i), result.get(i));
            if (!this.PRINT) continue;
            System.out.println("Expected " + expected.get(i) + ", actual " + result.get(i));
        }
    }

    public void testGet_SingleVersion() throws IOException {
        if (this.PRINT) {
            System.out.println("SingleVersion");
        }
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(this.col2);
        columns.add(this.col4);
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        int maxVersions = 1;
        ArrayList<byte[]> scanner = new ArrayList<byte[]>();
        scanner.add(this.col1);
        scanner.add(this.col2);
        scanner.add(this.col3);
        scanner.add(this.col4);
        scanner.add(this.col5);
        this.runTest(maxVersions, columns, scanner, expected);
    }

    public void testGet_MultiVersion() throws IOException {
        if (this.PRINT) {
            System.out.println("\nMultiVersion");
        }
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(this.col2);
        columns.add(this.col4);
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        int maxVersions = 2;
        ArrayList<byte[]> scanner = new ArrayList<byte[]>();
        scanner.add(this.col1);
        scanner.add(this.col1);
        scanner.add(this.col1);
        scanner.add(this.col2);
        scanner.add(this.col2);
        scanner.add(this.col2);
        scanner.add(this.col3);
        scanner.add(this.col3);
        scanner.add(this.col3);
        scanner.add(this.col4);
        scanner.add(this.col4);
        scanner.add(this.col4);
        scanner.add(this.col5);
        scanner.add(this.col5);
        scanner.add(this.col5);
        this.runTest(maxVersions, columns, scanner, expected);
    }

    public void testStackOverflow() throws IOException {
        byte[] col;
        int i;
        int maxVersions = 1;
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (int i2 = 0; i2 < 100000; ++i2) {
            columns.add(Bytes.toBytes((String)("col" + i2)));
        }
        ExplicitColumnTracker explicit = new ExplicitColumnTracker(columns, 0, maxVersions, Long.MIN_VALUE);
        for (i = 0; i < 100000; i += 2) {
            col = Bytes.toBytes((String)("col" + i));
            explicit.checkColumn(col, 0, col.length, 1L, KeyValue.Type.Put.getCode(), false);
        }
        explicit.update();
        for (i = 1; i < 100000; i += 2) {
            col = Bytes.toBytes((String)("col" + i));
            explicit.checkColumn(col, 0, col.length, 1L, KeyValue.Type.Put.getCode(), false);
        }
    }

    public void testInfiniteLoop() throws IOException {
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.addAll(Arrays.asList(this.col2, this.col3, this.col5));
        List<byte[]> scanner = Arrays.asList(this.col1, this.col4);
        List<ScanQueryMatcher.MatchCode> expected = Arrays.asList(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        this.runTest(1, columns, scanner, expected);
    }
}

