/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.util.Progressable;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestStore
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestStore.class);
    Store store;
    byte[] table = Bytes.toBytes((String)"table");
    byte[] family = Bytes.toBytes((String)"family");
    byte[] row = Bytes.toBytes((String)"row");
    byte[] row2 = Bytes.toBytes((String)"row2");
    byte[] qf1 = Bytes.toBytes((String)"qf1");
    byte[] qf2 = Bytes.toBytes((String)"qf2");
    byte[] qf3 = Bytes.toBytes((String)"qf3");
    byte[] qf4 = Bytes.toBytes((String)"qf4");
    byte[] qf5 = Bytes.toBytes((String)"qf5");
    byte[] qf6 = Bytes.toBytes((String)"qf6");
    NavigableSet<byte[]> qualifiers = new ConcurrentSkipListSet<byte[]>(Bytes.BYTES_COMPARATOR);
    List<KeyValue> expected = new ArrayList<KeyValue>();
    List<KeyValue> result = new ArrayList<KeyValue>();
    long id = System.currentTimeMillis();
    Get get = new Get(this.row);
    private HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String DIR = this.TEST_UTIL.getDataTestDir("TestStore").toString();
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void setUp() throws IOException {
        this.qualifiers.add(this.qf1);
        this.qualifiers.add(this.qf3);
        this.qualifiers.add(this.qf5);
        for (byte[] next : this.qualifiers) {
            this.expected.add(new KeyValue(this.row, this.family, next, 1L, (byte[])null));
            this.get.addColumn(this.family, next);
        }
    }

    private void init(String methodName) throws IOException {
        this.init(methodName, HBaseConfiguration.create());
    }

    private void init(String methodName, Configuration conf) throws IOException {
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setMaxVersions(4);
        this.init(methodName, conf, hcd);
    }

    private void init(String methodName, Configuration conf, HColumnDescriptor hcd) throws IOException {
        Path basedir = new Path(this.DIR + methodName);
        Path logdir = new Path(this.DIR + methodName + "/logs");
        Path oldLogDir = new Path(basedir, ".oldlogs");
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(logdir, true);
        HTableDescriptor htd = new HTableDescriptor(this.table);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getName(), null, null, false);
        HLog hlog = new HLog(fs, logdir, oldLogDir, conf);
        HRegion region = new HRegion(basedir, hlog, fs, conf, info, htd, null);
        this.store = new Store(basedir, region, hcd, fs, conf);
    }

    public void testDeleteExpiredStoreFiles() throws Exception {
        int i;
        int storeFileNum = 4;
        int ttl = 4;
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.store.delete.expired.storefile", true);
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setTimeToLive(ttl);
        this.init(this.getName(), conf, hcd);
        long sleepTime = this.store.scanInfo.getTtl() / (long)storeFileNum;
        for (i = 1; i <= storeFileNum; ++i) {
            LOG.info((Object)("Adding some data for the store file #" + i));
            long timeStamp = EnvironmentEdgeManager.currentTimeMillis();
            this.store.add(new KeyValue(this.row, this.family, this.qf1, timeStamp, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf2, timeStamp, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf3, timeStamp, (byte[])null));
            this.flush(i);
            Thread.sleep(sleepTime);
        }
        TestStore.assertEquals((int)storeFileNum, (int)this.store.getStorefiles().size());
        for (i = 1; i <= storeFileNum; ++i) {
            CompactionRequest cr = this.store.requestCompaction();
            TestStore.assertEquals((int)1, (int)cr.getFiles().size());
            TestStore.assertTrue((((StoreFile)cr.getFiles().get(0)).getReader().getMaxTimestamp() < System.currentTimeMillis() - this.store.scanInfo.getTtl() ? 1 : 0) != 0);
            this.store.compact(cr);
            TestStore.assertEquals((int)(storeFileNum - i), (int)this.store.getStorefiles().size());
            Thread.sleep(sleepTime);
        }
    }

    public void testLowestModificationTime() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.init(this.getName(), conf);
        int storeFileNum = 4;
        for (int i = 1; i <= storeFileNum; ++i) {
            LOG.info((Object)("Adding some data for the store file #" + i));
            this.store.add(new KeyValue(this.row, this.family, this.qf1, (long)i, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf2, (long)i, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf3, (long)i, (byte[])null));
            this.flush(i);
        }
        long lowestTimeStampFromStore = Store.getLowestTimestamp((List)this.store.getStorefiles());
        long lowestTimeStampFromFS = TestStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        TestStore.assertEquals((long)lowestTimeStampFromStore, (long)lowestTimeStampFromFS);
        this.store.compact(this.store.requestCompaction());
        lowestTimeStampFromStore = Store.getLowestTimestamp((List)this.store.getStorefiles());
        lowestTimeStampFromFS = TestStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        TestStore.assertEquals((long)lowestTimeStampFromStore, (long)lowestTimeStampFromFS);
    }

    private static long getLowestTimeStampFromFS(FileSystem fs, List<StoreFile> candidates) throws IOException {
        long minTs = Long.MAX_VALUE;
        if (candidates.isEmpty()) {
            return minTs;
        }
        Path[] p = new Path[candidates.size()];
        for (int i = 0; i < candidates.size(); ++i) {
            p[i] = candidates.get(i).getPath();
        }
        FileStatus[] stats = fs.listStatus(p);
        if (stats == null || stats.length == 0) {
            return minTs;
        }
        for (FileStatus s : stats) {
            minTs = Math.min(minTs, s.getModificationTime());
        }
        return minTs;
    }

    public void testEmptyStoreFile() throws IOException {
        this.init(this.getName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.flush(1);
        StoreFile f = (StoreFile)this.store.getStorefiles().get(0);
        Path storedir = f.getPath().getParent();
        long seqid = f.getMaxSequenceId();
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        StoreFile.Writer w = new StoreFile.WriterBuilder(c, new CacheConfig(c), fs, 8192).withOutputDir(storedir).build();
        w.appendMetadata(seqid + 1L, false);
        w.close();
        this.store.close();
        this.store = new Store(storedir.getParent().getParent(), this.store.getHRegion(), this.store.getFamily(), fs, c);
        System.out.println(this.store.getHRegionInfo().getEncodedName());
        TestStore.assertEquals((int)2, (int)this.store.getStorefilesCount());
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        TestStore.assertEquals((int)1, (int)this.result.size());
    }

    public void testGet_FromMemStoreOnly() throws IOException {
        this.init(this.getName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null));
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        this.assertCheck();
    }

    public void testGet_FromFilesOnly() throws IOException {
        this.init(this.getName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.flush(1);
        this.store.add(new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null));
        this.flush(2);
        this.store.add(new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null));
        this.flush(3);
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, KeyValue.COMPARATOR);
        this.assertCheck();
    }

    public void testGet_FromMemStoreAndFiles() throws IOException {
        this.init(this.getName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.flush(1);
        this.store.add(new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null));
        this.flush(2);
        this.store.add(new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null));
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, KeyValue.COMPARATOR);
        this.assertCheck();
    }

    private void flush(int storeFilessize) throws IOException {
        this.store.snapshot();
        TestStore.flushStore(this.store, this.id++);
        TestStore.assertEquals((int)storeFilessize, (int)this.store.getStorefiles().size());
        TestStore.assertEquals((int)0, (int)this.store.memstore.kvset.size());
    }

    private void assertCheck() {
        TestStore.assertEquals((int)this.expected.size(), (int)this.result.size());
        for (int i = 0; i < this.expected.size(); ++i) {
            TestStore.assertEquals((Object)this.expected.get(i), (Object)this.result.get(i));
        }
    }

    public void testIncrementColumnValue_ICVDuringFlush() throws IOException, InterruptedException {
        this.init(this.getName());
        long oldValue = 1L;
        long newValue = 3L;
        this.store.add(new KeyValue(this.row, this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)oldValue)));
        this.store.snapshot();
        this.store.add(new KeyValue(this.row, this.family, this.qf2, System.currentTimeMillis(), Bytes.toBytes((long)oldValue)));
        long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, newValue);
        TestStore.assertTrue((ret > 0L ? 1 : 0) != 0);
        TestStore.flushStore(this.store, this.id++);
        TestStore.assertEquals((int)1, (int)this.store.getStorefiles().size());
        TestStore.assertEquals((int)2, (int)this.store.memstore.kvset.size());
        Get get = new Get(this.row);
        get.addColumn(this.family, this.qf1);
        get.setMaxVersions();
        List<Object> results = new ArrayList();
        results = HBaseTestingUtility.getFromStoreFile(this.store, get);
        TestStore.assertEquals((int)2, (int)results.size());
        long ts1 = ((KeyValue)results.get(0)).getTimestamp();
        long ts2 = ((KeyValue)results.get(1)).getTimestamp();
        TestStore.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        TestStore.assertEquals((long)newValue, (long)Bytes.toLong((byte[])((KeyValue)results.get(0)).getValue()));
        TestStore.assertEquals((long)oldValue, (long)Bytes.toLong((byte[])((KeyValue)results.get(1)).getValue()));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        EnvironmentEdgeManagerTestHelper.reset();
    }

    public void testICV_negMemstoreSize() throws IOException {
        this.init(this.getName());
        long time = 100L;
        ManualEnvironmentEdge ee = new ManualEnvironmentEdge();
        ee.setValue(time);
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)ee);
        long newValue = 3L;
        long size = 0L;
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091000"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091200"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091300"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091400"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091500"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        for (int i = 0; i < 10000; ++i) {
            long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
            long ret2 = this.store.updateColumnValue(this.row2, this.family, this.qf1, newValue);
            if (ret != 0L) {
                System.out.println("ret: " + ret);
            }
            if (ret2 != 0L) {
                System.out.println("ret2: " + ret2);
            }
            TestStore.assertTrue((String)("ret: " + ret), (ret >= 0L ? 1 : 0) != 0);
            size += ret;
            TestStore.assertTrue((String)("ret2: " + ret2), (ret2 >= 0L ? 1 : 0) != 0);
            size += ret2;
            if (i % 1000 != 0) continue;
            ee.setValue(++time);
        }
        long computedSize = 0L;
        for (KeyValue kv : this.store.memstore.kvset) {
            long kvsize = this.store.memstore.heapSizeChange(kv, true);
            computedSize += kvsize;
        }
        TestStore.assertEquals((long)computedSize, (long)size);
    }

    public void testIncrementColumnValue_SnapshotFlushCombo() throws Exception {
        ManualEnvironmentEdge mee = new ManualEnvironmentEdge();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)mee);
        this.init(this.getName());
        long oldValue = 1L;
        long newValue = 3L;
        this.store.add(new KeyValue(this.row, this.family, this.qf1, EnvironmentEdgeManager.currentTimeMillis(), Bytes.toBytes((long)oldValue)));
        this.store.snapshot();
        long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, newValue);
        TestStore.assertTrue((ret > 0L ? 1 : 0) != 0);
        TestStore.flushStore(this.store, this.id++);
        TestStore.assertEquals((int)1, (int)this.store.getStorefiles().size());
        TestStore.assertEquals((int)1, (int)this.store.memstore.kvset.size());
        this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
        this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
        Get get = new Get(this.row);
        get.addColumn(this.family, this.qf1);
        get.setMaxVersions();
        List<Object> results = new ArrayList();
        results = HBaseTestingUtility.getFromStoreFile(this.store, get);
        TestStore.assertEquals((int)2, (int)results.size());
        long ts1 = ((KeyValue)results.get(0)).getTimestamp();
        long ts2 = ((KeyValue)results.get(1)).getTimestamp();
        TestStore.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        TestStore.assertEquals((long)newValue, (long)Bytes.toLong((byte[])((KeyValue)results.get(0)).getValue()));
        TestStore.assertEquals((long)oldValue, (long)Bytes.toLong((byte[])((KeyValue)results.get(1)).getValue()));
        mee.setValue(2L);
        this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
        results = HBaseTestingUtility.getFromStoreFile(this.store, get);
        TestStore.assertEquals((int)2, (int)results.size());
        ts1 = ((KeyValue)results.get(0)).getTimestamp();
        ts2 = ((KeyValue)results.get(1)).getTimestamp();
        TestStore.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        TestStore.assertEquals((long)newValue, (long)Bytes.toLong((byte[])((KeyValue)results.get(0)).getValue()));
        TestStore.assertEquals((long)oldValue, (long)Bytes.toLong((byte[])((KeyValue)results.get(1)).getValue()));
    }

    public void testHandleErrorsInFlush() throws Exception {
        LOG.info((Object)"Setting up a faulty file system that cannot write");
        final Configuration conf = HBaseConfiguration.create();
        User user = User.createUserForTesting((Configuration)conf, (String)"testhandleerrorsinflush", (String[])new String[]{"foo"});
        conf.setClass("fs.file.impl", FaultyFileSystem.class, FileSystem.class);
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(FaultyFileSystem.class, fs.getClass());
                TestStore.this.init(TestStore.this.getName(), conf);
                LOG.info((Object)"Adding some data");
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf1, 1L, (byte[])null));
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf2, 1L, (byte[])null));
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf3, 1L, (byte[])null));
                LOG.info((Object)"Before flush, we should have no files");
                FileStatus[] files = fs.listStatus(TestStore.this.store.getHomedir());
                Object[] paths = FileUtil.stat2Paths((FileStatus[])files);
                System.err.println("Got paths: " + Joiner.on((String)",").join(paths));
                Assert.assertEquals((int)0, (int)paths.length);
                try {
                    LOG.info((Object)"Flushing");
                    TestStore.this.flush(1);
                    Assert.fail((String)"Didn't bubble up IOE!");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("Fault injected"));
                }
                LOG.info((Object)"After failed flush, we should still have no files!");
                files = fs.listStatus(TestStore.this.store.getHomedir());
                paths = FileUtil.stat2Paths((FileStatus[])files);
                System.err.println("Got paths: " + Joiner.on((String)",").join(paths));
                Assert.assertEquals((int)0, (int)paths.length);
                return null;
            }
        });
    }

    private static void flushStore(Store store, long id) throws IOException {
        StoreFlusher storeFlusher = store.getStoreFlusher(id);
        storeFlusher.prepare();
        storeFlusher.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
        storeFlusher.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
    }

    List<KeyValue> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes((int)i);
            for (long timestamp : timestamps) {
                kvList.add(new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    public void testMultipleTimestamps() throws IOException {
        int numRows = 1;
        long[] timestamps1 = new long[]{1L, 5L, 10L, 20L};
        long[] timestamps2 = new long[]{30L, 80L};
        this.init(this.getName());
        List<KeyValue> kvList1 = this.getKeyValueSet(timestamps1, numRows, this.qf1, this.family);
        for (KeyValue kv : kvList1) {
            this.store.add(kv);
        }
        this.store.snapshot();
        TestStore.flushStore(this.store, this.id++);
        List<KeyValue> kvList2 = this.getKeyValueSet(timestamps2, numRows, this.qf1, this.family);
        for (KeyValue kv : kvList2) {
            this.store.add(kv);
        }
        Get get = new Get(Bytes.toBytes((int)1));
        get.addColumn(this.family, this.qf1);
        get.setTimeRange(0L, 15L);
        List<KeyValue> result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        TestStore.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(40L, 90L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        TestStore.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(10L, 45L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        TestStore.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(80L, 145L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        TestStore.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(1L, 2L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        TestStore.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(90L, 200L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        TestStore.assertTrue((result.size() == 0 ? 1 : 0) != 0);
    }

    public void testSplitWithEmptyColFam() throws IOException {
        this.init(this.getName());
        TestStore.assertNull((Object)this.store.getSplitPoint());
        this.store.getHRegion().forceSplit(null);
        TestStore.assertNull((Object)this.store.getSplitPoint());
        this.store.getHRegion().clearSplit_TESTS_ONLY();
    }

    static class FaultyOutputStream
    extends FSDataOutputStream {
        volatile long faultPos = Long.MAX_VALUE;

        public FaultyOutputStream(FSDataOutputStream out, long faultPos) throws IOException {
            super((OutputStream)out, null);
            this.faultPos = faultPos;
        }

        public void write(byte[] buf, int offset, int length) throws IOException {
            System.err.println("faulty stream write at pos " + this.getPos());
            this.injectFault();
            super.write(buf, offset, length);
        }

        private void injectFault() throws IOException {
            if (this.getPos() >= this.faultPos) {
                throw new IOException("Fault injected");
            }
        }
    }

    static class FaultyFileSystem
    extends FilterFileSystem {
        List<SoftReference<FaultyOutputStream>> outStreams = new ArrayList<SoftReference<FaultyOutputStream>>();
        private long faultPos = 200L;

        public FaultyFileSystem() {
            super((FileSystem)new LocalFileSystem());
            System.err.println("Creating faulty!");
        }

        public FSDataOutputStream create(Path p) throws IOException {
            return new FaultyOutputStream(super.create(p), this.faultPos);
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return new FaultyOutputStream(super.create(f, permission, overwrite, bufferSize, replication, blockSize, progress), this.faultPos);
        }

        public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return this.create(f, overwrite, bufferSize, replication, blockSize, progress);
        }
    }
}

