/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestStoreFile
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestStoreFile.class);
    private CacheConfig cacheConf;
    private String ROOT_DIR;
    private Map<String, Long> startingMetrics;
    private static final ChecksumType CKTYPE = ChecksumType.CRC32;
    private static final int CKBYTES = 512;
    byte[] SPLITKEY;
    private static final String localFormatter = "%010d";
    @Rule
    public ResourceCheckerJUnitRule cu;

    public TestStoreFile() {
        this.cacheConf = new CacheConfig(this.conf);
        this.SPLITKEY = new byte[]{12, 97};
        this.cu = new ResourceCheckerJUnitRule();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startingMetrics = SchemaMetrics.getMetricsSnapshot();
        this.ROOT_DIR = new Path(testDir, "TestStoreFile").toString();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        SchemaMetrics.validateMetricChanges(this.startingMetrics);
    }

    public void testBasicHalfMapFile() throws Exception {
        Path outputDir = new Path(new Path(testDir, "7e0102"), "familyname");
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs, 2048).withOutputDir(outputDir).build();
        this.writeStoreFile(writer);
        this.checkHalfHFile(new StoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE));
    }

    private void writeStoreFile(StoreFile.Writer writer) throws IOException {
        TestStoreFile.writeStoreFile(writer, Bytes.toBytes((String)this.getName()), Bytes.toBytes((String)this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStoreFile(StoreFile.Writer writer, byte[] fam, byte[] qualifier) throws IOException {
        long now = System.currentTimeMillis();
        try {
            for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] b = new byte[]{(byte)d, (byte)e};
                    writer.append(new KeyValue(b, fam, qualifier, now, b));
                }
            }
        }
        finally {
            writer.close();
        }
    }

    public void testReference() throws IOException {
        Path storedir = new Path(new Path(testDir, "7e0102"), "familyname");
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs, 8192).withOutputDir(storedir).build();
        this.writeStoreFile(writer);
        StoreFile hsf = new StoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        StoreFile.Reader reader = hsf.createReader();
        KeyValue kv = KeyValue.createKeyValueFromKey((byte[])reader.midkey());
        byte[] midRow = kv.getRow();
        kv = KeyValue.createKeyValueFromKey((byte[])reader.getLastKey());
        byte[] finalRow = kv.getRow();
        Path refPath = StoreFile.split((FileSystem)this.fs, (Path)storedir, (StoreFile)hsf, (byte[])midRow, (Reference.Range)Reference.Range.top);
        StoreFile refHsf = new StoreFile(this.fs, refPath, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        HFileScanner s = refHsf.createReader().getScanner(false, false);
        boolean first = true;
        while (!s.isSeeked() && s.seekTo() || s.next()) {
            ByteBuffer bb = s.getKey();
            kv = KeyValue.createKeyValueFromKey((ByteBuffer)bb);
            if (!first) continue;
            TestStoreFile.assertTrue((boolean)Bytes.equals((byte[])kv.getRow(), (byte[])midRow));
            first = false;
        }
        TestStoreFile.assertTrue((boolean)Bytes.equals((byte[])kv.getRow(), (byte[])finalRow));
    }

    public void testHFileLink() throws IOException {
        String columnFamily = "f";
        Configuration testConf = new Configuration(this.conf);
        FSUtils.setRootDir((Configuration)testConf, (Path)testDir);
        HRegionInfo hri = new HRegionInfo(Bytes.toBytes((String)"table-link"));
        Path storedir = new Path(new Path(testDir, new Path(hri.getTableNameAsString(), hri.getEncodedName())), "f");
        StoreFile.Writer writer = new StoreFile.WriterBuilder(testConf, this.cacheConf, this.fs, 8192).withOutputDir(storedir).build();
        Path storeFilePath = writer.getPath();
        this.writeStoreFile(writer);
        writer.close();
        Path dstPath = new Path(testDir, new Path("test-region", "f"));
        HFileLink.create((Configuration)testConf, (FileSystem)this.fs, (Path)dstPath, (HRegionInfo)hri, (String)storeFilePath.getName());
        Path linkFilePath = new Path(dstPath, HFileLink.createHFileLinkName((HRegionInfo)hri, (String)storeFilePath.getName()));
        StoreFile hsf = new StoreFile(this.fs, linkFilePath, testConf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        TestStoreFile.assertTrue((boolean)hsf.isLink());
        int count = 1;
        HFileScanner s = hsf.createReader().getScanner(false, false);
        s.seekTo();
        while (s.next()) {
            ++count;
        }
        TestStoreFile.assertEquals((int)676, (int)count);
    }

    public void testStoreFileNames() {
        String[] illegalHFileLink;
        String[] legalHFileLink;
        for (String name : legalHFileLink = new String[]{"MyTable_02=abc012-def345", "MyTable_02.300=abc012-def345", "MyTable_02-400=abc012-def345", "MyTable_02-400.200=abc012-def345", "MyTable_02=abc012-def345_SeqId_1_", "MyTable_02=abc012-def345_SeqId_20_"}) {
            TestStoreFile.assertTrue((String)("should be a valid link: " + name), (boolean)HFileLink.isHFileLink((String)name));
            TestStoreFile.assertTrue((String)("should be a valid StoreFile" + name), (boolean)StoreFile.validateStoreFileName((String)name));
            TestStoreFile.assertFalse((String)("should not be a valid reference: " + name), (boolean)StoreFile.isReference((String)name));
            String refName = name + ".6789";
            TestStoreFile.assertTrue((String)("should be a valid link reference: " + refName), (boolean)StoreFile.isReference((String)refName));
            TestStoreFile.assertTrue((String)("should be a valid StoreFile" + refName), (boolean)StoreFile.validateStoreFileName((String)refName));
        }
        for (String name : illegalHFileLink = new String[]{".MyTable_02=abc012-def345", "-MyTable_02.300=abc012-def345", "MyTable_02-400=abc0_12-def345", "MyTable_02-400.200=abc012-def345...."}) {
            TestStoreFile.assertFalse((String)("should not be a valid link: " + name), (boolean)HFileLink.isHFileLink((String)name));
        }
    }

    public void testReferenceToHFileLink() throws IOException {
        String columnFamily = "f";
        Path rootDir = FSUtils.getRootDir((Configuration)this.conf);
        String tablename = "_original-evil-name";
        HRegionInfo hri = new HRegionInfo(Bytes.toBytes((String)tablename));
        Path storedir = new Path(new Path(rootDir, new Path(hri.getTableNameAsString(), hri.getEncodedName())), "f");
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs, 8192).withOutputDir(storedir).build();
        Path storeFilePath = writer.getPath();
        this.writeStoreFile(writer);
        writer.close();
        String target = "clone";
        Path dstPath = new Path(rootDir, new Path(new Path(target, "7e0102"), "f"));
        HFileLink.create((Configuration)this.conf, (FileSystem)this.fs, (Path)dstPath, (HRegionInfo)hri, (String)storeFilePath.getName());
        Path linkFilePath = new Path(dstPath, HFileLink.createHFileLinkName((HRegionInfo)hri, (String)storeFilePath.getName()));
        Path splitDirA = new Path(new Path(rootDir, new Path(target, "571A")), "f");
        Path splitDirB = new Path(new Path(rootDir, new Path(target, "571B")), "f");
        StoreFile f = new StoreFile(this.fs, linkFilePath, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        byte[] splitRow = this.SPLITKEY;
        Path pathA = StoreFile.split((FileSystem)this.fs, (Path)splitDirA, (StoreFile)f, (byte[])splitRow, (Reference.Range)Reference.Range.top);
        Path pathB = StoreFile.split((FileSystem)this.fs, (Path)splitDirB, (StoreFile)f, (byte[])splitRow, (Reference.Range)Reference.Range.bottom);
        FSUtils.logFileSystemState((FileSystem)this.fs, (Path)rootDir, (Log)LOG);
        StoreFile hsfA = new StoreFile(this.fs, pathA, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        int count = 1;
        HFileScanner s = hsfA.createReader().getScanner(false, false);
        s.seekTo();
        while (s.next()) {
            ++count;
        }
        TestStoreFile.assertTrue((count > 0 ? 1 : 0) != 0);
        StoreFile hsfB = new StoreFile(this.fs, pathB, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        HFileScanner sB = hsfB.createReader().getScanner(false, false);
        sB.seekTo();
        while (sB.next()) {
            ++count;
        }
        TestStoreFile.assertEquals((int)676, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHalfHFile(StoreFile f) throws IOException {
        byte[] midkey = f.createReader().midkey();
        KeyValue midKV = KeyValue.createKeyValueFromKey((byte[])midkey);
        byte[] midRow = midKV.getRow();
        Path topDir = Store.getStoreHomedir((Path)testDir, (String)"1", (byte[])Bytes.toBytes((String)f.getPath().getParent().getName()));
        if (this.fs.exists(topDir)) {
            this.fs.delete(topDir, true);
        }
        Path topPath = StoreFile.split((FileSystem)this.fs, (Path)topDir, (StoreFile)f, (byte[])midRow, (Reference.Range)Reference.Range.top);
        Path bottomDir = Store.getStoreHomedir((Path)testDir, (String)"2", (byte[])Bytes.toBytes((String)f.getPath().getParent().getName()));
        if (this.fs.exists(bottomDir)) {
            this.fs.delete(bottomDir, true);
        }
        Path bottomPath = StoreFile.split((FileSystem)this.fs, (Path)bottomDir, (StoreFile)f, (byte[])midRow, (Reference.Range)Reference.Range.bottom);
        StoreFile.Reader top = new StoreFile(this.fs, topPath, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE).createReader();
        StoreFile.Reader bottom = new StoreFile(this.fs, bottomPath, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE).createReader();
        ByteBuffer previous = null;
        LOG.info((Object)("Midkey: " + midKV.toString()));
        ByteBuffer bbMidkeyBytes = ByteBuffer.wrap(midkey);
        try {
            int i;
            String tmp;
            KeyValue keyKV;
            boolean first = true;
            ByteBuffer key = null;
            HFileScanner topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.isSeeked() && topScanner.next()) {
                key = topScanner.getKey();
                if (topScanner.getReader().getComparator().compare(key.array(), key.arrayOffset(), key.limit(), midkey, 0, midkey.length) < 0) {
                    TestStoreFile.fail((String)("key=" + Bytes.toStringBinary((ByteBuffer)key) + " < midkey=" + Bytes.toStringBinary((byte[])midkey)));
                }
                if (!first) continue;
                first = false;
                LOG.info((Object)("First in top: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key))));
            }
            LOG.info((Object)("Last in top: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key))));
            first = true;
            HFileScanner bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                previous = bottomScanner.getKey();
                key = bottomScanner.getKey();
                if (first) {
                    first = false;
                    LOG.info((Object)("First in bottom: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)previous))));
                }
                TestStoreFile.assertTrue((key.compareTo(bbMidkeyBytes) < 0 ? 1 : 0) != 0);
            }
            if (previous != null) {
                LOG.info((Object)("Last in bottom: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)previous))));
            }
            this.fs.delete(topPath, false);
            this.fs.delete(bottomPath, false);
            byte[] badmidkey = Bytes.toBytes((String)"  .");
            topPath = StoreFile.split((FileSystem)this.fs, (Path)topDir, (StoreFile)f, (byte[])badmidkey, (Reference.Range)Reference.Range.top);
            bottomPath = StoreFile.split((FileSystem)this.fs, (Path)bottomDir, (StoreFile)f, (byte[])badmidkey, (Reference.Range)Reference.Range.bottom);
            top = new StoreFile(this.fs, topPath, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE).createReader();
            bottom = new StoreFile(this.fs, bottomPath, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE).createReader();
            bottomScanner = bottom.getScanner(false, false);
            int count = 0;
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                ++count;
            }
            TestStoreFile.assertTrue((count == 0 ? 1 : 0) != 0);
            first = true;
            topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.next()) {
                key = topScanner.getKey();
                TestStoreFile.assertTrue((topScanner.getReader().getComparator().compare(key.array(), key.arrayOffset(), key.limit(), badmidkey, 0, badmidkey.length) >= 0 ? 1 : 0) != 0);
                if (!first) continue;
                first = false;
                keyKV = KeyValue.createKeyValueFromKey((ByteBuffer)key);
                LOG.info((Object)("First top when key < bottom: " + keyKV));
                tmp = Bytes.toString((byte[])keyKV.getRow());
                for (i = 0; i < tmp.length(); ++i) {
                    TestStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValue.createKeyValueFromKey((ByteBuffer)key);
            LOG.info((Object)("Last top when key < bottom: " + keyKV));
            tmp = Bytes.toString((byte[])keyKV.getRow());
            for (i = 0; i < tmp.length(); ++i) {
                TestStoreFile.assertTrue((tmp.charAt(i) == 'z' ? 1 : 0) != 0);
            }
            this.fs.delete(topPath, false);
            this.fs.delete(bottomPath, false);
            badmidkey = Bytes.toBytes((String)"|||");
            topPath = StoreFile.split((FileSystem)this.fs, (Path)topDir, (StoreFile)f, (byte[])badmidkey, (Reference.Range)Reference.Range.top);
            bottomPath = StoreFile.split((FileSystem)this.fs, (Path)bottomDir, (StoreFile)f, (byte[])badmidkey, (Reference.Range)Reference.Range.bottom);
            top = new StoreFile(this.fs, topPath, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE).createReader();
            bottom = new StoreFile(this.fs, bottomPath, this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE).createReader();
            first = true;
            bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                key = bottomScanner.getKey();
                if (!first) continue;
                first = false;
                keyKV = KeyValue.createKeyValueFromKey((ByteBuffer)key);
                LOG.info((Object)("First bottom when key > top: " + keyKV));
                tmp = Bytes.toString((byte[])keyKV.getRow());
                for (i = 0; i < tmp.length(); ++i) {
                    TestStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValue.createKeyValueFromKey((ByteBuffer)key);
            LOG.info((Object)("Last bottom when key > top: " + keyKV));
            for (i = 0; i < tmp.length(); ++i) {
                TestStoreFile.assertTrue((Bytes.toString((byte[])keyKV.getRow()).charAt(i) == 'z' ? 1 : 0) != 0);
            }
            count = 0;
            topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.isSeeked() && topScanner.next()) {
                ++count;
            }
            TestStoreFile.assertTrue((count == 0 ? 1 : 0) != 0);
        }
        finally {
            if (top != null) {
                top.close(true);
            }
            if (bottom != null) {
                bottom.close(true);
            }
            this.fs.delete(f.getPath(), true);
        }
    }

    private void bloomWriteRead(StoreFile.Writer writer, FileSystem fs) throws Exception {
        float err = this.conf.getFloat("io.storefile.bloom.error.rate", 0.0f);
        Path f = writer.getPath();
        long now = System.currentTimeMillis();
        for (int i = 0; i < 2000; i += 2) {
            String row = String.format(localFormatter, i);
            KeyValue kv = new KeyValue(row.getBytes(), "family".getBytes(), "col".getBytes(), now, "value".getBytes());
            writer.append(kv);
        }
        writer.close();
        StoreFile.Reader reader = new StoreFile.Reader(fs, f, this.cacheConf, DataBlockEncoding.NONE);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        StoreFileScanner scanner = reader.getStoreFileScanner(false, false);
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            String row = String.format(localFormatter, i);
            TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            columns.add("family:col".getBytes());
            Scan scan = new Scan(row.getBytes(), row.getBytes());
            scan.addColumn("family".getBytes(), "family:col".getBytes());
            boolean exists = scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        reader.close(true);
        fs.delete(f, true);
        TestStoreFile.assertEquals((String)("False negatives: " + falseNeg), (int)0, (int)falseNeg);
        int maxFalsePos = (int)(4000.0f * err);
        TestStoreFile.assertTrue((String)("Too many false positives: " + falsePos + " (err=" + err + ", expected no more than " + maxFalsePos + ")"), (falsePos <= maxFalsePos ? 1 : 0) != 0);
    }

    public void testBloomFilter() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        Path f = new Path(this.ROOT_DIR, this.getName());
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, (FileSystem)fs, 8192).withFilePath(f).withBloomType(StoreFile.BloomType.ROW).withMaxKeyCount(2000L).withChecksumType(CKTYPE).withBytesPerChecksum(512).build();
        this.bloomWriteRead(writer, (FileSystem)fs);
    }

    public void testDeleteFamilyBloomFilter() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        float err = this.conf.getFloat("io.storefile.bloom.error.rate", 0.0f);
        Path f = new Path(this.ROOT_DIR, this.getName());
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, (FileSystem)fs, 8192).withFilePath(f).withMaxKeyCount(2000L).withChecksumType(CKTYPE).withBytesPerChecksum(512).build();
        long now = System.currentTimeMillis();
        for (int i = 0; i < 2000; i += 2) {
            String row = String.format(localFormatter, i);
            KeyValue kv = new KeyValue(row.getBytes(), "family".getBytes(), "col".getBytes(), now, KeyValue.Type.DeleteFamily, "value".getBytes());
            writer.append(kv);
        }
        writer.close();
        StoreFile.Reader reader = new StoreFile.Reader((FileSystem)fs, f, this.cacheConf, DataBlockEncoding.NONE);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            String row = String.format(localFormatter, i);
            byte[] rowKey = Bytes.toBytes((String)row);
            boolean exists = reader.passesDeleteFamilyBloomFilter(rowKey, 0, rowKey.length);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        TestStoreFile.assertEquals((long)1000L, (long)reader.getDeleteFamilyCnt());
        reader.close(true);
        fs.delete(f, true);
        TestStoreFile.assertEquals((String)("False negatives: " + falseNeg), (int)0, (int)falseNeg);
        int maxFalsePos = (int)(4000.0f * err);
        TestStoreFile.assertTrue((String)("Too many false positives: " + falsePos + " (err=" + err + ", expected no more than " + maxFalsePos), (falsePos <= maxFalsePos ? 1 : 0) != 0);
    }

    public void testBloomTypes() throws Exception {
        float err = 0.01f;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", err);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        int rowCount = 50;
        int colCount = 10;
        int versions = 2;
        StoreFile.BloomType[] bt = new StoreFile.BloomType[]{StoreFile.BloomType.ROWCOL, StoreFile.BloomType.ROW};
        int[] expKeys = new int[]{rowCount * colCount, rowCount};
        float[] expErr = new float[]{(float)(2 * rowCount * colCount) * err, (float)(2 * rowCount * 2 * colCount) * err};
        for (int x : new int[]{0, 1}) {
            Path f = new Path(this.ROOT_DIR, this.getName() + x);
            StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, (FileSystem)fs, 8192).withFilePath(f).withBloomType(bt[x]).withMaxKeyCount((long)expKeys[x]).withChecksumType(CKTYPE).withBytesPerChecksum(512).build();
            long now = System.currentTimeMillis();
            for (int i = 0; i < rowCount * 2; i += 2) {
                for (int j = 0; j < colCount * 2; j += 2) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    for (int k = 0; k < versions; ++k) {
                        KeyValue kv = new KeyValue(row.getBytes(), "family".getBytes(), ("col" + col).getBytes(), now - (long)k, Bytes.toBytes((long)-1L));
                        writer.append(kv);
                    }
                }
            }
            writer.close();
            StoreFile.Reader reader = new StoreFile.Reader((FileSystem)fs, f, this.cacheConf, DataBlockEncoding.NONE);
            reader.loadFileInfo();
            reader.loadBloomfilter();
            StoreFileScanner scanner = reader.getStoreFileScanner(false, false);
            TestStoreFile.assertEquals((long)expKeys[x], (long)reader.generalBloomFilter.getKeyCount());
            int falsePos = 0;
            int falseNeg = 0;
            for (int i = 0; i < rowCount * 2; ++i) {
                for (int j = 0; j < colCount * 2; ++j) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                    columns.add(("col" + col).getBytes());
                    Scan scan = new Scan(row.getBytes(), row.getBytes());
                    scan.addColumn("family".getBytes(), ("col" + col).getBytes());
                    boolean exists = scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE);
                    boolean shouldRowExist = i % 2 == 0;
                    boolean shouldColExist = j % 2 == 0;
                    boolean bl = shouldColExist = shouldColExist || bt[x] == StoreFile.BloomType.ROW;
                    if (shouldRowExist && shouldColExist) {
                        if (exists) continue;
                        ++falseNeg;
                        continue;
                    }
                    if (!exists) continue;
                    ++falsePos;
                }
            }
            reader.close(true);
            fs.delete(f, true);
            System.out.println(bt[x].toString());
            System.out.println("  False negatives: " + falseNeg);
            System.out.println("  False positives: " + falsePos);
            TestStoreFile.assertEquals((int)0, (int)falseNeg);
            TestStoreFile.assertTrue(((float)falsePos < 2.0f * expErr[x] ? 1 : 0) != 0);
        }
    }

    public void testBloomEdgeCases() throws Exception {
        float err = 0.005f;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        Path f = new Path(this.ROOT_DIR, this.getName());
        this.conf.setFloat("io.storefile.bloom.error.rate", err);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        this.conf.setInt("io.storefile.bloom.max.keys", 1000);
        this.conf.setInt("hfile.format.version", 1);
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, (FileSystem)fs, 8192).withFilePath(f).withBloomType(StoreFile.BloomType.ROW).withMaxKeyCount(2000L).withChecksumType(CKTYPE).withBytesPerChecksum(512).build();
        TestStoreFile.assertFalse((boolean)writer.hasGeneralBloom());
        writer.close();
        fs.delete(f, true);
        this.conf.setInt("io.storefile.bloom.max.keys", Integer.MAX_VALUE);
        writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, (FileSystem)fs, 8192).withFilePath(f).withBloomType(StoreFile.BloomType.ROW).withMaxKeyCount(27244696L).build();
        TestStoreFile.assertTrue((boolean)writer.hasGeneralBloom());
        this.bloomWriteRead(writer, (FileSystem)fs);
        writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, (FileSystem)fs, 8192).withFilePath(f).withBloomType(StoreFile.BloomType.ROW).withMaxKeyCount(Integer.MAX_VALUE).withChecksumType(CKTYPE).withBytesPerChecksum(512).build();
        TestStoreFile.assertFalse((boolean)writer.hasGeneralBloom());
        writer.close();
        fs.delete(f, true);
    }

    public void testFlushTimeComparator() {
        this.assertOrdering(StoreFile.Comparators.FLUSH_TIME, this.mockStoreFile(true, 1000L, -1L, "/foo/123"), this.mockStoreFile(true, 1000L, -1L, "/foo/126"), this.mockStoreFile(true, 2000L, -1L, "/foo/126"), this.mockStoreFile(false, -1L, 1L, "/foo/1"), this.mockStoreFile(false, -1L, 3L, "/foo/2"), this.mockStoreFile(false, -1L, 5L, "/foo/2"), this.mockStoreFile(false, -1L, 5L, "/foo/3"));
    }

    private void assertOrdering(Comparator<StoreFile> comparator, StoreFile ... sfs) {
        ArrayList sorted = Lists.newArrayList((Object[])sfs);
        Collections.shuffle(sorted);
        Collections.sort(sorted, comparator);
        LOG.debug((Object)("sfs: " + Joiner.on((String)",").join((Object[])sfs)));
        LOG.debug((Object)("sorted: " + Joiner.on((String)",").join((Iterable)sorted)));
        TestStoreFile.assertTrue((boolean)Iterables.elementsEqual(Arrays.asList(sfs), (Iterable)sorted));
    }

    private StoreFile mockStoreFile(boolean bulkLoad, long bulkTimestamp, long seqId, String path) {
        StoreFile mock = (StoreFile)Mockito.mock(StoreFile.class);
        ((StoreFile)Mockito.doReturn((Object)bulkLoad).when((Object)mock)).isBulkLoadResult();
        ((StoreFile)Mockito.doReturn((Object)bulkTimestamp).when((Object)mock)).getBulkLoadTimestamp();
        if (bulkLoad) {
            ((StoreFile)Mockito.doThrow((Throwable)new IllegalAccessError("bulk load")).when((Object)mock)).getMaxSequenceId();
        } else {
            ((StoreFile)Mockito.doReturn((Object)seqId).when((Object)mock)).getMaxSequenceId();
        }
        ((StoreFile)Mockito.doReturn((Object)new Path(path)).when((Object)mock)).getPath();
        String name = "mock storefile, bulkLoad=" + bulkLoad + " bulkTimestamp=" + bulkTimestamp + " seqId=" + seqId + " path=" + path;
        ((StoreFile)Mockito.doReturn((Object)name).when((Object)mock)).toString();
        return mock;
    }

    List<KeyValue> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes((int)i);
            LOG.info((Object)Bytes.toString((byte[])b));
            LOG.info((Object)Bytes.toString((byte[])b));
            for (long timestamp : timestamps) {
                kvList.add(new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    public void testMultipleTimestamps() throws IOException {
        byte[] family = Bytes.toBytes((String)"familyname");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        int numRows = 10;
        long[] timestamps = new long[]{20L, 10L, 5L, 1L};
        Scan scan = new Scan();
        Path storedir = new Path(new Path(testDir, "7e0102"), "familyname");
        Path dir = new Path(storedir, "1234567890");
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs, 8192).withOutputDir(dir).build();
        List<KeyValue> kvList = this.getKeyValueSet(timestamps, numRows, family, qualifier);
        for (KeyValue kv : kvList) {
            writer.append(kv);
        }
        writer.appendMetadata(0L, false);
        writer.close();
        StoreFile hsf = new StoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        StoreFile.Reader reader = hsf.createReader();
        StoreFileScanner scanner = reader.getStoreFileScanner(false, false);
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(qualifier);
        scan.setTimeRange(20L, 100L);
        TestStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE));
        scan.setTimeRange(1L, 2L);
        TestStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE));
        scan.setTimeRange(8L, 10L);
        TestStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE));
        scan.setTimeRange(7L, 50L);
        TestStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE));
        scan.setTimeRange(27L, 50L);
        TestStoreFile.assertTrue((!scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE) ? 1 : 0) != 0);
    }

    public void testCacheOnWriteEvictOnClose() throws Exception {
        Configuration conf = this.conf;
        Path baseDir = new Path(new Path(testDir, "7e0102"), "twoCOWEOC");
        BlockCache bc = new CacheConfig(conf).getBlockCache();
        TestStoreFile.assertNotNull((Object)bc);
        CacheStats cs = bc.getStats();
        long startHit = cs.getHitCount();
        long startMiss = cs.getMissCount();
        long startEvicted = cs.getEvictedCount();
        conf.setBoolean("hbase.rs.cacheblocksonwrite", false);
        CacheConfig cacheConf = new CacheConfig(conf);
        Path pathCowOff = new Path(baseDir, "123456789");
        StoreFile.Writer writer = this.writeStoreFile(conf, cacheConf, pathCowOff, 3);
        StoreFile hsf = new StoreFile(this.fs, writer.getPath(), conf, cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        LOG.debug((Object)hsf.getPath().toString());
        StoreFile.Reader reader = hsf.createReader();
        reader.loadFileInfo();
        StoreFileScanner scanner = reader.getStoreFileScanner(true, true);
        scanner.seek(KeyValue.LOWESTKEY);
        while (scanner.next() != null) {
        }
        TestStoreFile.assertEquals((long)startHit, (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)(startMiss + 3L), (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startMiss += 3L;
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
        conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
        cacheConf = new CacheConfig(conf);
        Path pathCowOn = new Path(baseDir, "123456788");
        writer = this.writeStoreFile(conf, cacheConf, pathCowOn, 3);
        hsf = new StoreFile(this.fs, writer.getPath(), conf, cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        reader = hsf.createReader();
        scanner = reader.getStoreFileScanner(true, true);
        scanner.seek(KeyValue.LOWESTKEY);
        while (scanner.next() != null) {
        }
        TestStoreFile.assertEquals((long)(startHit + 3L), (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startHit += 3L;
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
        hsf = new StoreFile(this.fs, pathCowOff, conf, cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        StoreFile.Reader readerOne = hsf.createReader();
        readerOne.loadFileInfo();
        StoreFileScanner scannerOne = readerOne.getStoreFileScanner(true, true);
        scannerOne.seek(KeyValue.LOWESTKEY);
        hsf = new StoreFile(this.fs, pathCowOn, conf, cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        StoreFile.Reader readerTwo = hsf.createReader();
        readerTwo.loadFileInfo();
        StoreFileScanner scannerTwo = readerTwo.getStoreFileScanner(true, true);
        scannerTwo.seek(KeyValue.LOWESTKEY);
        KeyValue kv1 = null;
        KeyValue kv2 = null;
        while ((kv1 = scannerOne.next()) != null) {
            kv2 = scannerTwo.next();
            TestStoreFile.assertTrue((boolean)kv1.equals((Object)kv2));
            TestStoreFile.assertTrue((Bytes.compareTo((byte[])kv1.getBuffer(), (int)kv1.getKeyOffset(), (int)kv1.getKeyLength(), (byte[])kv2.getBuffer(), (int)kv2.getKeyOffset(), (int)kv2.getKeyLength()) == 0 ? 1 : 0) != 0);
            TestStoreFile.assertTrue((Bytes.compareTo((byte[])kv1.getBuffer(), (int)kv1.getValueOffset(), (int)kv1.getValueLength(), (byte[])kv2.getBuffer(), (int)kv2.getValueOffset(), (int)kv2.getValueLength()) == 0 ? 1 : 0) != 0);
        }
        TestStoreFile.assertNull((Object)scannerTwo.next());
        TestStoreFile.assertEquals((long)(startHit + 6L), (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startHit += 6L;
        scannerOne.close();
        readerOne.close(cacheConf.shouldEvictOnClose());
        scannerTwo.close();
        readerTwo.close(cacheConf.shouldEvictOnClose());
        conf.setBoolean("hbase.rs.evictblocksonclose", true);
        cacheConf = new CacheConfig(conf);
        hsf = new StoreFile(this.fs, pathCowOff, conf, cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        reader = hsf.createReader();
        reader.close(cacheConf.shouldEvictOnClose());
        TestStoreFile.assertEquals((long)startHit, (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)(startEvicted + 3L), (long)cs.getEvictedCount());
        startEvicted += 3L;
        conf.setBoolean("hbase.rs.evictblocksonclose", false);
        cacheConf = new CacheConfig(conf);
        hsf = new StoreFile(this.fs, pathCowOn, conf, cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
        reader = hsf.createReader();
        reader.close(cacheConf.shouldEvictOnClose());
        TestStoreFile.assertEquals((long)startHit, (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
    }

    private StoreFile.Writer writeStoreFile(Configuration conf, CacheConfig cacheConf, Path path, int numBlocks) throws IOException {
        int numKVs = 5 * numBlocks;
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(numKVs);
        byte[] b = Bytes.toBytes((String)"x");
        int totalSize = 0;
        for (int i = numKVs; i > 0; --i) {
            KeyValue kv = new KeyValue(b, b, b, (long)i, b);
            kvs.add(kv);
            totalSize += kv.getLength() + 1;
        }
        int blockSize = totalSize / numBlocks;
        StoreFile.Writer writer = new StoreFile.WriterBuilder(conf, cacheConf, this.fs, blockSize).withFilePath(path).withMaxKeyCount(2000L).withChecksumType(CKTYPE).withBytesPerChecksum(512).build();
        kvs.remove(kvs.size() - 1);
        for (KeyValue kv : kvs) {
            writer.append(kv);
        }
        writer.appendMetadata(0L, false);
        writer.close();
        return writer;
    }

    public void testDataBlockEncodingMetaData() throws IOException {
        Path dir = new Path(new Path(testDir, "7e0102"), "familyname");
        Path path = new Path(dir, "1234567890");
        DataBlockEncoding dataBlockEncoderAlgo = DataBlockEncoding.FAST_DIFF;
        HFileDataBlockEncoderImpl dataBlockEncoder = new HFileDataBlockEncoderImpl(dataBlockEncoderAlgo, dataBlockEncoderAlgo);
        this.cacheConf = new CacheConfig(this.conf);
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs, 65536).withFilePath(path).withDataBlockEncoder((HFileDataBlockEncoder)dataBlockEncoder).withMaxKeyCount(2000L).withChecksumType(CKTYPE).withBytesPerChecksum(512).build();
        writer.close();
        StoreFile storeFile = new StoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, StoreFile.BloomType.NONE, (HFileDataBlockEncoder)dataBlockEncoder);
        StoreFile.Reader reader = storeFile.createReader();
        Map fileInfo = reader.loadFileInfo();
        byte[] value = (byte[])fileInfo.get(HFileDataBlockEncoder.DATA_BLOCK_ENCODING);
        TestStoreFile.assertEquals(dataBlockEncoderAlgo.getNameInBytes(), value);
    }
}

