/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.handler.CloseRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MockRegionServerServices;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestCloseRegionHandler {
    static final Log LOG = LogFactory.getLog(TestCloseRegionHandler.class);
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static final HTableDescriptor TEST_HTD = new HTableDescriptor("TestCloseRegionHandler");
    private HRegionInfo TEST_HRI;
    private int testIndex = 0;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniZKCluster();
    }

    @AfterClass
    public static void after() throws IOException {
        HTU.shutdownMiniZKCluster();
    }

    @Before
    public void setupHRI() {
        this.TEST_HRI = new HRegionInfo(TEST_HTD.getName(), Bytes.toBytes((int)this.testIndex), Bytes.toBytes((int)(this.testIndex + 1)));
        ++this.testIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedFlushAborts() throws IOException, KeeperException.NodeExistsException, KeeperException {
        block8: {
            MockServer server = new MockServer(HTU, false);
            MockRegionServerServices rss = new MockRegionServerServices();
            HTableDescriptor htd = TEST_HTD;
            HRegionInfo hri = new HRegionInfo(htd.getName(), HConstants.EMPTY_END_ROW, HConstants.EMPTY_END_ROW);
            HRegion region = HRegion.createHRegion((HRegionInfo)hri, (Path)HTU.getDataTestDir(), (Configuration)HTU.getConfiguration(), (HTableDescriptor)htd);
            try {
                Assert.assertNotNull((Object)region);
                HRegion spy = (HRegion)Mockito.spy((Object)region);
                boolean abort = false;
                Mockito.when((Object)spy.close(false)).thenThrow(new Throwable[]{new RuntimeException("Mocked failed close!")});
                rss.addToOnlineRegions(spy);
                Assert.assertFalse((boolean)server.isStopped());
                CloseRegionHandler handler = new CloseRegionHandler((Server)server, (RegionServerServices)rss, hri, false, false, -1);
                boolean throwable = false;
                try {
                    handler.process();
                }
                catch (Throwable t) {
                    try {
                        throwable = true;
                        break block8;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        Assert.assertTrue((boolean)throwable);
                        Assert.assertTrue((boolean)server.isStopped());
                    }
                }
                Assert.assertTrue((boolean)throwable);
                Assert.assertTrue((boolean)server.isStopped());
            }
            finally {
                HRegion.closeHRegion((HRegion)region);
            }
        }
    }

    @Test
    public void testZKClosingNodeVersionMismatch() throws IOException, KeeperException.NodeExistsException, KeeperException {
        MockServer server = new MockServer(HTU);
        MockRegionServerServices rss = new MockRegionServerServices();
        rss.setFileSystem(HTU.getTestFileSystem());
        HTableDescriptor htd = TEST_HTD;
        HRegionInfo hri = this.TEST_HRI;
        this.OpenRegion(server, rss, htd, hri);
        int versionOfClosingNode = ZKAssign.createNodeClosing((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
        CloseRegionHandler handler = new CloseRegionHandler((Server)server, (RegionServerServices)rss, hri, false, true, versionOfClosingNode + 1);
        handler.process();
        RegionTransitionData data = ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName());
        Assert.assertTrue((EventHandler.EventType.M_ZK_REGION_CLOSING == data.getEventType() ? 1 : 0) != 0);
    }

    @Test
    public void testCloseRegion() throws IOException, KeeperException.NodeExistsException, KeeperException {
        MockServer server = new MockServer(HTU);
        MockRegionServerServices rss = new MockRegionServerServices();
        rss.setFileSystem(HTU.getTestFileSystem());
        HTableDescriptor htd = TEST_HTD;
        HRegionInfo hri = this.TEST_HRI;
        this.OpenRegion(server, rss, htd, hri);
        int versionOfClosingNode = ZKAssign.createNodeClosing((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
        CloseRegionHandler handler = new CloseRegionHandler((Server)server, (RegionServerServices)rss, hri, false, true, versionOfClosingNode);
        handler.process();
        RegionTransitionData data = ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName());
        Assert.assertTrue((EventHandler.EventType.RS_ZK_REGION_CLOSED == data.getEventType() ? 1 : 0) != 0);
    }

    private void OpenRegion(Server server, RegionServerServices rss, HTableDescriptor htd, HRegionInfo hri) throws IOException, KeeperException.NodeExistsException, KeeperException {
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
        int version = ZKAssign.transitionNodeOpening((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
        OpenRegionHandler openHandler = new OpenRegionHandler(server, rss, hri, htd, version);
        openHandler.process();
        RegionTransitionData data = ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName());
        ZKAssign.deleteNode((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName(), (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_OPENED);
    }
}

