/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestSchemaMetrics {
    private final String TABLE_NAME = "myTable";
    private final String CF_NAME = "myColumnFamily";
    private final boolean useTableName;
    private Map<String, Long> startingMetrics;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseTestingUtility.BOOLEAN_PARAMETERIZED;
    }

    public TestSchemaMetrics(boolean useTableName) {
        this.useTableName = useTableName;
        SchemaMetrics.setUseTableNameInTest((boolean)useTableName);
    }

    @Before
    public void setUp() {
        this.startingMetrics = SchemaMetrics.getMetricsSnapshot();
    }

    @Test
    public void testNaming() {
        String metricPrefix = (this.useTableName ? "tbl.myTable." : "") + "cf." + "myColumnFamily" + ".";
        SchemaMetrics schemaMetrics = SchemaMetrics.getInstance((String)"myTable", (String)"myColumnFamily");
        SchemaMetrics ALL_CF_METRICS = SchemaMetrics.ALL_SCHEMA_METRICS;
        Assert.assertEquals((Object)(metricPrefix + "fsRead"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, false, SchemaMetrics.BlockMetricType.READ_TIME));
        Assert.assertEquals((Object)(metricPrefix + "compactionRead"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, true, SchemaMetrics.BlockMetricType.READ_TIME));
        Assert.assertEquals((Object)(metricPrefix + "fsBlockReadCnt"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, false, SchemaMetrics.BlockMetricType.READ_COUNT));
        Assert.assertEquals((Object)(metricPrefix + "fsBlockReadCacheHitCnt"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, false, SchemaMetrics.BlockMetricType.CACHE_HIT));
        Assert.assertEquals((Object)(metricPrefix + "fsBlockReadCacheMissCnt"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, false, SchemaMetrics.BlockMetricType.CACHE_MISS));
        Assert.assertEquals((Object)(metricPrefix + "compactionBlockReadCnt"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, true, SchemaMetrics.BlockMetricType.READ_COUNT));
        Assert.assertEquals((Object)(metricPrefix + "compactionBlockReadCacheHitCnt"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, true, SchemaMetrics.BlockMetricType.CACHE_HIT));
        Assert.assertEquals((Object)(metricPrefix + "compactionBlockReadCacheMissCnt"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, true, SchemaMetrics.BlockMetricType.CACHE_MISS));
        Assert.assertEquals((Object)"fsMetaBlockReadCnt", (Object)ALL_CF_METRICS.getBlockMetricName(BlockType.BlockCategory.META, false, SchemaMetrics.BlockMetricType.READ_COUNT));
        Assert.assertEquals((Object)"fsMetaBlockReadCacheHitCnt", (Object)ALL_CF_METRICS.getBlockMetricName(BlockType.BlockCategory.META, false, SchemaMetrics.BlockMetricType.CACHE_HIT));
        Assert.assertEquals((Object)"fsMetaBlockReadCacheMissCnt", (Object)ALL_CF_METRICS.getBlockMetricName(BlockType.BlockCategory.META, false, SchemaMetrics.BlockMetricType.CACHE_MISS));
        Assert.assertEquals((Object)(metricPrefix + "bt.Index.fsBlockReadCnt"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.INDEX, false, SchemaMetrics.BlockMetricType.READ_COUNT));
        Assert.assertEquals((Object)(metricPrefix + "bt.Data.compactionBlockReadCacheHitCnt"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.DATA, true, SchemaMetrics.BlockMetricType.CACHE_HIT));
        Assert.assertEquals((Object)(metricPrefix + "compactionMetaBlockReadCacheHitCnt"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.META, true, SchemaMetrics.BlockMetricType.CACHE_HIT));
        Assert.assertEquals((Object)(metricPrefix + "blockCacheSize"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, false, SchemaMetrics.BlockMetricType.CACHE_SIZE));
        Assert.assertEquals((Object)(metricPrefix + "bt.Index.blockCacheNumEvicted"), (Object)schemaMetrics.getBlockMetricName(BlockType.BlockCategory.INDEX, false, SchemaMetrics.BlockMetricType.EVICTED));
        Assert.assertEquals((Object)"bt.Data.blockCacheNumCached", (Object)ALL_CF_METRICS.getBlockMetricName(BlockType.BlockCategory.DATA, false, SchemaMetrics.BlockMetricType.CACHED));
        Assert.assertEquals((Object)"blockCacheNumCached", (Object)ALL_CF_METRICS.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, false, SchemaMetrics.BlockMetricType.CACHED));
        try {
            ALL_CF_METRICS.getBlockMetricName(BlockType.BlockCategory.ALL_CATEGORIES, true, SchemaMetrics.BlockMetricType.CACHE_SIZE);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        Assert.assertEquals((Object)"keyMaybeInBloomCnt", (Object)ALL_CF_METRICS.getBloomMetricName(true));
        Assert.assertEquals((Object)(metricPrefix + "keyNotInBloomCnt"), (Object)schemaMetrics.getBloomMetricName(false));
        schemaMetrics.printMetricNames();
    }

    public void checkMetrics() {
        SchemaMetrics.validateMetricChanges(this.startingMetrics);
    }

    @Test
    public void testIncrements() {
        Random rand = new Random(23982737L);
        for (int i = 1; i <= 3; ++i) {
            String tableName = "table" + i;
            for (int j = 1; j <= 3; ++j) {
                String cfName = "cf" + j;
                SchemaMetrics sm = SchemaMetrics.getInstance((String)tableName, (String)cfName);
                for (boolean isInBloom : SchemaMetrics.BOOL_VALUES) {
                    sm.updateBloomMetrics(isInBloom);
                    this.checkMetrics();
                }
                for (BlockType.BlockCategory blockCat : BlockType.BlockCategory.values()) {
                    if (blockCat == BlockType.BlockCategory.ALL_CATEGORIES) continue;
                    for (boolean isCompaction : SchemaMetrics.BOOL_VALUES) {
                        sm.updateOnCacheHit(blockCat, isCompaction);
                        this.checkMetrics();
                        sm.updateOnCacheMiss(blockCat, isCompaction, (long)rand.nextInt());
                        this.checkMetrics();
                    }
                    for (boolean isEviction : SchemaMetrics.BOOL_VALUES) {
                        sm.updateOnCachePutOrEvict(blockCat, (long)((isEviction ? -1 : 1) * rand.nextInt(0x100000)), isEviction);
                    }
                }
            }
        }
    }

    @Test
    public void testGenerateSchemaMetricsPrefix() {
        String tableName = "table1";
        int numCF = 3;
        StringBuilder expected = new StringBuilder();
        if (this.useTableName) {
            expected.append("tbl.");
            expected.append(tableName);
            expected.append(".");
        }
        expected.append("cf.");
        HashSet<byte[]> families = new HashSet<byte[]>();
        for (int i = 1; i <= numCF; ++i) {
            String cf = "cf" + i;
            families.add(Bytes.toBytes((String)cf));
            expected.append(cf);
            if (i == numCF) {
                expected.append(".");
                continue;
            }
            expected.append("~");
        }
        String result = SchemaMetrics.generateSchemaMetricsPrefix((String)tableName, families);
        Assert.assertEquals((Object)expected.toString(), (Object)result);
    }
}

