/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.wal.Compressor;
import org.apache.hadoop.hbase.regionserver.wal.Dictionary;
import org.apache.hadoop.hbase.regionserver.wal.LRUDictionary;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCompressor {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Test
    public void testToShort() {
        int s = 1;
        Assert.assertEquals((long)s, (long)Compressor.toShort((byte)0, (byte)1));
        s = (short)(s << 8);
        Assert.assertEquals((long)s, (long)Compressor.toShort((byte)1, (byte)0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeToShort() {
        Compressor.toShort((byte)-1, (byte)-1);
    }

    @Test
    public void testCompressingWithNullDictionaries() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] blahBytes = Bytes.toBytes((String)"blah");
        Compressor.writeCompressed((byte[])blahBytes, (int)0, (int)blahBytes.length, (DataOutput)dos, null);
        dos.close();
        byte[] dosbytes = baos.toByteArray();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dosbytes));
        byte[] product = Compressor.readCompressed((DataInput)dis, null);
        Assert.assertTrue((boolean)Bytes.equals((byte[])blahBytes, (byte[])product));
    }

    @Test
    public void testCompressingWithClearDictionaries() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        LRUDictionary dictionary = new LRUDictionary();
        byte[] blahBytes = Bytes.toBytes((String)"blah");
        Compressor.writeCompressed((byte[])blahBytes, (int)0, (int)blahBytes.length, (DataOutput)dos, (Dictionary)dictionary);
        dos.close();
        byte[] dosbytes = baos.toByteArray();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dosbytes));
        dictionary = new LRUDictionary();
        byte[] product = Compressor.readCompressed((DataInput)dis, (Dictionary)dictionary);
        Assert.assertTrue((boolean)Bytes.equals((byte[])blahBytes, (byte[])product));
    }
}

