/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHLogBench
extends Configured
implements Tool {
    static final Log LOG = LogFactory.getLog(TestHLogBench.class);
    private static final Random r = new Random();
    private static final byte[] FAMILY = Bytes.toBytes((String)"hlogbenchFamily");
    private static int totalTime = 0;
    private static Object lock = new Object();
    protected FileSystem fs = null;
    private int numThreads = 300;
    private int numIterationsPerThread = 10000;
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Path regionRootDir = this.TEST_UTIL.getDataTestDir("TestHLogBench");
    private boolean appendNoSync = false;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public TestHLogBench() {
        this(null);
    }

    private TestHLogBench(Configuration conf) {
        super(conf);
    }

    public void init() throws IOException {
        this.getConf().setQuietMode(true);
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)this.getConf());
        }
    }

    public void close() throws IOException {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
    }

    public int run(String[] argv) throws Exception {
        int exitCode = -1;
        if (argv.length < 4) {
            TestHLogBench.printUsage("");
            return exitCode;
        }
        try {
            this.init();
        }
        catch (HBaseRPC.VersionMismatch v) {
            LOG.warn((Object)"Version Mismatch between client and server... command aborted.");
            return exitCode;
        }
        catch (IOException e) {
            LOG.warn((Object)"Bad connection to FS. command aborted.");
            return exitCode;
        }
        try {
            for (int i = 0; i < argv.length; ++i) {
                if ("-numThreads".equals(argv[i])) {
                    this.numThreads = Integer.parseInt(argv[++i]);
                    continue;
                }
                if ("-numIterationsPerThread".equals(argv[i])) {
                    this.numIterationsPerThread = Integer.parseInt(argv[++i]);
                    continue;
                }
                if ("-path".equals(argv[i])) {
                    this.regionRootDir = new Path(argv[++i]);
                    this.regionRootDir = this.regionRootDir.makeQualified(this.fs);
                    continue;
                }
                if ("-nosync".equals(argv[i])) {
                    this.appendNoSync = true;
                    continue;
                }
                TestHLogBench.printUsage(argv[i]);
                return exitCode;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.warn((Object)"Illegal numThreads or numIterationsPerThread,  a positive integer expected");
            throw nfe;
        }
        this.go();
        return 0;
    }

    private void go() throws IOException, InterruptedException {
        int i;
        long start = System.currentTimeMillis();
        TestHLogBench.log("Running TestHLogBench with " + this.numThreads + " threads each doing " + this.numIterationsPerThread + " HLog appends " + (this.appendNoSync ? "nosync" : "sync") + " at rootDir " + this.regionRootDir);
        byte[] tableName = Bytes.toBytes((String)"table");
        byte[][] familyNames = new byte[][]{FAMILY};
        HTableDescriptor htd = new HTableDescriptor();
        htd.addFamily(new HColumnDescriptor(Bytes.toBytes((String)"f1")));
        HRegion region = this.mockRegion(tableName, familyNames, this.regionRootDir);
        HLog hlog = region.getLog();
        LogWriter[] incrementors = new LogWriter[this.numThreads];
        for (i = 0; i < this.numThreads; ++i) {
            incrementors[i] = new LogWriter(region, tableName, hlog, i, this.numIterationsPerThread, this.appendNoSync);
            incrementors[i].start();
        }
        for (i = 0; i < this.numThreads; ++i) {
            incrementors[i].join();
        }
        long totalOps = this.numThreads * this.numIterationsPerThread;
        TestHLogBench.log("Operations per second " + totalOps * 1000L / (long)totalTime);
        TestHLogBench.log("Average latency in ms " + (long)totalTime * 1000L / totalOps);
    }

    private static void printUsage(String cmd) {
        String prefix = "Usage: java " + TestHLogBench.class.getSimpleName();
        System.err.println(prefix + cmd + " [-numThreads <number>] " + " [-numIterationsPerThread <number>] " + " [-path <path where region's root directory is created>]" + " [-nosync]");
    }

    private static void log(String string) {
        LOG.info((Object)string);
    }

    private byte[][] makeBytes(int numArrays, int arraySize) {
        byte[][] bytes = new byte[numArrays][];
        for (int i = 0; i < numArrays; ++i) {
            bytes[i] = new byte[arraySize];
            r.nextBytes(bytes[i]);
        }
        return bytes;
    }

    private HRegion mockRegion(byte[] tableName, byte[][] familyNames, Path rootDir) throws IOException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        Configuration conf = htu.getConfiguration();
        conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
        conf.setBoolean("hbase.hregion.use.incrementnew", true);
        conf.setBoolean("dfs.support.append", true);
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numQualifiers = 10;
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes((String)("qf" + i));
        }
        int numRows = 10;
        byte[][] rows = new byte[numRows][];
        for (int i = 0; i < numRows; ++i) {
            rows[i] = Bytes.toBytes((String)("r" + i));
        }
        ((Log4JLogger)HRegion.LOG).getLogger().setLevel(Level.WARN);
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : familyNames) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo hri = new HRegionInfo(tableName, Bytes.toBytes((long)0L), Bytes.toBytes((long)0xFFFFFFFFL));
        if (fs.exists(rootDir) && !fs.delete(rootDir, true)) {
            throw new IOException("Failed delete of " + rootDir);
        }
        return HRegion.createHRegion((HRegionInfo)hri, (Path)rootDir, (Configuration)conf, (HTableDescriptor)htd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogPerformance() throws Exception {
        TestHLogBench bench = new TestHLogBench();
        String[] argv = new String[]{"-numThreads", Integer.toString(100), "-numIterationsPerThread", Integer.toString(1000), "-path", this.TEST_UTIL.getDataTestDir() + "/HlogPerformance", "-nosync"};
        try {
            int res = ToolRunner.run((Tool)bench, (String[])argv);
        }
        finally {
            bench.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        int res;
        TestHLogBench bench = new TestHLogBench();
        try {
            res = ToolRunner.run((Tool)bench, (String[])argv);
        }
        finally {
            bench.close();
        }
        System.exit(res);
    }

    public static class LogWriter
    extends Thread {
        private final HRegion region;
        private final int threadNumber;
        private final int numIncrements;
        private final HLog hlog;
        private boolean appendNoSync;
        private byte[] tableName;
        private int count;

        public LogWriter(HRegion region, byte[] tableName, HLog log, int threadNumber, int numIncrements, boolean appendNoSync) {
            this.region = region;
            this.threadNumber = threadNumber;
            this.numIncrements = numIncrements;
            this.hlog = log;
            this.count = 0;
            this.appendNoSync = appendNoSync;
            this.tableName = tableName;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.currentTimeMillis();
            byte[] key = Bytes.toBytes((String)"thisisakey");
            KeyValue kv = new KeyValue(key, now);
            WALEdit walEdit = new WALEdit();
            walEdit.add(kv);
            HRegionInfo hri = this.region.getRegionInfo();
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor(Bytes.toBytes((String)"f1")));
            boolean isMetaRegion = false;
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.numIncrements; ++i) {
                try {
                    if (this.appendNoSync) {
                        this.hlog.appendNoSync(hri, this.tableName, walEdit, HConstants.DEFAULT_CLUSTER_ID, now, htd);
                    } else {
                        this.hlog.append(hri, this.tableName, walEdit, now, htd);
                    }
                }
                catch (IOException e) {
                    TestHLogBench.log("Fatal exception: " + e);
                    e.printStackTrace();
                }
                ++this.count;
            }
            long tot = System.currentTimeMillis() - start;
            Object object = lock;
            synchronized (object) {
                totalTime = (int)((long)totalTime + tot);
            }
        }
    }
}

