/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWALActionsListener {
    protected static final Log LOG = LogFactory.getLog(TestWALActionsListener.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] SOME_BYTES = Bytes.toBytes((String)"t");
    private static FileSystem fs;
    private static Path oldLogDir;
    private static Path logDir;
    private static Configuration conf;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.maxlogs", 5);
        fs = FileSystem.get((Configuration)conf);
        oldLogDir = new Path(TEST_UTIL.getDataTestDir(), ".oldlogs");
        logDir = new Path(TEST_UTIL.getDataTestDir(), ".logs");
    }

    @Before
    public void setUp() throws Exception {
        fs.delete(logDir, true);
        fs.delete(oldLogDir, true);
    }

    @After
    public void tearDown() throws Exception {
        this.setUp();
    }

    @Test
    public void testActionListener() throws Exception {
        DummyWALActionsListener observer = new DummyWALActionsListener();
        ArrayList<DummyWALActionsListener> list = new ArrayList<DummyWALActionsListener>();
        list.add(observer);
        DummyWALActionsListener laterobserver = new DummyWALActionsListener();
        HLog hlog = new HLog(fs, logDir, oldLogDir, conf, list, null);
        HRegionInfo hri = new HRegionInfo(SOME_BYTES, SOME_BYTES, SOME_BYTES, false);
        for (int i = 0; i < 20; ++i) {
            byte[] b = Bytes.toBytes((String)(i + ""));
            KeyValue kv = new KeyValue(b, b, b);
            WALEdit edit = new WALEdit();
            edit.add(kv);
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor(b));
            HLogKey key = new HLogKey(b, b, 0L, 0L, HConstants.DEFAULT_CLUSTER_ID);
            hlog.append(hri, key, edit, htd, true);
            if (i == 10) {
                hlog.registerWALActionsListener((WALActionsListener)laterobserver);
            }
            if (i % 2 != 0) continue;
            hlog.rollWriter();
        }
        hlog.close();
        hlog.closeAndDelete();
        Assert.assertEquals((long)11L, (long)observer.preLogRollCounter);
        Assert.assertEquals((long)11L, (long)observer.postLogRollCounter);
        Assert.assertEquals((long)5L, (long)laterobserver.preLogRollCounter);
        Assert.assertEquals((long)5L, (long)laterobserver.postLogRollCounter);
        Assert.assertEquals((long)2L, (long)observer.closedCount);
    }

    static class DummyWALActionsListener
    implements WALActionsListener {
        public int preLogRollCounter = 0;
        public int postLogRollCounter = 0;
        public int closedCount = 0;

        DummyWALActionsListener() {
        }

        public void preLogRoll(Path oldFile, Path newFile) {
            ++this.preLogRollCounter;
        }

        public void postLogRoll(Path oldFile, Path newFile) {
            ++this.postLogRollCounter;
        }

        public void preLogArchive(Path oldFile, Path newFile) {
        }

        public void postLogArchive(Path oldFile, Path newFile) {
        }

        public void logRollRequested() {
        }

        public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
        }

        public void logCloseRequested() {
            ++this.closedCount;
        }

        public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
        }
    }
}

