/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMasterReplication {
    private static final Log LOG = LogFactory.getLog(TestReplicationBase.class);
    private Configuration conf1;
    private Configuration conf2;
    private Configuration conf3;
    private HBaseTestingUtility utility1;
    private HBaseTestingUtility utility2;
    private HBaseTestingUtility utility3;
    private MiniZooKeeperCluster miniZK;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 10;
    private static final byte[] tableName = Bytes.toBytes((String)"test");
    private static final byte[] famName = Bytes.toBytes((String)"f");
    private static final byte[] row = Bytes.toBytes((String)"row");
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] row2 = Bytes.toBytes((String)"row2");
    private static final byte[] noRepfamName = Bytes.toBytes((String)"norep");
    private static final byte[] count = Bytes.toBytes((String)"count");
    private static final byte[] put = Bytes.toBytes((String)"put");
    private static final byte[] delete = Bytes.toBytes((String)"delete");
    private HTableDescriptor table;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Before
    public void setUp() throws Exception {
        this.conf1 = HBaseConfiguration.create();
        this.conf1.set("zookeeper.znode.parent", "/1");
        this.conf1.setInt("hbase.regionserver.hlog.blocksize", 20480);
        this.conf1.setInt("replication.source.size.capacity", 1024);
        this.conf1.setLong("replication.source.sleepforretries", 100L);
        this.conf1.setInt("hbase.regionserver.maxlogs", 10);
        this.conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        this.conf1.setBoolean("hbase.replication", true);
        this.conf1.setBoolean("dfs.support.append", true);
        this.conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        this.conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{CoprocessorCounter.class.getName()});
        this.utility1 = new HBaseTestingUtility(this.conf1);
        this.utility1.startMiniZKCluster();
        this.miniZK = this.utility1.getZkCluster();
        this.utility1.setZkCluster(this.miniZK);
        new ZooKeeperWatcher(this.conf1, "cluster1", null, true);
        this.conf2 = new Configuration(this.conf1);
        this.conf2.set("zookeeper.znode.parent", "/2");
        this.utility2 = new HBaseTestingUtility(this.conf2);
        this.utility2.setZkCluster(this.miniZK);
        new ZooKeeperWatcher(this.conf2, "cluster2", null, true);
        this.conf3 = new Configuration(this.conf1);
        this.conf3.set("zookeeper.znode.parent", "/3");
        this.utility3 = new HBaseTestingUtility(this.conf3);
        this.utility3.setZkCluster(this.miniZK);
        new ZooKeeperWatcher(this.conf3, "cluster3", null, true);
        this.table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        this.table.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.table.addFamily(fam);
    }

    @After
    public void tearDown() throws IOException {
        this.miniZK.shutdown();
    }

    @Test(timeout=300000L)
    public void testCyclicReplication() throws Exception {
        LOG.info((Object)"testCyclicReplication");
        this.utility1.startMiniCluster();
        this.utility2.startMiniCluster();
        this.utility3.startMiniCluster();
        ReplicationAdmin admin1 = new ReplicationAdmin(this.conf1);
        ReplicationAdmin admin2 = new ReplicationAdmin(this.conf2);
        ReplicationAdmin admin3 = new ReplicationAdmin(this.conf3);
        new HBaseAdmin(this.conf1).createTable(this.table);
        new HBaseAdmin(this.conf2).createTable(this.table);
        new HBaseAdmin(this.conf3).createTable(this.table);
        HTable htable1 = new HTable(this.conf1, tableName);
        htable1.setWriteBufferSize(1024L);
        HTable htable2 = new HTable(this.conf2, tableName);
        htable2.setWriteBufferSize(1024L);
        HTable htable3 = new HTable(this.conf3, tableName);
        htable3.setWriteBufferSize(1024L);
        admin1.addPeer("1", this.utility2.getClusterKey());
        admin2.addPeer("1", this.utility3.getClusterKey());
        admin3.addPeer("1", this.utility1.getClusterKey());
        this.putAndWait(row, famName, htable1, htable3);
        this.check(row, famName, htable2);
        this.putAndWait(row1, famName, htable2, htable1);
        this.check(row, famName, htable3);
        this.putAndWait(row2, famName, htable3, htable2);
        this.check(row, famName, htable1);
        this.deleteAndWait(row, htable1, htable3);
        this.deleteAndWait(row1, htable2, htable1);
        this.deleteAndWait(row2, htable3, htable2);
        Assert.assertEquals((String)"Puts were replicated back ", (long)3L, (long)this.getCount(htable1, put));
        Assert.assertEquals((String)"Puts were replicated back ", (long)3L, (long)this.getCount(htable2, put));
        Assert.assertEquals((String)"Puts were replicated back ", (long)3L, (long)this.getCount(htable3, put));
        Assert.assertEquals((String)"Deletes were replicated back ", (long)3L, (long)this.getCount(htable1, delete));
        Assert.assertEquals((String)"Deletes were replicated back ", (long)3L, (long)this.getCount(htable2, delete));
        Assert.assertEquals((String)"Deletes were replicated back ", (long)3L, (long)this.getCount(htable3, delete));
        this.utility3.shutdownMiniCluster();
        this.utility2.shutdownMiniCluster();
        this.utility1.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testSimplePutDelete() throws Exception {
        LOG.info((Object)"testSimplePutDelete");
        this.utility1.startMiniCluster();
        this.utility2.startMiniCluster();
        ReplicationAdmin admin1 = new ReplicationAdmin(this.conf1);
        ReplicationAdmin admin2 = new ReplicationAdmin(this.conf2);
        new HBaseAdmin(this.conf1).createTable(this.table);
        new HBaseAdmin(this.conf2).createTable(this.table);
        HTable htable1 = new HTable(this.conf1, tableName);
        htable1.setWriteBufferSize(1024L);
        HTable htable2 = new HTable(this.conf2, tableName);
        htable2.setWriteBufferSize(1024L);
        admin1.addPeer("1", this.utility2.getClusterKey());
        admin2.addPeer("1", this.utility1.getClusterKey());
        this.putAndWait(row, famName, htable1, htable2);
        this.putAndWait(row1, famName, htable2, htable1);
        Assert.assertEquals((String)"Puts were replicated back ", (long)2L, (long)this.getCount(htable1, put));
        this.deleteAndWait(row, htable1, htable2);
        Assert.assertEquals((String)"Puts were replicated back ", (long)2L, (long)this.getCount(htable2, put));
        this.deleteAndWait(row1, htable2, htable1);
        Assert.assertEquals((String)"Deletes were replicated back ", (long)2L, (long)this.getCount(htable1, delete));
        this.utility2.shutdownMiniCluster();
        this.utility1.shutdownMiniCluster();
    }

    private int getCount(HTable t, byte[] type) throws IOException {
        Get test = new Get(row);
        test.setAttribute("count", new byte[0]);
        Result res = t.get(test);
        return Bytes.toInt((byte[])res.getValue(count, type));
    }

    private void deleteAndWait(byte[] row, HTable source, HTable target) throws Exception {
        Delete del = new Delete(row);
        source.delete(del);
        Get get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = target.get(get)).size() < 1) break;
            LOG.info((Object)"Row not deleted");
            Thread.sleep(500L);
        }
    }

    private void check(byte[] row, byte[] fam, HTable t) throws IOException {
        Get get = new Get(row);
        Result res = t.get(get);
        if (res.size() == 0) {
            Assert.fail((String)"Row is missing");
        }
    }

    private void putAndWait(byte[] row, byte[] fam, HTable source, HTable target) throws Exception {
        Put put = new Put(row);
        put.add(fam, row, row);
        source.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = target.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(500L);
        }
    }

    public static class CoprocessorCounter
    extends BaseRegionObserver {
        private int nCount = 0;
        private int nDelete = 0;

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, boolean writeToWAL) throws IOException {
            ++this.nCount;
        }

        public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, boolean writeToWAL) throws IOException {
            ++this.nDelete;
        }

        public void preGet(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<KeyValue> result) throws IOException {
            if (get.getAttribute("count") != null) {
                result.clear();
                result.add(new KeyValue(count, count, delete, Bytes.toBytes((int)this.nDelete)));
                result.add(new KeyValue(count, count, put, Bytes.toBytes((int)this.nCount)));
                c.bypass();
            }
        }
    }
}

