/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.ResourceConfig;
import org.apache.hadoop.hbase.rest.filter.GzipFilter;
import org.apache.hadoop.util.StringUtils;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class HBaseRESTTestingUtility {
    static final Log LOG = LogFactory.getLog(HBaseRESTTestingUtility.class);
    private int testServletPort;
    private Server server;

    public int getServletPort() {
        return this.testServletPort;
    }

    public void startServletContainer(Configuration conf) throws Exception {
        if (this.server != null) {
            LOG.error((Object)"ServletContainer already running");
            return;
        }
        RESTServlet.getInstance((Configuration)conf);
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", ResourceConfig.class.getCanonicalName());
        sh.setInitParameter("com.sun.jersey.config.property.packages", "jetty");
        LOG.info((Object)("configured " + ServletContainer.class.getName()));
        this.server = new Server(0);
        this.server.setSendServerVersion(false);
        this.server.setSendDateHeader(false);
        Context context = new Context((HandlerContainer)this.server, "/", 1);
        context.addServlet(sh, "/*");
        context.addFilter(GzipFilter.class, "/*", 0);
        this.server.start();
        this.testServletPort = this.server.getConnectors()[0].getLocalPort();
        LOG.info((Object)("started " + this.server.getClass().getName() + " on port " + this.testServletPort));
    }

    public void shutdownServletContainer() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
                RESTServlet.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }
}

