/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.StorageClusterVersionModel;
import org.apache.hadoop.hbase.rest.model.VersionModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestVersionResource {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        context = JAXBContext.newInstance((Class[])new Class[]{VersionModel.class, StorageClusterVersionModel.class});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void validate(VersionModel model) {
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getRESTVersion());
        Assert.assertEquals((Object)model.getRESTVersion(), (Object)"0.0.2");
        String osVersion = model.getOSVersion();
        Assert.assertNotNull((Object)osVersion);
        Assert.assertTrue((boolean)osVersion.contains(System.getProperty("os.name")));
        Assert.assertTrue((boolean)osVersion.contains(System.getProperty("os.version")));
        Assert.assertTrue((boolean)osVersion.contains(System.getProperty("os.arch")));
        String jvmVersion = model.getJVMVersion();
        Assert.assertNotNull((Object)jvmVersion);
        Assert.assertTrue((boolean)jvmVersion.contains(System.getProperty("java.vm.vendor")));
        Assert.assertTrue((boolean)jvmVersion.contains(System.getProperty("java.version")));
        Assert.assertTrue((boolean)jvmVersion.contains(System.getProperty("java.vm.version")));
        Assert.assertNotNull((Object)model.getServerVersion());
        String jerseyVersion = model.getJerseyVersion();
        Assert.assertNotNull((Object)jerseyVersion);
        Assert.assertEquals((Object)jerseyVersion, (Object)ServletContainer.class.getPackage().getImplementationVersion());
    }

    @Test
    public void testGetStargateVersionText() throws IOException {
        Response response = client.get("/version", "text/plain");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"text/plain", (Object)response.getHeader("content-type"));
        String body = Bytes.toString((byte[])response.getBody());
        Assert.assertTrue((body.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)body.contains("0.0.2"));
        Assert.assertTrue((boolean)body.contains(System.getProperty("java.vm.vendor")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("java.version")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("java.vm.version")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("os.name")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("os.version")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("os.arch")));
        Assert.assertTrue((boolean)body.contains(ServletContainer.class.getPackage().getImplementationVersion()));
    }

    @Test
    public void testGetStargateVersionXML() throws IOException, JAXBException {
        Response response = client.get("/version", "text/xml");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        VersionModel model = (VersionModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        TestVersionResource.validate(model);
    }

    @Test
    public void testGetStargateVersionJSON() throws IOException {
        Response response = client.get("/version", "application/json");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
    }

    @Test
    public void testGetStargateVersionPB() throws IOException {
        Response response = client.get("/version", "application/x-protobuf");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        VersionModel model = new VersionModel();
        model.getObjectFromMessage(response.getBody());
        TestVersionResource.validate(model);
        response = client.get("/version", "application/protobuf");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"application/protobuf", (Object)response.getHeader("content-type"));
        model = new VersionModel();
        model.getObjectFromMessage(response.getBody());
        TestVersionResource.validate(model);
    }

    @Test
    public void testGetStorageClusterVersionText() throws IOException {
        Response response = client.get("/version/cluster", "text/plain");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"text/plain", (Object)response.getHeader("content-type"));
    }

    @Test
    public void testGetStorageClusterVersionXML() throws IOException, JAXBException {
        Response response = client.get("/version/cluster", "text/xml");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        StorageClusterVersionModel clusterVersionModel = (StorageClusterVersionModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertNotNull((Object)clusterVersionModel);
        Assert.assertNotNull((Object)clusterVersionModel.getVersion());
    }

    @Test
    public void doTestGetStorageClusterVersionJSON() throws IOException {
        Response response = client.get("/version/cluster", "application/json");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
    }
}

