/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellModel
extends TestCase {
    private static final long TIMESTAMP = 1245219839331L;
    private static final byte[] COLUMN = Bytes.toBytes((String)"testcolumn");
    private static final byte[] VALUE = Bytes.toBytes((String)"testvalue");
    private static final String AS_XML = "<Cell timestamp=\"1245219839331\" column=\"dGVzdGNvbHVtbg==\">dGVzdHZhbHVl</Cell>";
    private static final String AS_PB = "Egp0ZXN0Y29sdW1uGOO6i+eeJCIJdGVzdHZhbHVl";
    private JAXBContext context;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public TestCellModel() throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{CellModel.class});
    }

    private CellModel buildTestModel() {
        CellModel model = new CellModel();
        model.setColumn(COLUMN);
        model.setTimestamp(1245219839331L);
        model.setValue(VALUE);
        return model;
    }

    private String toXML(CellModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private CellModel fromXML(String xml) throws JAXBException {
        return (CellModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    private byte[] toPB(CellModel model) {
        return model.createProtobufOutput();
    }

    private CellModel fromPB(String pb) throws IOException {
        return (CellModel)new CellModel().getObjectFromMessage(Base64.decode((String)AS_PB));
    }

    private void checkModel(CellModel model) {
        TestCellModel.assertTrue((boolean)Bytes.equals((byte[])model.getColumn(), (byte[])COLUMN));
        TestCellModel.assertTrue((boolean)Bytes.equals((byte[])model.getValue(), (byte[])VALUE));
        TestCellModel.assertTrue((boolean)model.hasUserTimestamp());
        TestCellModel.assertEquals((long)model.getTimestamp(), (long)1245219839331L);
    }

    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    public void testFromXML() throws Exception {
        this.checkModel(this.fromXML(AS_XML));
    }

    public void testFromPB() throws Exception {
        this.checkModel(this.fromPB(AS_PB));
    }
}

