/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.rest.model.StorageClusterStatusModel;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestStorageClusterStatusModel
extends TestCase {
    private static final String AS_XML = "<ClusterStatus requests=\"0\" regions=\"2\" averageLoad=\"1.0\"><DeadNodes/><LiveNodes><Node startCode=\"1245219839331\" requests=\"0\" name=\"test1\" maxHeapSizeMB=\"1024\" heapSizeMB=\"128\"><Region stores=\"1\" storefiles=\"1\" storefileSizeMB=\"0\" storefileIndexSizeMB=\"0\" name=\"LVJPT1QtLCww\" memstoreSizeMB=\"0\" readRequestsCount=\"1\" writeRequestsCount=\"2\" rootIndexSizeKB=\"1\" totalStaticIndexSizeKB=\"1\" totalStaticBloomSizeKB=\"1\" totalCompactingKVs=\"1\" currentCompactedKVs=\"1\"/></Node><Node startCode=\"1245239331198\" requests=\"0\" name=\"test2\" maxHeapSizeMB=\"1024\" heapSizeMB=\"512\"><Region stores=\"1\" storefiles=\"1\" storefileSizeMB=\"0\" storefileIndexSizeMB=\"0\" name=\"Lk1FVEEuLCwxMjQ2MDAwMDQzNzI0\" memstoreSizeMB=\"0\" readRequestsCount=\"1\" writeRequestsCount=\"2\" rootIndexSizeKB=\"1\" totalStaticIndexSizeKB=\"1\" totalStaticBloomSizeKB=\"1\" totalCompactingKVs=\"1\" currentCompactedKVs=\"1\"/></Node></LiveNodes></ClusterStatus>";
    private static final String AS_PB = "CjsKBXRlc3QxEOO6i+eeJBgAIIABKIAIMiMKCS1ST09ULSwsMBABGAEgACgAMAA4AUACSAFQAVgBYAFoAQpHCgV0ZXN0MhD+krHwniQYACCABCiACDIvChUuTUVUQS4sLDEyNDYwMDAwNDM3MjQQARgBIAAoADAAOAFAAkgBUAFYAWABaAEYAiAAKQAAAAAAAPA/";
    private JAXBContext context;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public TestStorageClusterStatusModel() throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{StorageClusterStatusModel.class});
    }

    private StorageClusterStatusModel buildTestModel() {
        StorageClusterStatusModel model = new StorageClusterStatusModel();
        model.setRegions(2);
        model.setRequests(0);
        model.setAverageLoad(1.0);
        model.addLiveNode("test1", 1245219839331L, 128, 1024).addRegion(Bytes.toBytes((String)"-ROOT-,,0"), 1, 1, 0, 0, 0, 1L, 2L, 1, 1, 1, 1L, 1L);
        model.addLiveNode("test2", 1245239331198L, 512, 1024).addRegion(Bytes.toBytes((String)".META.,,1246000043724"), 1, 1, 0, 0, 0, 1L, 2L, 1, 1, 1, 1L, 1L);
        return model;
    }

    private String toXML(StorageClusterStatusModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private StorageClusterStatusModel fromXML(String xml) throws JAXBException {
        return (StorageClusterStatusModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    private byte[] toPB(StorageClusterStatusModel model) {
        return model.createProtobufOutput();
    }

    private StorageClusterStatusModel fromPB(String pb) throws IOException {
        return (StorageClusterStatusModel)new StorageClusterStatusModel().getObjectFromMessage(Base64.decode((String)AS_PB));
    }

    private void checkModel(StorageClusterStatusModel model) {
        TestStorageClusterStatusModel.assertEquals((int)model.getRegions(), (int)2);
        TestStorageClusterStatusModel.assertEquals((int)model.getRequests(), (int)0);
        TestStorageClusterStatusModel.assertEquals((Object)model.getAverageLoad(), (Object)1.0);
        Iterator nodes = model.getLiveNodes().iterator();
        StorageClusterStatusModel.Node node = (StorageClusterStatusModel.Node)nodes.next();
        TestStorageClusterStatusModel.assertEquals((String)node.getName(), (String)"test1");
        TestStorageClusterStatusModel.assertEquals((long)node.getStartCode(), (long)1245219839331L);
        TestStorageClusterStatusModel.assertEquals((int)node.getHeapSizeMB(), (int)128);
        TestStorageClusterStatusModel.assertEquals((int)node.getMaxHeapSizeMB(), (int)1024);
        Iterator regions = node.getRegions().iterator();
        StorageClusterStatusModel.Node.Region region = (StorageClusterStatusModel.Node.Region)regions.next();
        TestStorageClusterStatusModel.assertTrue((boolean)Bytes.toString((byte[])region.getName()).equals("-ROOT-,,0"));
        TestStorageClusterStatusModel.assertEquals((int)region.getStores(), (int)1);
        TestStorageClusterStatusModel.assertEquals((int)region.getStorefiles(), (int)1);
        TestStorageClusterStatusModel.assertEquals((int)region.getStorefileSizeMB(), (int)0);
        TestStorageClusterStatusModel.assertEquals((int)region.getMemstoreSizeMB(), (int)0);
        TestStorageClusterStatusModel.assertEquals((int)region.getStorefileIndexSizeMB(), (int)0);
        TestStorageClusterStatusModel.assertEquals((long)region.getReadRequestsCount(), (long)1L);
        TestStorageClusterStatusModel.assertEquals((long)region.getWriteRequestsCount(), (long)2L);
        TestStorageClusterStatusModel.assertEquals((int)region.getRootIndexSizeKB(), (int)1);
        TestStorageClusterStatusModel.assertEquals((int)region.getTotalStaticIndexSizeKB(), (int)1);
        TestStorageClusterStatusModel.assertEquals((int)region.getTotalStaticBloomSizeKB(), (int)1);
        TestStorageClusterStatusModel.assertEquals((long)region.getTotalCompactingKVs(), (long)1L);
        TestStorageClusterStatusModel.assertEquals((long)region.getCurrentCompactedKVs(), (long)1L);
        TestStorageClusterStatusModel.assertFalse((boolean)regions.hasNext());
        node = (StorageClusterStatusModel.Node)nodes.next();
        TestStorageClusterStatusModel.assertEquals((String)node.getName(), (String)"test2");
        TestStorageClusterStatusModel.assertEquals((long)node.getStartCode(), (long)1245239331198L);
        TestStorageClusterStatusModel.assertEquals((int)node.getHeapSizeMB(), (int)512);
        TestStorageClusterStatusModel.assertEquals((int)node.getMaxHeapSizeMB(), (int)1024);
        regions = node.getRegions().iterator();
        region = (StorageClusterStatusModel.Node.Region)regions.next();
        TestStorageClusterStatusModel.assertEquals((String)Bytes.toString((byte[])region.getName()), (String)".META.,,1246000043724");
        TestStorageClusterStatusModel.assertEquals((int)region.getStores(), (int)1);
        TestStorageClusterStatusModel.assertEquals((int)region.getStorefiles(), (int)1);
        TestStorageClusterStatusModel.assertEquals((int)region.getStorefileSizeMB(), (int)0);
        TestStorageClusterStatusModel.assertEquals((int)region.getMemstoreSizeMB(), (int)0);
        TestStorageClusterStatusModel.assertEquals((int)region.getStorefileIndexSizeMB(), (int)0);
        TestStorageClusterStatusModel.assertEquals((long)region.getReadRequestsCount(), (long)1L);
        TestStorageClusterStatusModel.assertEquals((long)region.getWriteRequestsCount(), (long)2L);
        TestStorageClusterStatusModel.assertEquals((int)region.getRootIndexSizeKB(), (int)1);
        TestStorageClusterStatusModel.assertEquals((int)region.getTotalStaticIndexSizeKB(), (int)1);
        TestStorageClusterStatusModel.assertEquals((int)region.getTotalStaticBloomSizeKB(), (int)1);
        TestStorageClusterStatusModel.assertEquals((long)region.getTotalCompactingKVs(), (long)1L);
        TestStorageClusterStatusModel.assertEquals((long)region.getCurrentCompactedKVs(), (long)1L);
        TestStorageClusterStatusModel.assertFalse((boolean)regions.hasNext());
        TestStorageClusterStatusModel.assertFalse((boolean)nodes.hasNext());
    }

    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    public void testFromXML() throws Exception {
        this.checkModel(this.fromXML(AS_XML));
    }

    public void testFromPB() throws Exception {
        this.checkModel(this.fromPB(AS_PB));
    }
}

