/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.apache.hadoop.hbase.rest.model.TableSchemaModel;
import org.apache.hadoop.hbase.rest.model.TestColumnSchemaModel;
import org.apache.hadoop.hbase.util.Base64;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTableSchemaModel
extends TestCase {
    public static final String TABLE_NAME = "testTable";
    private static final boolean IS_META = false;
    private static final boolean IS_ROOT = false;
    private static final boolean READONLY = false;
    private static final String AS_XML = "<TableSchema name=\"testTable\" IS_META=\"false\" IS_ROOT=\"false\" READONLY=\"false\"><ColumnSchema name=\"testcolumn\" BLOCKSIZE=\"16384\" BLOOMFILTER=\"NONE\" BLOCKCACHE=\"true\" COMPRESSION=\"GZ\" VERSIONS=\"1\" TTL=\"86400\" IN_MEMORY=\"false\"/></TableSchema>";
    private static final String AS_PB = "Cgl0ZXN0VGFibGUSEAoHSVNfTUVUQRIFZmFsc2USEAoHSVNfUk9PVBIFZmFsc2USEQoIUkVBRE9OTFkSBWZhbHNlGpcBCgp0ZXN0Y29sdW1uEhIKCUJMT0NLU0laRRIFMTYzODQSEwoLQkxPT01GSUxURVISBE5PTkUSEgoKQkxPQ0tDQUNIRRIEdHJ1ZRIRCgtDT01QUkVTU0lPThICR1oSDQoIVkVSU0lPTlMSATESDAoDVFRMEgU4NjQwMBISCglJTl9NRU1PUlkSBWZhbHNlGICjBSABKgJHWigA";
    private JAXBContext context;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public TestTableSchemaModel() throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{ColumnSchemaModel.class, TableSchemaModel.class});
    }

    public static TableSchemaModel buildTestModel() {
        return TestTableSchemaModel.buildTestModel(TABLE_NAME);
    }

    public static TableSchemaModel buildTestModel(String name) {
        TableSchemaModel model = new TableSchemaModel();
        model.setName(name);
        model.__setIsMeta(false);
        model.__setIsRoot(false);
        model.__setReadOnly(false);
        model.addColumnFamily(TestColumnSchemaModel.buildTestModel());
        return model;
    }

    private String toXML(TableSchemaModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private TableSchemaModel fromXML(String xml) throws JAXBException {
        return (TableSchemaModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    private byte[] toPB(TableSchemaModel model) {
        return model.createProtobufOutput();
    }

    private TableSchemaModel fromPB(String pb) throws IOException {
        return (TableSchemaModel)new TableSchemaModel().getObjectFromMessage(Base64.decode((String)AS_PB));
    }

    public static void checkModel(TableSchemaModel model) {
        TestTableSchemaModel.checkModel(model, TABLE_NAME);
    }

    public static void checkModel(TableSchemaModel model, String tableName) {
        TestTableSchemaModel.assertEquals((String)model.getName(), (String)tableName);
        TestTableSchemaModel.assertEquals((boolean)model.__getIsMeta(), (boolean)false);
        TestTableSchemaModel.assertEquals((boolean)model.__getIsRoot(), (boolean)false);
        TestTableSchemaModel.assertEquals((boolean)model.__getReadOnly(), (boolean)false);
        Iterator families = model.getColumns().iterator();
        TestTableSchemaModel.assertTrue((boolean)families.hasNext());
        ColumnSchemaModel family = (ColumnSchemaModel)families.next();
        TestColumnSchemaModel.checkModel(family);
        TestTableSchemaModel.assertFalse((boolean)families.hasNext());
    }

    public void testBuildModel() throws Exception {
        TestTableSchemaModel.checkModel(TestTableSchemaModel.buildTestModel());
    }

    public void testFromXML() throws Exception {
        TestTableSchemaModel.checkModel(this.fromXML(AS_XML));
    }

    public void testFromPB() throws Exception {
        TestTableSchemaModel.checkModel(this.fromPB(AS_PB));
    }
}

