/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.security.User;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestUser {
    private static Log LOG = LogFactory.getLog(TestUser.class);
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testBasicAttributes() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        User user = User.createUserForTesting((Configuration)conf, (String)"simple", (String[])new String[]{"foo"});
        Assert.assertEquals((String)"Username should match", (Object)"simple", (Object)user.getName());
        Assert.assertEquals((String)"Short username should match", (Object)"simple", (Object)user.getShortName());
    }

    @Test
    public void testRunAs() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        final User user = User.createUserForTesting((Configuration)conf, (String)"testuser", (String[])new String[]{"foo"});
        final PrivilegedExceptionAction<String> action = new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException {
                User u = User.getCurrent();
                return u.getName();
            }
        };
        String username = (String)user.runAs((PrivilegedExceptionAction)action);
        Assert.assertEquals((String)"Current user within runAs() should match", (Object)"testuser", (Object)username);
        User user2 = User.createUserForTesting((Configuration)conf, (String)"testuser2", (String[])new String[]{"foo"});
        String username2 = (String)user2.runAs((PrivilegedExceptionAction)action);
        Assert.assertEquals((String)"Second username should match second user", (Object)"testuser2", (Object)username2);
        username = (String)user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return User.getCurrent().getName();
            }
        });
        Assert.assertEquals((String)"User name in runAs() should match", (Object)"testuser", (Object)username);
        user2.runAs(new PrivilegedExceptionAction(){

            public Object run() throws IOException, InterruptedException {
                String nestedName = (String)user.runAs(action);
                Assert.assertEquals((String)"Nest name should match nested user", (Object)"testuser", (Object)nestedName);
                Assert.assertEquals((String)"Current name should match current user", (Object)"testuser2", (Object)User.getCurrent().getName());
                return null;
            }
        });
    }

    @Test
    public void testGetCurrent() throws Exception {
        User user1 = User.getCurrent();
        Assert.assertNotNull((Object)user1.ugi);
        LOG.debug((Object)("User1 is " + user1.getName()));
        for (int i = 0; i < 100; ++i) {
            User u = User.getCurrent();
            Assert.assertNotNull((Object)u);
            Assert.assertEquals((Object)user1.getName(), (Object)u.getName());
        }
    }
}

