/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.ReferenceRegionHFilesTask;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestReferenceRegionHFilesTask {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @Test
    public void testRun() throws IOException {
        FileStatus[] regions;
        FileSystem fs = UTIL.getTestFileSystem();
        Path testdir = UTIL.getDataTestDir();
        Path regionDir = new Path(testdir, "region");
        Path family1 = new Path(regionDir, "fam1");
        Path family2 = new Path(regionDir, "fam2");
        fs.mkdirs(family2);
        Path file1 = new Path(family1, "05f99689ae254693836613d1884c6b63");
        fs.createNewFile(file1);
        Path file2 = new Path(family1, "7ac9898bf41d445aa0003e3d699d5d26");
        fs.createNewFile(file2);
        Path snapshotRegionDir = new Path(testdir, ".snapshot");
        fs.mkdirs(snapshotRegionDir);
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName("name").setTable("table").build();
        ForeignExceptionDispatcher monitor = (ForeignExceptionDispatcher)Mockito.mock(ForeignExceptionDispatcher.class);
        ReferenceRegionHFilesTask task = new ReferenceRegionHFilesTask(snapshot, monitor, regionDir, fs, snapshotRegionDir);
        ReferenceRegionHFilesTask taskSpy = (ReferenceRegionHFilesTask)Mockito.spy((Object)task);
        task.call();
        ((ReferenceRegionHFilesTask)Mockito.verify((Object)taskSpy, (VerificationMode)Mockito.never())).snapshotFailure(Mockito.anyString(), (Exception)Mockito.any(Exception.class));
        ArrayList<String> hfiles = new ArrayList<String>(2);
        for (FileStatus region : regions = FSUtils.listStatus((FileSystem)fs, (Path)snapshotRegionDir)) {
            FileStatus[] fams;
            for (FileStatus fam : fams = FSUtils.listStatus((FileSystem)fs, (Path)region.getPath())) {
                FileStatus[] files;
                for (FileStatus file : files = FSUtils.listStatus((FileSystem)fs, (Path)fam.getPath())) {
                    hfiles.add(file.getPath().getName());
                }
            }
        }
        Assert.assertTrue((String)("Didn't reference :" + file1), (boolean)hfiles.contains(file1.getName()));
        Assert.assertTrue((String)("Didn't reference :" + file1), (boolean)hfiles.contains(file2.getName()));
    }
}

