/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.apache.hadoop.hbase.util.MultiThreadedAction;

public class MultiThreadedWriter
extends MultiThreadedAction {
    private static final Log LOG = LogFactory.getLog(MultiThreadedWriter.class);
    private long minColumnsPerKey = 1L;
    private long maxColumnsPerKey = 10L;
    private Set<HBaseWriterThread> writers = new HashSet<HBaseWriterThread>();
    private boolean isMultiPut = false;
    private BlockingQueue<Long> insertedKeys = new ArrayBlockingQueue<Long>(10000);
    private AtomicLong nextKeyToInsert = new AtomicLong();
    private AtomicLong insertedUpToKey = new AtomicLong();
    private Set<Long> failedKeySet = new ConcurrentSkipListSet<Long>();
    private AtomicLong insertedKeyQueueSize = new AtomicLong();
    private boolean trackInsertedKeys;

    public MultiThreadedWriter(Configuration conf, byte[] tableName, byte[] columnFamily) {
        super(conf, tableName, columnFamily, "W");
    }

    public void setMultiPut(boolean isMultiPut) {
        this.isMultiPut = isMultiPut;
    }

    public void setColumnsPerKey(long minColumnsPerKey, long maxColumnsPerKey) {
        this.minColumnsPerKey = minColumnsPerKey;
        this.maxColumnsPerKey = maxColumnsPerKey;
    }

    @Override
    public void start(long startKey, long endKey, int numThreads) throws IOException {
        super.start(startKey, endKey, numThreads);
        if (this.verbose) {
            LOG.debug((Object)("Inserting keys [" + startKey + ", " + endKey + ")"));
        }
        this.nextKeyToInsert.set(startKey);
        this.insertedUpToKey.set(startKey - 1L);
        for (int i = 0; i < numThreads; ++i) {
            HBaseWriterThread writer = new HBaseWriterThread(i);
            this.writers.add(writer);
        }
        if (this.trackInsertedKeys) {
            new Thread(new InsertedKeysTracker()).start();
            this.numThreadsWorking.incrementAndGet();
        }
        this.startThreads(this.writers);
    }

    public static byte[] longToByteArrayKey(long rowKey) {
        return LoadTestKVGenerator.md5PrefixedKey(rowKey).getBytes();
    }

    @Override
    public void waitForFinish() {
        super.waitForFinish();
        System.out.println("Failed to write keys: " + this.failedKeySet.size());
        for (Long key : this.failedKeySet) {
            System.out.println("Failed to write key: " + key);
        }
    }

    public int getNumWriteFailures() {
        return this.failedKeySet.size();
    }

    public long insertedUpToKey() {
        return this.insertedUpToKey.get();
    }

    public boolean failedToWriteKey(long k) {
        return this.failedKeySet.contains(k);
    }

    @Override
    protected String progressInfo() {
        StringBuilder sb = new StringBuilder();
        MultiThreadedWriter.appendToStatus(sb, "insertedUpTo", this.insertedUpToKey.get());
        MultiThreadedWriter.appendToStatus(sb, "insertedQSize", this.insertedKeyQueueSize.get());
        return sb.toString();
    }

    void setTrackInsertedKeys(boolean enable) {
        this.trackInsertedKeys = enable;
    }

    private class InsertedKeysTracker
    implements Runnable {
        private InsertedKeysTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName(this.getClass().getSimpleName());
            try {
                long expectedKey = MultiThreadedWriter.this.startKey;
                PriorityQueue<Long> sortedKeys = new PriorityQueue<Long>();
                while (expectedKey < MultiThreadedWriter.this.endKey) {
                    Long k;
                    try {
                        k = (Long)MultiThreadedWriter.this.insertedKeys.poll(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"Inserted key tracker thread interrupted", (Throwable)e);
                        break;
                    }
                    if (k == null) continue;
                    if (k == expectedKey) {
                        MultiThreadedWriter.this.insertedUpToKey.set(k);
                        ++expectedKey;
                    } else {
                        sortedKeys.add(k);
                    }
                    while (!sortedKeys.isEmpty() && (k = (Long)sortedKeys.peek()) == expectedKey) {
                        sortedKeys.poll();
                        MultiThreadedWriter.this.insertedUpToKey.set(k);
                        ++expectedKey;
                    }
                    MultiThreadedWriter.this.insertedKeyQueueSize.set(MultiThreadedWriter.this.insertedKeys.size() + sortedKeys.size());
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error in inserted key tracker", (Throwable)ex);
            }
            finally {
                MultiThreadedWriter.this.numThreadsWorking.decrementAndGet();
            }
        }
    }

    private class HBaseWriterThread
    extends Thread {
        private final HTable table;
        private final Random random = new Random();
        private final LoadTestKVGenerator dataGenerator;

        public HBaseWriterThread(int writerId) throws IOException {
            this.dataGenerator = new LoadTestKVGenerator(MultiThreadedWriter.this.minDataSize, MultiThreadedWriter.this.maxDataSize);
            this.setName(this.getClass().getSimpleName() + "_" + writerId);
            this.table = new HTable(MultiThreadedWriter.this.conf, MultiThreadedWriter.this.tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long rowKey;
                while ((rowKey = MultiThreadedWriter.this.nextKeyToInsert.getAndIncrement()) < MultiThreadedWriter.this.endKey) {
                    long numColumns = MultiThreadedWriter.this.minColumnsPerKey + Math.abs(this.random.nextLong()) % (MultiThreadedWriter.this.maxColumnsPerKey - MultiThreadedWriter.this.minColumnsPerKey);
                    MultiThreadedWriter.this.numKeys.addAndGet(1L);
                    if (MultiThreadedWriter.this.isMultiPut) {
                        this.multiPutInsertKey(rowKey, 0L, numColumns);
                    } else {
                        for (long col = 0L; col < numColumns; ++col) {
                            this.insert(rowKey, col);
                        }
                    }
                    if (!MultiThreadedWriter.this.trackInsertedKeys) continue;
                    MultiThreadedWriter.this.insertedKeys.add(rowKey);
                }
            }
            finally {
                try {
                    this.table.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Error closing table", (Throwable)e);
                }
                MultiThreadedWriter.this.numThreadsWorking.decrementAndGet();
            }
        }

        public void insert(long rowKey, long col) {
            Put put = new Put(MultiThreadedWriter.longToByteArrayKey(rowKey));
            String colAsStr = String.valueOf(col);
            put.add(MultiThreadedWriter.this.columnFamily, Bytes.toBytes((String)colAsStr), this.dataGenerator.generateRandomSizeValue(rowKey, colAsStr));
            try {
                long start = System.currentTimeMillis();
                this.table.put(put);
                MultiThreadedWriter.this.numCols.addAndGet(1L);
                MultiThreadedWriter.this.totalOpTimeMs.addAndGet(System.currentTimeMillis() - start);
            }
            catch (IOException e) {
                MultiThreadedWriter.this.failedKeySet.add(rowKey);
                LOG.error((Object)("Failed to insert: " + rowKey));
                e.printStackTrace();
            }
        }

        public void multiPutInsertKey(long rowKey, long startCol, long endCol) {
            if (MultiThreadedWriter.this.verbose) {
                LOG.debug((Object)("Preparing put for key = " + rowKey + ", cols = [" + startCol + ", " + endCol + ")"));
            }
            if (startCol >= endCol) {
                return;
            }
            Put put = new Put(LoadTestKVGenerator.md5PrefixedKey(rowKey).getBytes());
            for (long i = startCol; i < endCol; ++i) {
                String qualStr = String.valueOf(i);
                byte[] columnQualifier = qualStr.getBytes();
                byte[] value = this.dataGenerator.generateRandomSizeValue(rowKey, qualStr);
                put.add(MultiThreadedWriter.this.columnFamily, columnQualifier, value);
            }
            try {
                long start = System.currentTimeMillis();
                this.table.put(put);
                MultiThreadedWriter.this.numCols.addAndGet(endCol - startCol);
                MultiThreadedWriter.this.totalOpTimeMs.addAndGet(System.currentTimeMillis() - start);
            }
            catch (IOException e) {
                MultiThreadedWriter.this.failedKeySet.add(rowKey);
                e.printStackTrace();
            }
        }
    }
}

