/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCompressionTest {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testTestCompression() {
        try {
            CompressionTest.testCompression((Compression.Algorithm)Compression.Algorithm.LZO);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getCause());
        }
        try {
            CompressionTest.testCompression((Compression.Algorithm)Compression.Algorithm.LZO);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertNull((Object)e.getCause());
        }
        Assert.assertFalse((boolean)CompressionTest.testCompression((String)"LZO"));
        Assert.assertTrue((boolean)CompressionTest.testCompression((String)"NONE"));
        Assert.assertTrue((boolean)CompressionTest.testCompression((String)"GZ"));
        if (this.isCompressionAvailable("org.apache.hadoop.io.compress.SnappyCodec")) {
            if (NativeCodeLoader.isNativeCodeLoaded()) {
                try {
                    System.loadLibrary("snappy");
                    try {
                        Configuration conf = new Configuration();
                        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName("org.apache.hadoop.io.compress.SnappyCodec"), (Configuration)conf);
                        DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
                        CompressionOutputStream deflateFilter = codec.createOutputStream((OutputStream)compressedDataBuffer);
                        byte[] data = new byte[1024];
                        DataOutputStream deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));
                        deflateOut.write(data, 0, data.length);
                        deflateOut.flush();
                        deflateFilter.finish();
                        Assert.assertTrue((boolean)CompressionTest.testCompression((String)"SNAPPY"));
                    }
                    catch (UnsatisfiedLinkError ex) {
                    }
                    catch (Exception ex) {
                    }
                }
                catch (UnsatisfiedLinkError ex) {
                    Assert.assertFalse((boolean)CompressionTest.testCompression((String)"SNAPPY"));
                }
            } else {
                Assert.assertFalse((boolean)CompressionTest.testCompression((String)"SNAPPY"));
            }
        } else {
            Assert.assertFalse((boolean)CompressionTest.testCompression((String)"SNAPPY"));
        }
    }

    private boolean isCompressionAvailable(String codecClassName) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(codecClassName);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

