/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestThreads {
    private static final Log LOG = LogFactory.getLog(TestThreads.class);
    private static final int SLEEP_TIME_MS = 5000;
    private static final int TOLERANCE_MS = 250;
    private volatile boolean wasInterrupted;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test(timeout=6000L)
    public void testSleepWithoutInterrupt() throws InterruptedException {
        Thread sleeper = new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.debug((Object)"Sleeper thread: sleeping for 5000");
                Threads.sleepWithoutInterrupt((long)5000L);
                LOG.debug((Object)"Sleeper thread: finished sleeping");
                TestThreads.this.wasInterrupted = Thread.currentThread().isInterrupted();
            }
        });
        LOG.debug((Object)"Starting sleeper thread (5000 ms)");
        sleeper.start();
        long startTime = System.currentTimeMillis();
        LOG.debug((Object)"Main thread: sleeping for 500 ms");
        Threads.sleep((long)500L);
        LOG.debug((Object)"Interrupting the sleeper thread and sleeping for 2000 ms");
        sleeper.interrupt();
        Threads.sleep((long)2000L);
        LOG.debug((Object)"Interrupting the sleeper thread and sleeping for 1000 ms");
        sleeper.interrupt();
        Threads.sleep((long)1000L);
        LOG.debug((Object)"Interrupting the sleeper thread again");
        sleeper.interrupt();
        sleeper.join();
        Assert.assertTrue((String)"sleepWithoutInterrupt did not preserve the thread's interrupted status", (boolean)this.wasInterrupted);
        long timeElapsed = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)("Elapsed time " + timeElapsed + " ms is out of the expected " + "range of the sleep time " + 5000), (Math.abs(timeElapsed - 5000L) < 250L ? 1 : 0) != 0);
        LOG.debug((Object)("Target sleep time: 5000, time elapsed: " + timeElapsed));
    }
}

