/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.zookeeper.HQuorumPeer;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHQuorumPeer {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static int PORT_NO = 21818;
    private Path dataDir;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Before
    public void setup() throws IOException {
        TEST_UTIL.getConfiguration().setInt("hbase.zookeeper.property.clientPort", PORT_NO);
        this.dataDir = TEST_UTIL.getDataTestDir(this.getClass().getName());
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        if (fs.exists(this.dataDir) && !fs.delete(this.dataDir, true)) {
            throw new IOException("Failed cleanup of " + this.dataDir);
        }
        if (!fs.mkdirs(this.dataDir)) {
            throw new IOException("Failed create of " + this.dataDir);
        }
    }

    @Test
    public void testMakeZKProps() {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.zookeeper.property.dataDir", this.dataDir.toString());
        Properties properties = ZKConfig.makeZKProps((Configuration)conf);
        junit.framework.Assert.assertEquals((String)this.dataDir.toString(), (String)((String)properties.get("dataDir")));
        junit.framework.Assert.assertEquals((Object)PORT_NO, (Object)Integer.valueOf(properties.getProperty("clientPort")));
        junit.framework.Assert.assertEquals((Object)"localhost:2888:3888", (Object)properties.get("server.0"));
        junit.framework.Assert.assertEquals(null, (Object)properties.get("server.1"));
        String oldValue = conf.get("hbase.zookeeper.quorum");
        conf.set("hbase.zookeeper.quorum", "a.foo.bar,b.foo.bar,c.foo.bar");
        properties = ZKConfig.makeZKProps((Configuration)conf);
        junit.framework.Assert.assertEquals((Object)this.dataDir.toString(), (Object)properties.get("dataDir"));
        junit.framework.Assert.assertEquals((Object)PORT_NO, (Object)Integer.valueOf(properties.getProperty("clientPort")));
        junit.framework.Assert.assertEquals((Object)"a.foo.bar:2888:3888", (Object)properties.get("server.0"));
        junit.framework.Assert.assertEquals((Object)"b.foo.bar:2888:3888", (Object)properties.get("server.1"));
        junit.framework.Assert.assertEquals((Object)"c.foo.bar:2888:3888", (Object)properties.get("server.2"));
        junit.framework.Assert.assertEquals(null, (Object)properties.get("server.3"));
        conf.set("hbase.zookeeper.quorum", oldValue);
    }

    @Test
    public void testConfigInjection() throws Exception {
        String s = "dataDir=" + this.dataDir.toString() + "\n" + "clientPort=2181\n" + "initLimit=2\n" + "syncLimit=2\n" + "server.0=${hbase.master.hostname}:2888:3888\n" + "server.1=server1:2888:3888\n" + "server.2=server2:2888:3888\n";
        System.setProperty("hbase.master.hostname", "localhost");
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        Configuration conf = TEST_UTIL.getConfiguration();
        Properties properties = ZKConfig.parseZooCfg((Configuration)conf, (InputStream)is);
        junit.framework.Assert.assertEquals((Object)this.dataDir.toString(), (Object)properties.get("dataDir"));
        junit.framework.Assert.assertEquals((Object)2181, (Object)Integer.valueOf(properties.getProperty("clientPort")));
        junit.framework.Assert.assertEquals((Object)"localhost:2888:3888", (Object)properties.get("server.0"));
        HQuorumPeer.writeMyID((Properties)properties);
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parseProperties(properties);
        junit.framework.Assert.assertEquals((String)this.dataDir.toString(), (String)config.getDataDir());
        junit.framework.Assert.assertEquals((int)2181, (int)config.getClientPortAddress().getPort());
        Map servers = config.getServers();
        junit.framework.Assert.assertEquals((int)3, (int)servers.size());
        Assert.assertTrue((boolean)servers.containsKey(0L));
        QuorumPeer.QuorumServer server = (QuorumPeer.QuorumServer)servers.get(0L);
        junit.framework.Assert.assertEquals((String)"localhost", (String)server.addr.getHostName());
        System.setProperty("hbase.master.hostname", "foo.bar");
        is = new ByteArrayInputStream(s.getBytes());
        properties = ZKConfig.parseZooCfg((Configuration)conf, (InputStream)is);
        junit.framework.Assert.assertEquals((Object)"foo.bar:2888:3888", (Object)properties.get("server.0"));
        config.parseProperties(properties);
        servers = config.getServers();
        server = (QuorumPeer.QuorumServer)servers.get(0L);
        junit.framework.Assert.assertEquals((String)"foo.bar", (String)server.addr.getHostName());
    }

    @Test
    public void testShouldAssignDefaultZookeeperClientPort() {
        Configuration config = HBaseConfiguration.create();
        config.clear();
        Properties p = ZKConfig.makeZKProps((Configuration)config);
        Assert.assertNotNull((Object)p);
        junit.framework.Assert.assertEquals((Object)2181, (Object)p.get("clientPort"));
    }
}

