/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestZKTable {
    private static final Log LOG = LogFactory.getLog(TestZKTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    Abortable abortable = new Abortable(){

        public void abort(String why, Throwable e) {
            LOG.info((Object)why, e);
        }

        public boolean isAborted() {
            return false;
        }
    };
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testTableStates() throws ZooKeeperConnectionException, IOException, KeeperException {
        String name = "testDisabled";
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testDisabled", this.abortable, true);
        ZKTable zkt = new ZKTable(zkw);
        Assert.assertFalse((boolean)zkt.isEnabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isEnablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisablingOrDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisabledOrEnablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isTablePresent("testDisabled"));
        zkt.setDisablingTable("testDisabled");
        Assert.assertTrue((boolean)zkt.isDisablingTable("testDisabled"));
        Assert.assertTrue((boolean)zkt.isDisablingOrDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.getDisabledTables().contains("testDisabled"));
        Assert.assertTrue((boolean)zkt.isTablePresent("testDisabled"));
        zkt.setDisabledTable("testDisabled");
        Assert.assertTrue((boolean)zkt.isDisabledTable("testDisabled"));
        Assert.assertTrue((boolean)zkt.isDisablingOrDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisablingTable("testDisabled"));
        Assert.assertTrue((boolean)zkt.getDisabledTables().contains("testDisabled"));
        Assert.assertTrue((boolean)zkt.isTablePresent("testDisabled"));
        zkt.setEnablingTable("testDisabled");
        Assert.assertTrue((boolean)zkt.isEnablingTable("testDisabled"));
        Assert.assertTrue((boolean)zkt.isDisabledOrEnablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.getDisabledTables().contains("testDisabled"));
        Assert.assertTrue((boolean)zkt.isTablePresent("testDisabled"));
        zkt.setEnabledTable("testDisabled");
        Assert.assertTrue((boolean)zkt.isEnabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isEnablingTable("testDisabled"));
        Assert.assertTrue((boolean)zkt.isTablePresent("testDisabled"));
        zkt.setDeletedTable("testDisabled");
        Assert.assertFalse((boolean)zkt.isEnabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isEnablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisablingOrDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisabledOrEnablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isTablePresent("testDisabled"));
    }

    private void runTest9294CompatibilityTest(String tableName, Configuration conf) throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, tableName, this.abortable, true);
        ZKTable zkt = new ZKTable(zkw);
        zkt.setEnabledTable(tableName);
        Assert.assertTrue((ZKTableReadOnly.getTableState((ZooKeeperWatcher)zkw, (String)zkw.masterTableZNode, (String)tableName) == ZKTable.TableState.ENABLED ? 1 : 0) != 0);
        Assert.assertTrue((ZKTableReadOnly.getTableState((ZooKeeperWatcher)zkw, (String)zkw.masterTableZNode92, (String)tableName) == null ? 1 : 0) != 0);
    }

    @Test
    public void test9294Compatibility() throws Exception {
        String tableName = "test9294Compatibility";
        this.runTest9294CompatibilityTest(tableName, TEST_UTIL.getConfiguration());
        tableName = "test9294CompatibilityWithMulti";
        Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        conf.setBoolean("hbase.zookeeper.useMulti", true);
        this.runTest9294CompatibilityTest(tableName, conf);
    }

    @Test
    public void testDisableTableRetry() throws Exception {
        String tableName = "testDisableTableRetry";
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.zookeeper.useMulti", false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "testDisableTableRetry", this.abortable, true);
        ThrowingRecoverableZookeeper throwing = new ThrowingRecoverableZookeeper(zkw);
        ZooKeeperWatcher spyZookeeperWatcher = (ZooKeeperWatcher)Mockito.spy((Object)zkw);
        ((ZooKeeperWatcher)Mockito.doReturn((Object)((Object)throwing)).when((Object)spyZookeeperWatcher)).getRecoverableZooKeeper();
        ZKTable zkt = new ZKTable(spyZookeeperWatcher);
        zkt.setEnabledTable("testDisableTableRetry");
        Assert.assertTrue((boolean)zkt.isEnabledOrDisablingTable("testDisableTableRetry"));
        boolean caughtExpectedException = false;
        try {
            throwing.setThrowExceptionInNumOperations(2);
            zkt.setDisabledTable("testDisableTableRetry");
        }
        catch (KeeperException ke) {
            caughtExpectedException = true;
        }
        Assert.assertTrue((boolean)caughtExpectedException);
        Assert.assertFalse((boolean)zkt.isDisabledTable("testDisableTableRetry"));
        zkt.setDisabledTable("testDisableTableRetry");
        Assert.assertTrue((boolean)zkt.isDisabledTable("testDisableTableRetry"));
        Assert.assertTrue((boolean)ZKTableReadOnly.isDisabledTable((ZooKeeperWatcher)zkw, (String)"testDisableTableRetry"));
    }

    @Test
    public void testEnableTableRetry() throws Exception {
        String tableName = "testEnableTableRetry";
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.zookeeper.useMulti", false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "testEnableTableRetry", this.abortable, true);
        ThrowingRecoverableZookeeper throwing = new ThrowingRecoverableZookeeper(zkw);
        ZooKeeperWatcher spyZookeeperWatcher = (ZooKeeperWatcher)Mockito.spy((Object)zkw);
        ((ZooKeeperWatcher)Mockito.doReturn((Object)((Object)throwing)).when((Object)spyZookeeperWatcher)).getRecoverableZooKeeper();
        ZKTable zkt = new ZKTable(spyZookeeperWatcher);
        zkt.setDisabledTable("testEnableTableRetry");
        Assert.assertTrue((boolean)zkt.isDisabledTable("testEnableTableRetry"));
        boolean caughtExpectedException = false;
        try {
            throwing.throwExceptionInNumOperations = 2;
            zkt.setEnabledTable("testEnableTableRetry");
        }
        catch (KeeperException ke) {
            caughtExpectedException = true;
        }
        Assert.assertTrue((boolean)caughtExpectedException);
        Assert.assertFalse((boolean)zkt.isEnabledTable("testEnableTableRetry"));
        zkt.setEnabledTable("testEnableTableRetry");
        Assert.assertTrue((boolean)zkt.isEnabledTable("testEnableTableRetry"));
        Assert.assertTrue((boolean)ZKTableReadOnly.isEnabledTable((ZooKeeperWatcher)zkw, (String)"testEnableTableRetry"));
    }

    @Test
    public void testDeleteTableRetry() throws Exception {
        String tableName = "testEnableTableRetry";
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.zookeeper.useMulti", false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "testEnableTableRetry", this.abortable, true);
        ThrowingRecoverableZookeeper throwing = new ThrowingRecoverableZookeeper(zkw);
        ZooKeeperWatcher spyZookeeperWatcher = (ZooKeeperWatcher)Mockito.spy((Object)zkw);
        ((ZooKeeperWatcher)Mockito.doReturn((Object)((Object)throwing)).when((Object)spyZookeeperWatcher)).getRecoverableZooKeeper();
        ZKTable zkt = new ZKTable(spyZookeeperWatcher);
        zkt.setDisabledTable("testEnableTableRetry");
        Assert.assertTrue((boolean)zkt.isDisabledTable("testEnableTableRetry"));
        boolean caughtExpectedException = false;
        try {
            throwing.setThrowExceptionInNumOperations(2);
            zkt.setDeletedTable("testEnableTableRetry");
        }
        catch (KeeperException ke) {
            caughtExpectedException = true;
        }
        Assert.assertTrue((boolean)caughtExpectedException);
        Assert.assertTrue((boolean)zkt.isTablePresent("testEnableTableRetry"));
        zkt.setDeletedTable("testEnableTableRetry");
        Assert.assertFalse((boolean)zkt.isTablePresent("testEnableTableRetry"));
        Assert.assertFalse((boolean)ZKTableReadOnly.getDisabledTables((ZooKeeperWatcher)zkw).contains("testEnableTableRetry"));
    }

    class ThrowingRecoverableZookeeper
    extends RecoverableZooKeeper {
        private ZooKeeperWatcher zkw;
        private int throwExceptionInNumOperations;

        public ThrowingRecoverableZookeeper(ZooKeeperWatcher zkw) throws Exception {
            super(ZKConfig.getZKQuorumServersString((Configuration)TEST_UTIL.getConfiguration()), 180000, (Watcher)zkw, 3, 1000);
            this.zkw = zkw;
            this.throwExceptionInNumOperations = 0;
        }

        public void setThrowExceptionInNumOperations(int throwExceptionInNumOperations) {
            this.throwExceptionInNumOperations = throwExceptionInNumOperations;
        }

        private void checkThrowKeeperException() throws KeeperException {
            if (this.throwExceptionInNumOperations == 1) {
                this.throwExceptionInNumOperations = 0;
                throw new KeeperException.DataInconsistencyException();
            }
            if (this.throwExceptionInNumOperations > 0) {
                --this.throwExceptionInNumOperations;
            }
        }

        public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
            this.checkThrowKeeperException();
            return this.zkw.getRecoverableZooKeeper().setData(path, data, version);
        }

        public void delete(String path, int version) throws InterruptedException, KeeperException {
            this.checkThrowKeeperException();
            this.zkw.getRecoverableZooKeeper().delete(path, version);
        }
    }
}

