/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.master.TestActiveMasterManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZooKeeperNodeTracker {
    private static final Log LOG = LogFactory.getLog(TestZooKeeperNodeTracker.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Random rand = new Random();
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testInterruptible() throws IOException, InterruptedException {
        StubAbortable abortable = new StubAbortable();
        ZooKeeperWatcher zk = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testInterruptible", (Abortable)abortable);
        final TestTracker tracker = new TestTracker(zk, "/xyz", abortable);
        tracker.start();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    tracker.blockUntilAvailable();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted", e);
                }
            }
        };
        t.start();
        while (!t.isAlive()) {
            Threads.sleep((long)1L);
        }
        tracker.stop();
        t.join();
    }

    @Test
    public void testNodeTracker() throws Exception {
        StubAbortable abortable = new StubAbortable();
        ZooKeeperWatcher zk = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testNodeTracker", (Abortable)abortable);
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zk, (String)zk.baseZNode);
        String node = ZKUtil.joinZNode((String)zk.baseZNode, (String)new Long(rand.nextLong()).toString());
        byte[] dataOne = Bytes.toBytes((String)"dataOne");
        byte[] dataTwo = Bytes.toBytes((String)"dataTwo");
        TestTracker localTracker = new TestTracker(zk, node, abortable);
        localTracker.start();
        zk.registerListener((ZooKeeperListener)localTracker);
        Assert.assertNull((Object)localTracker.getData(false));
        WaitToGetDataThread thread = new WaitToGetDataThread(zk, node);
        thread.start();
        Assert.assertFalse((boolean)thread.hasData);
        TestTracker secondTracker = new TestTracker(zk, node, null);
        secondTracker.start();
        zk.registerListener((ZooKeeperListener)secondTracker);
        TestingZKListener zkListener = new TestingZKListener(zk, node);
        zk.registerListener((ZooKeeperListener)zkListener);
        Assert.assertEquals((long)0L, (long)zkListener.createdLock.availablePermits());
        ZooKeeper zkconn = new ZooKeeper(ZKConfig.getZKQuorumServersString((Configuration)TEST_UTIL.getConfiguration()), 60000, (Watcher)new StubWatcher());
        zkconn.create(node, dataOne, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zkListener.waitForCreation();
        thread.join();
        Assert.assertNotNull((Object)localTracker.getData(false));
        Assert.assertNotNull((Object)localTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])localTracker.getData(false), (byte[])dataOne));
        Assert.assertTrue((boolean)thread.hasData);
        Assert.assertTrue((boolean)Bytes.equals((byte[])thread.tracker.getData(false), (byte[])dataOne));
        LOG.info((Object)"Successfully got data one");
        Assert.assertNotNull((Object)secondTracker.getData(false));
        Assert.assertNotNull((Object)secondTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])secondTracker.getData(false), (byte[])dataOne));
        LOG.info((Object)"Successfully got data one with the second tracker");
        zkconn.delete(node, -1);
        zkListener.waitForDeletion();
        TestTracker threadTracker = thread.tracker;
        thread = new WaitToGetDataThread(zk, node, threadTracker);
        thread.start();
        Assert.assertFalse((boolean)thread.hasData);
        Assert.assertNull((Object)secondTracker.getData(false));
        Assert.assertNull((Object)localTracker.getData(false));
        LOG.info((Object)"Successfully made unavailable");
        zkconn.create(node, dataTwo, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zkListener.waitForCreation();
        thread.join();
        Assert.assertNotNull((Object)localTracker.getData(false));
        Assert.assertNotNull((Object)localTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])localTracker.getData(false), (byte[])dataTwo));
        Assert.assertNotNull((Object)secondTracker.getData(false));
        Assert.assertNotNull((Object)secondTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])secondTracker.getData(false), (byte[])dataTwo));
        Assert.assertTrue((boolean)thread.hasData);
        Assert.assertTrue((boolean)Bytes.equals((byte[])thread.tracker.getData(false), (byte[])dataTwo));
        LOG.info((Object)"Successfully got data two on all trackers and threads");
        zkconn.setData(node, dataOne, -1);
        zkListener.waitForDataChange();
        Assert.assertNotNull((Object)localTracker.getData(false));
        Assert.assertNotNull((Object)localTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])localTracker.getData(false), (byte[])dataOne));
        Assert.assertNotNull((Object)secondTracker.getData(false));
        Assert.assertNotNull((Object)secondTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])secondTracker.getData(false), (byte[])dataOne));
        Assert.assertTrue((boolean)thread.hasData);
        Assert.assertTrue((boolean)Bytes.equals((byte[])thread.tracker.getData(false), (byte[])dataOne));
        LOG.info((Object)"Successfully got data one following a data change on all trackers and threads");
    }

    public static class StubWatcher
    implements Watcher {
        public void process(WatchedEvent event) {
        }
    }

    public static class StubAbortable
    implements Abortable {
        public void abort(String msg, Throwable t) {
        }

        public boolean isAborted() {
            return false;
        }
    }

    public static class TestingZKListener
    extends ZooKeeperListener {
        private static final Log LOG = LogFactory.getLog(TestActiveMasterManager.NodeDeletionListener.class);
        private Semaphore deletedLock = new Semaphore(0);
        private Semaphore createdLock = new Semaphore(0);
        private Semaphore changedLock = new Semaphore(0);
        private String node;

        public TestingZKListener(ZooKeeperWatcher watcher, String node) {
            super(watcher);
            this.node = node;
        }

        public void nodeDeleted(String path) {
            if (path.equals(this.node)) {
                LOG.debug((Object)("nodeDeleted(" + path + ")"));
                this.deletedLock.release();
            }
        }

        public void nodeCreated(String path) {
            if (path.equals(this.node)) {
                LOG.debug((Object)("nodeCreated(" + path + ")"));
                this.createdLock.release();
            }
        }

        public void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                LOG.debug((Object)("nodeDataChanged(" + path + ")"));
                this.changedLock.release();
            }
        }

        public void waitForDeletion() throws InterruptedException {
            this.deletedLock.acquire();
        }

        public void waitForCreation() throws InterruptedException {
            this.createdLock.acquire();
        }

        public void waitForDataChange() throws InterruptedException {
            this.changedLock.acquire();
        }
    }

    public static class TestTracker
    extends ZooKeeperNodeTracker {
        public TestTracker(ZooKeeperWatcher watcher, String node, Abortable abortable) {
            super(watcher, node, abortable);
        }
    }

    public static class WaitToGetDataThread
    extends Thread {
        TestTracker tracker;
        boolean hasData;

        public WaitToGetDataThread(ZooKeeperWatcher zk, String node) {
            this.tracker = new TestTracker(zk, node, null);
            this.tracker.start();
            zk.registerListener((ZooKeeperListener)this.tracker);
            this.hasData = false;
        }

        public WaitToGetDataThread(ZooKeeperWatcher zk, String node, TestTracker tracker) {
            this.tracker = tracker;
            this.hasData = false;
        }

        @Override
        public void run() {
            LOG.info((Object)"Waiting for data to be available in WaitToGetDataThread");
            try {
                this.tracker.blockUntilAvailable();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LOG.info((Object)"Data now available in tracker from WaitToGetDataThread");
            this.hasData = true;
        }
    }
}

