/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hive.jdbc.HiveBaseResultSet;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.JdbcColumnAttributes;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TCLIServiceConstants;
import org.apache.hive.service.cli.thrift.TColumnDesc;
import org.apache.hive.service.cli.thrift.TFetchOrientation;
import org.apache.hive.service.cli.thrift.TFetchResultsReq;
import org.apache.hive.service.cli.thrift.TFetchResultsResp;
import org.apache.hive.service.cli.thrift.TGetResultSetMetadataReq;
import org.apache.hive.service.cli.thrift.TGetResultSetMetadataResp;
import org.apache.hive.service.cli.thrift.TOperationHandle;
import org.apache.hive.service.cli.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.cli.thrift.TRow;
import org.apache.hive.service.cli.thrift.TSessionHandle;
import org.apache.hive.service.cli.thrift.TTableSchema;
import org.apache.hive.service.cli.thrift.TTypeEntry;
import org.apache.hive.service.cli.thrift.TTypeQualifierValue;
import org.apache.hive.service.cli.thrift.TTypeQualifiers;

public class HiveQueryResultSet
extends HiveBaseResultSet {
    public static final Log LOG = LogFactory.getLog(HiveQueryResultSet.class);
    private TCLIService.Iface client;
    private TOperationHandle stmtHandle;
    private HiveStatement hiveStatement;
    private TSessionHandle sessHandle;
    private int maxRows;
    private int fetchSize;
    private int rowsFetched = 0;
    private List<TRow> fetchedRows;
    private Iterator<TRow> fetchedRowsItr;
    private boolean isClosed = false;
    private boolean emptyResultSet = false;

    protected HiveQueryResultSet(Builder builder) throws SQLException {
        this.client = builder.client;
        this.stmtHandle = builder.stmtHandle;
        this.sessHandle = builder.sessHandle;
        this.fetchSize = builder.fetchSize;
        this.hiveStatement = builder.hiveStatement;
        this.columnNames = new ArrayList();
        this.columnTypes = new ArrayList();
        this.columnAttributes = new ArrayList();
        if (builder.retrieveSchema) {
            this.retrieveSchema();
        } else {
            this.setSchema(builder.colNames, builder.colTypes, builder.colAttributes);
        }
        this.emptyResultSet = builder.emptyResultSet;
        this.maxRows = builder.emptyResultSet ? 0 : builder.maxRows;
    }

    private static JdbcColumnAttributes getColumnAttributes(TPrimitiveTypeEntry primitiveTypeEntry) {
        JdbcColumnAttributes ret = null;
        if (primitiveTypeEntry.isSetTypeQualifiers()) {
            TTypeQualifiers tq = primitiveTypeEntry.getTypeQualifiers();
            switch (primitiveTypeEntry.getType()) {
                case VARCHAR_TYPE: {
                    TTypeQualifierValue val = (TTypeQualifierValue)tq.getQualifiers().get("characterMaximumLength");
                    if (val == null) break;
                    ret = new JdbcColumnAttributes(val.getI32Value(), 0);
                    break;
                }
            }
        }
        return ret;
    }

    private void retrieveSchema() throws SQLException {
        try {
            TGetResultSetMetadataReq metadataReq = new TGetResultSetMetadataReq(this.stmtHandle);
            TGetResultSetMetadataResp metadataResp = this.client.GetResultSetMetadata(metadataReq);
            Utils.verifySuccess(metadataResp.getStatus());
            StringBuilder namesSb = new StringBuilder();
            StringBuilder typesSb = new StringBuilder();
            TTableSchema schema = metadataResp.getSchema();
            if (schema == null || !schema.isSetColumns()) {
                return;
            }
            this.setSchema(new TableSchema(schema));
            List columns = schema.getColumns();
            for (int pos = 0; pos < schema.getColumnsSize(); ++pos) {
                if (pos != 0) {
                    namesSb.append(",");
                    typesSb.append(",");
                }
                String columnName = ((TColumnDesc)columns.get(pos)).getColumnName();
                this.columnNames.add(columnName);
                TPrimitiveTypeEntry primitiveTypeEntry = ((TTypeEntry)((TColumnDesc)columns.get(pos)).getTypeDesc().getTypes().get(0)).getPrimitiveEntry();
                String columnTypeName = (String)TCLIServiceConstants.TYPE_NAMES.get(primitiveTypeEntry.getType());
                this.columnTypes.add(columnTypeName);
                this.columnAttributes.add(HiveQueryResultSet.getColumnAttributes(primitiveTypeEntry));
            }
        }
        catch (SQLException eS) {
            throw eS;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
    }

    private void setSchema(List<String> colNames, List<String> colTypes, List<JdbcColumnAttributes> colAttributes) {
        this.columnNames.addAll(colNames);
        this.columnTypes.addAll(colTypes);
        this.columnAttributes.addAll(colAttributes);
    }

    @Override
    public void close() throws SQLException {
        if (this.hiveStatement != null) {
            this.hiveStatement.closeClientOperation();
        }
        this.client = null;
        this.stmtHandle = null;
        this.hiveStatement = null;
        this.sessHandle = null;
        this.isClosed = true;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        if (this.emptyResultSet || this.maxRows > 0 && this.rowsFetched >= this.maxRows) {
            return false;
        }
        try {
            if (this.fetchedRows == null || !this.fetchedRowsItr.hasNext()) {
                TFetchResultsReq fetchReq = new TFetchResultsReq(this.stmtHandle, TFetchOrientation.FETCH_NEXT, (long)this.fetchSize);
                TFetchResultsResp fetchResp = this.client.FetchResults(fetchReq);
                Utils.verifySuccessWithInfo(fetchResp.getStatus());
                this.fetchedRows = fetchResp.getResults().getRows();
                this.fetchedRowsItr = this.fetchedRows.iterator();
            }
            String rowStr = "";
            if (!this.fetchedRowsItr.hasNext()) {
                return false;
            }
            this.row = this.fetchedRowsItr.next();
            ++this.rowsFetched;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fetched row string: " + rowStr));
            }
        }
        catch (SQLException eS) {
            throw eS;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Error retrieving next row", ex);
        }
        return true;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        return super.getMetaData();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        return this.fetchSize;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public static class Builder {
        private TCLIService.Iface client = null;
        private TOperationHandle stmtHandle = null;
        private TSessionHandle sessHandle = null;
        private HiveStatement hiveStatement = null;
        private int maxRows = 0;
        private boolean retrieveSchema = true;
        private List<String> colNames;
        private List<String> colTypes;
        private List<JdbcColumnAttributes> colAttributes;
        private int fetchSize = 50;
        private boolean emptyResultSet = false;

        public Builder setClient(TCLIService.Iface client) {
            this.client = client;
            return this;
        }

        public Builder setStmtHandle(TOperationHandle stmtHandle) {
            this.stmtHandle = stmtHandle;
            return this;
        }

        public Builder setSessionHandle(TSessionHandle sessHandle) {
            this.sessHandle = sessHandle;
            return this;
        }

        public Builder setHiveStatement(HiveStatement hiveStatement) {
            this.hiveStatement = hiveStatement;
            return this;
        }

        public Builder setMaxRows(int maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public Builder setSchema(List<String> colNames, List<String> colTypes) {
            ArrayList<JdbcColumnAttributes> colAttributes = new ArrayList<JdbcColumnAttributes>();
            for (int idx = 0; idx < colTypes.size(); ++idx) {
                colAttributes.add(null);
            }
            return this.setSchema(colNames, colTypes, colAttributes);
        }

        public Builder setSchema(List<String> colNames, List<String> colTypes, List<JdbcColumnAttributes> colAttributes) {
            this.colNames = new ArrayList<String>();
            this.colNames.addAll(colNames);
            this.colTypes = new ArrayList<String>();
            this.colTypes.addAll(colTypes);
            this.colAttributes = new ArrayList<JdbcColumnAttributes>();
            this.colAttributes.addAll(colAttributes);
            this.retrieveSchema = false;
            return this;
        }

        public Builder setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder setEmptyResultSet(boolean emptyResultSet) {
            this.emptyResultSet = emptyResultSet;
            return this;
        }

        public HiveQueryResultSet build() throws SQLException {
            return new HiveQueryResultSet(this);
        }
    }
}

