/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.messaging.json;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.messaging.AddPartitionMessage;
import org.apache.hive.hcatalog.messaging.CreateDatabaseMessage;
import org.apache.hive.hcatalog.messaging.CreateTableMessage;
import org.apache.hive.hcatalog.messaging.DropDatabaseMessage;
import org.apache.hive.hcatalog.messaging.DropPartitionMessage;
import org.apache.hive.hcatalog.messaging.DropTableMessage;
import org.apache.hive.hcatalog.messaging.MessageDeserializer;
import org.apache.hive.hcatalog.messaging.MessageFactory;
import org.apache.hive.hcatalog.messaging.json.JSONAddPartitionMessage;
import org.apache.hive.hcatalog.messaging.json.JSONCreateDatabaseMessage;
import org.apache.hive.hcatalog.messaging.json.JSONCreateTableMessage;
import org.apache.hive.hcatalog.messaging.json.JSONDropDatabaseMessage;
import org.apache.hive.hcatalog.messaging.json.JSONDropPartitionMessage;
import org.apache.hive.hcatalog.messaging.json.JSONDropTableMessage;
import org.apache.hive.hcatalog.messaging.json.JSONMessageDeserializer;

public class JSONMessageFactory
extends MessageFactory {
    private static JSONMessageDeserializer deserializer = new JSONMessageDeserializer();

    @Override
    public MessageDeserializer getDeserializer() {
        return deserializer;
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public String getMessageFormat() {
        return "json";
    }

    @Override
    public CreateDatabaseMessage buildCreateDatabaseMessage(Database db) {
        return new JSONCreateDatabaseMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, db.getName(), System.currentTimeMillis() / 1000L);
    }

    @Override
    public DropDatabaseMessage buildDropDatabaseMessage(Database db) {
        return new JSONDropDatabaseMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, db.getName(), System.currentTimeMillis() / 1000L);
    }

    @Override
    public CreateTableMessage buildCreateTableMessage(Table table) {
        return new JSONCreateTableMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), System.currentTimeMillis() / 1000L);
    }

    @Override
    public DropTableMessage buildDropTableMessage(Table table) {
        return new JSONDropTableMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), System.currentTimeMillis() / 1000L);
    }

    @Override
    public AddPartitionMessage buildAddPartitionMessage(Table table, Partition partition) {
        return new JSONAddPartitionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, partition.getDbName(), partition.getTableName(), Arrays.asList(JSONMessageFactory.getPartitionKeyValues(table, partition)), System.currentTimeMillis() / 1000L);
    }

    @Override
    public DropPartitionMessage buildDropPartitionMessage(Table table, Partition partition) {
        return new JSONDropPartitionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, partition.getDbName(), partition.getTableName(), Arrays.asList(JSONMessageFactory.getPartitionKeyValues(table, partition)), System.currentTimeMillis() / 1000L);
    }

    private static Map<String, String> getPartitionKeyValues(Table table, Partition partition) {
        LinkedHashMap<String, String> partitionKeys = new LinkedHashMap<String, String>();
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            partitionKeys.put(((FieldSchema)table.getPartitionKeys().get(i)).getName(), (String)partition.getValues().get(i));
        }
        return partitionKeys;
    }
}

